//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

/**
  Base class that defines the standard API for sound classes.  You
  should derive a new class from this one to create a new sound system.

  @author  Bradford W. Mott
  @version $Id: Snd.cxx,v 1.3 1997/05/31 14:01:37 bwmott Exp $
*/

#include "Snd.hxx"

#if defined UNIX_OS
  #include "SndUnix.hxx"
#elif defined MSDOS_OS
  #include "SndDOS.hxx"
#elif defined WIN32
  #include "SndWin32.h"
#elif defined MAC_OS
  #include "SndMac.hxx"
#elif defined OS_2
  #include "SndOS2.hxx"
#endif

//============================================================================
// Class methods which answers the "best" sound object
// for the system we're running on
//============================================================================
Sound* Sound::create()
{
  #if defined UNIX_OS
    return new SoundUnix;
  #elif defined MSDOS_OS
    return new SoundDOS;
  #elif defined WIN32
    return new SoundWin32;
  #elif defined MAC_OS
    return new SoundMac;
  #elif defined OS_2
    return new SoundOS2;
  #else
    return new Sound;
  #endif
}

//============================================================================
// Constructor
//============================================================================
Sound::Sound()
{
}
 
//============================================================================
// Destructor
//============================================================================
Sound::~Sound()
{
}

//============================================================================
// Set the given sound register to the specified value
//============================================================================
void Sound::set(Sound::Register, uByte)
{
  // For the "default" sound class we don't do anything since we're
  // not trying to handle sound
}

