//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

/**
  This is a quick-and-dirty random number generator based on information
  in Chapter 7 of the Numerical Recipes in C book.  It's a simple linear
  congruential generator.

  @author  Bradford W. Mott
  @version $Id: Random.cxx,v 1.2 1997/05/17 19:00:07 bwmott Exp $
*/

#include <time.h>
#include "Random.hxx"

uLong Random::ourSeed = 0;
bool Random::ourSeeded = false;

//============================================================================
// Class member function to set the initial random seed
//============================================================================
void Random::seed(uLong value)
{
  ourSeed = value;
  ourSeeded = true;
}

//============================================================================
// Construct a random object
//============================================================================
Random::Random()
{
  // If we haven't been seeded then seed ourself
  if(!ourSeeded)
  {
    ourSeed = (uLong)time(0);
    ourSeeded = true;
  }

  myValue = ourSeed;
  ourSeed = ((ourSeed * 2416 + 374441) % 1771875);
}
 
//============================================================================
// Answer the next pseudo-random number
//============================================================================
inline uLong Random::next()
{
  return (myValue = (myValue * 2416 + 374441) % 1771875);
}

//============================================================================
// Answer a random uByte
//============================================================================
Random::operator uByte()
{
  return (uByte)next();
}
    
//============================================================================
// Answer a random Byte
//============================================================================
Random::operator Byte()
{
  return (Byte)next();
}

//============================================================================
// Answer a random uWord
//============================================================================
Random::operator uWord()
{
  return (uWord)next();
}
    
//============================================================================
// Answer a random Word
//============================================================================
Random::operator Word()
{
  return (Word)next();
}

//============================================================================
// Answer a random uLong
//============================================================================
Random::operator uLong()
{
  return (uLong)next();
}
    
//============================================================================
// Answer a random Long
//============================================================================
Random::operator Long()
{
  return (Long)next();
}

