//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef CONSOLE_HXX
#define CONSOLE_HXX

class System;

#include "machine.hxx"

/**
  Controls the console switches for the system.

  @author  Bradford W. Mott
  @version $Id: Console.hxx,v 1.2 1997/05/17 19:00:05 bwmott Exp $
*/ 
class Console
{
  public:
    /// Constructor
    Console(System& system);
 
    /// Destructor
    virtual ~Console();

  public:
    /// Answer the value of the console switches
    ubyte switches() const { return mySwitches; }

    /// Update the console switches
    void update();

  private:
    System& mySystem;
    ubyte mySwitches;
    uWord myTimer;
};
#endif

