/***************************************************************************

  This file defines all the widgets used in the control panel
  for yourprog, and some sample callback routines, which are
  called when some appropriately registered button or key action
  takes place.  A few simple ones are given as examples.

  You can find some more general sample widget code
  under the source tree for X11, under src/contrib/examples/Xaw.

*************************************************************************** */

#include <sys/types.h>
#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"
#include <X11/keysym.h>
#include "prog.h"

extern XtCallbackProc run_cback();
extern XtCallbackProc Quit();
extern Boolean RunWorkProcs();

Widget form0, run_cmd, exit_cmd;

/* ARGSUSED */
XtCallbackProc
run_cback(w, client_data, cback_data)
  Widget w;
  XtPointer client_data;
  XtPointer cback_data;
/*
 * This callback defines the actions associated with the run button.
*/
{
  is_running = !is_running;

  if (is_running)
    (void) XtAppAddWorkProc(app_con, RunWorkProcs, NULL);
}

/* ARGSUSED */
XtCallbackProc
Quit(w, client_data, cback_data)
  Widget w;
  XtPointer client_data;
  XtPointer cback_data;
/*
 * This callback defines the actions associated with the 'exit' button.
*/
{
  void exit();

  exit(0);
}

make_prog_widgets()
{
  form0 = XtVaCreateManagedWidget("Form0",
    formWidgetClass, shell,
    XtNfont, panel_data.Font,
    NULL);

/* Run */
  run_cmd = XtVaCreateManagedWidget("Command",
    toggleWidgetClass, form0,
    XtNlabel, (String) "Run",
    XtNstate, (Boolean) False,
    NULL);
  if (mono) set_mono(run_cmd);
  XtAddCallback(run_cmd, XtNcallback,
    (XtCallbackProc) run_cback, (XtPointer) NULL);

/* Exit */
  exit_cmd = XtVaCreateManagedWidget("Command",
    commandWidgetClass, form0,
    XtNlabel, (String) "Exit",
    XtNfromVert, (Widget) run_cmd,
    XtNvertDistance, (int) 10,
    NULL);
  if (mono) set_mono(exit_cmd);
  XtAddCallback(exit_cmd, XtNcallback,
    (XtCallbackProc) Quit, (XtPointer) NULL);

}
