/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgImage.c                                                    */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:44 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Image"
#define ERROR(e) imgError(e,PRGNAME)
#define ARG_ERROR(e,arg) imgArgError(e,arg,PRGNAME)

int main(int argc,char **argv)
{
  it_image *out;
  it_float *ptr;
  int x,y,width=256,height=256;
  double val=0.0;

  IFHELP
    {
      fprintf(stderr,"img%s - Generate a blank image\n",
	      PRGNAME);
      fprintf(stderr,"img%s [width height] [value]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: None\n");
      fprintf(stderr,"  stdout: Float\n");
      exit(0);
    }

  imgStart(PRGNAME);

  if(argc>4)
    ERROR("invalid arguments");
  if(argc==2)
    val=atof(argv[1]);
  if(argc>2)
    {
      width=atoi(argv[1]);
      height=atoi(argv[2]);
    }
  if(argc==4)
    val=atof(argv[3]);

  out=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
  if(out==NULL)
    ERROR("out of memory");

  if(val!=0.0)
    for(y=0;y<height;y++)
      {
	ptr=im_float_row(out,y);
	for(x=0;x<width;x++)
	  *ptr++ =val;
      }

  out->min_value=val;
  out->max_value=val;

  i_write_image_file(stdout,out,IF_BINARY);
  i_destroy_image(out);

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
