/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgAnd.c                                                      */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:30 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "And"
#define OPERATOR &
#define ERROR(e) imgError(e,PRGNAME)
#define ARG_ERROR(e,arg) imgArgError(e,arg,PRGNAME)

int main(int argc,char **argv)
{
  it_image *i1,*i2,*i3;
  int width,height,x,y,val;

  IFHELP
    {
      fprintf(stderr,"img%s - Perform logical AND between images\n",
	      PRGNAME);
      fprintf(stderr,"img%s [filename]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: pbm\n");
      fprintf(stderr,"  stdout: pbm\n");
      fprintf(stderr,"  file: pbm\n");
      exit(0);
    }
  imgStart(PRGNAME);

  if(argc>2)
    ERROR("invalid arguments");

  do {
    i1=i_read_image_file(stdin,IT_BIT,IM_FRAGMENT);
    if(i1==NULL)
      ERROR("can't import image file");
    width=i1->width;
    height=i1->height;

    i2=i_create_image(width,height,IT_BIT,IM_FRAGMENT);
    if(i2==NULL)
      ERROR("out of memory");

    if(argc==2)
      {
	i3=i_load_image(argv[1],-1,IT_BIT,IM_FRAGMENT);
	if(i3==NULL)
	  ARG_ERROR("can't load image %s",argv[1]);
      }
    else
      {
	i3=i_read_image_file(stdin,IT_BIT,IM_FRAGMENT);
	if(i3==NULL)
	  ERROR("can't import image file");
      }
    if(i3->width!=width || i3->height!=height)
      ERROR("images are of different sizes");

    for(y=0;y<height;y++)
	for(x=0;x<width;x++)
	  {
	    val=im_get_bit_value(i1,x,y) OPERATOR im_get_bit_value(i3,x,y);
	    im_put_bit_value(i2,x,y,val&1);
	  }

    i_destroy_image(i1);
    i_destroy_image(i3);
    i_write_image_file(stdout,i2,IF_BINARY);
    i_destroy_image(i2);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
