#include "cthugha.h"
#include "interface.h"
#include "keys.h"
#include "display.h"
#include "information.h"

#include <string.h>

int sel_line = 0;
feature * sel_what = NULL;
char sel_title[256] = "";
cth_feature sel_f_nr = 0;

int selection(feature * what) {

    if(what->nr_entries <= 0)
	return -1;

    /* same selection again, so remove it */
    if( (int_var.mode == IM_selection) && (sel_what == what) ) {
	int_var.mode = IM_main;
	display_remove_text(main_text);
	return 0;
    }

    sel_what = what;
    strcpy(sel_title, "Select ");
    strncat(sel_title, what->name, 255);
    strcat(sel_title, "\n");
    sel_line = what->current;
    if(sel_line < 0)
	sel_line = 0;

    sel_f_nr = what->f_nr;
    
    int_var.mode = IM_selection;

    return 0;
}

#define SEL_SIZE	5

char * name_dest_str(char * name, char * desc) {
    static char str[MAX_NAME_LEN + MAX_DESC_LEN + 1];

    sprintf(str, "%-8s %25s", name, desc);
    str[34] = '\0';
    return str;
}

int sel_pre_key() {
    static char text[20000];				/* text disp. on display */
    char s[256];				/* temporary string */
    int i;

    /* create text for selection */
    strcpy(text, sel_title);
    for(i= sel_line - SEL_SIZE; i < sel_line + SEL_SIZE; i++) {
	if ( i < 0)
	    sprintf(s,"\n");
	else if ( i == sel_line)
	    sprintf(s, ">%34s%4s<\n", 
		    name_dest_str(sel_what->entries[i].name, 
				  sel_what->entries[i].desc),
		    sel_what->entries[i].use ? "ON" : "OFF");
	else if ( i < sel_what->nr_entries)
	    sprintf(s, " %34s%4s \n", 
		    name_dest_str(sel_what->entries[i].name, 
				  sel_what->entries[i].desc),
		    sel_what->entries[i].use ? "ON" : "OFF");
	else
	    strcpy(s, " \n");
	
	strcat( text, s);
    }

    main_text = display_reprint(main_text, text, 0, 'l', 0, TEXT_COLOR_NORMAL);

    return 0;
}

void sel_do_key() {

    switch( int_var.key ) {
    case CK_UP:
	if (sel_line > 0)
	    sel_line --;
	break;
    case CK_DOWN:
	if (sel_line < (sel_what->nr_entries-1))
	    sel_line ++;
	break;
    case CK_PGUP:
	sel_line -= 2*SEL_SIZE-1;
	if ( sel_line < 0)
	    sel_line = 0;
	break;
    case CK_PGDN:
	sel_line += 2*SEL_SIZE+1;
	if ( sel_line >= (sel_what->nr_entries-1))
	    sel_line = sel_what->nr_entries -1;
	break;
    case CK_HOME:
	sel_line = 0;
	break;
    case CK_END:
	sel_line = sel_what->nr_entries -1;
	break;
    case ' ':
	sel_what->entries[sel_line].use = 
	    1 - sel_what->entries[sel_line].use;
	break;
    case CK_ENTER:
	sel_what->entries[sel_line].use = 1;
	int_var.mode = IM_main;
	display_remove_text(main_text);
	change(sel_f_nr, sel_line, 1);
	return;
    }
}

