/*
    CTHUGHA-L							display.h
	
    Funktions to access the Screen.
	- general stuff
	- screen-functions
	- palette-functions
	- text-functions
*/

#ifndef __DISPLAY_H__
#define __DISPLAY_H__

#include <time.h>

#include "cth_buffer.h"
#include "feature.h"

/* 
 *  General stuff 
 */
int init_ncurses();						
int init_display();				/* initialize VGA */
int init_graph_mode();				/* activate graphics-mode */
int exit_graph_mode();				/* return to text-mode */
int exit_display();				/* clean-up */
int exit_ncurses();

int resize_display(int new_width, int new_height);

/*
 * variables, that have to do with the screen size and tiles
 *
 * disp_size: size of the screen in svga-mode
 *            size of the allocated imaged in xwin-mode
 *
 * disp_one_size: size of one drawn buffer (as drawn by a screen function)
 * disp_size: total size of all the drawn buffers
 *
 */
extern xy disp_do_tiles;			/* do tiles or not */
extern xy disp_do_mirror;			/* mirror horiz, vert */

extern xy disp_mirror;

extern xy disp_nr_tiles;			/* nr of tiles to do */
extern xy disp_size;				/* size of drawing area */
extern xy disp_one_size;
extern xy draw_size;				/* size of the drawn image */

extern int bytes_per_line;
extern unsigned char *	active_buffer;		/* buffer next on screen */
extern unsigned char *	passive_buffer;		/* buffer current on screen */
extern unsigned char * active_buffer_rgb[3];
extern unsigned char * passive_buffer_rgb[3];

extern int display_clear;			/* clear screen */
extern int display_mode;			/* graphic mode */
extern int display_direct;			/* draw directly to screen */
extern unsigned char * display_mem;
extern int display_frames;			/* counter for speed-tests */
extern time_t display_start;
extern int display_mit_shm;			/* use MIT-SHM if possible */
extern int display_on_root;			/* display on root window */
extern int bpp;					/* bits per pixel */
extern int bypp;				/* bytes per pixel */
extern unsigned int bitmap_colors[256];		/* "compiled" palette */
extern int rev_byte_order;
enum draw_mode_t {
    DM_direct	= 0,
    DM_tmp_mapped = 1,
    DM_mapped1	= 2,
    DM_mapped2	= 3,
    DM_mapped4	= 4
};
extern enum draw_mode_t draw_mode;		/* how drawing is done */

extern int ncurses_use;

/* 
 *  Stuff about screen-functions
 */
int display();					/* bring the changes to scr. */
int select_screen();				/* select what screen-fkts are
						   used */
#define update_screen		((int (*)(void)) ( screens.entries[screens.current].data ) ) 

extern feature screens;				/* possible screen-functions */
extern char screen_first[256];			/* Start with this func. */
extern int display_syncwait;			/* Wait for sync on display */

int change_mirror_horiz(int to);
int change_mirror_vert(int to);

/* 
 *  Stuff about palettes
 */
int load_palettes();				/* initializiation */
int init_palettes();
int exit_palettes();
typedef unsigned char palette[256][3];		/* one Palette: 256 entries, 
						   each 3 bytes */
extern feature palettes;			/* All palettes */
#define active_palette		((palette *) ( palettes.entries[palettes.current].data ) ) 
extern char palette_first[256];			/* Start with this palette */
int select_palette();
int update_palette();
extern int display_internal_pal;		/* disable internal pal. */
extern int display_external_pal;		/*  disable external pal. */
void cth_setpalette(palette pal, int immed);
void smooth_setpalette();
extern int display_private_cmap;		/* use a private colormap */
void set_rgb_palette();

/* 
 *  Stuff about text-display
 */
#define MAX_TEXT_LINES	255		/* max. nr. of lines to disp */
typedef struct {
    int justification;			/* 'l', 'c', 'r' */
    int time;				/* when was it put on screen */
    int line;				/* line (in pixels) */
    int color;				/* color to use */
    int len;				/* length of this line */
    char* text;				/* text only one line */
} text_line;
typedef struct {
    int n;				/* number of lines */
    text_line lines[MAX_TEXT_LINES];	/* text, line by line */
    int remove;				/* remove after some time */
} text_t;
#define TEXT_COLOR_NORMAL		0
#define TEXT_COLOR_ERROR		1
#define TEXT_COLOR_HIGHLIGHT		2

text_t * display_print(const char * text,	/* what text to display (handles \n) */
		       int line,		/* line number (in lines!) */
		       int justifcation,	/* 'l', 'c', 'r' */
		       int remove,		/* remove after some time, or keep */
		       int color);		/* colorindex to use 255, 254, .. */
text_t * display_reprint(text_t * t,		/* old text (or NULL) */
			 const char * text,	/* what text to display (handles \n) */
			 int line,		/* line number (in lines!) */
			 int justifcation,	/* 'l', 'c', 'r' */
			 int remove,		/* remove after some time, or keep */
			 int color);		/* colorindex to use 255, 254, .. */
text_t * display_add_text(text_t * t, const char * new_text,
			  int line,		/* line number (in lines!) */
			  int justifcation,	/* 'l', 'c', 'r' */
			  int remove,		/* remove after some time, or keep */
			  int color);		/* colorindex to use 255, 254, .. */
int display_scroll_text(text_t * t, int by);
int display_remove_text(text_t * t);		/* clear this text */

extern int display_text_line;			/* display at line */
extern char display_text[MAX_TEXT_LINES][256];	/* text to display */
extern int display_text_on_screen;		/* text is currently on scrn */
extern int display_text_time;
void display_print_string(int x,int y,char* text);
int display_print_clear();
int show_text();
extern int display_text_color[][3];
extern int display_text_colors;

/* 
 *  Stuff for PCX
 */
typedef unsigned char * pcx;			/* Memory for loaded picture */
int init_pcx();					/* initalize pcx */
int select_pcx();
int show_pcx(int upp_left, int correct_color);
void smooth_setpalette(void);
extern int display_use_pcx;			/* allow pcx-usage */
extern feature pcxs;				/* pcx-buffers */
extern pcx * active_pcx;
extern char pcx_first[256];
extern int pcx_count;				/* counter for pcx-display */
int * pcx_palettes;				/* index to corresp. palette */
#define active_pcx	((char*) ( pcxs.entries[pcxs.current].data ) ) 

extern char display_prt_file[256];		/* filename used by PrtScrn */
int save_buffer();
int save_display();

extern char* info_credits[];
extern int info_nr_credits;

#endif


