/*
  Changes by Harald Deischinger to compile with cthugha-L under Linux.
  Changes:
      int -> short
      removed headerfiles dos.h, io.h, conio.h
      cosl -> cos
      sin -> sin

      short -> tint
      unsigned tint -> utint

      const buff
      
      parameter for nr_spirals
      some changes for parameters
*/
/*
//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1994
//


// This is an example program of how to generate rotating tables.
//
// Feel free to change the code, make your own, and send me the 
// resulting .TAB file for inclusion in the next version!!
//
// For more info, check CTHUGHA.DOC (and hope I got around to writing
// that section!
//
*/

#include <stdio.h>
/* 
#include <dos.h>
#include <io.h>
*/
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
/*
#include <conio.h>
*/
#include <time.h>

#define CONST_BUFF
#include "../src/cthugha.h"
#include "../src/cth_buffer.h"

utint map;

#define M_PI 3.14159265358979323846
#define RADEG (180.0/M_PI)

char maptabfile[255];

#define MAX_NR_SPIRALS 64
tint centersX[MAX_NR_SPIRALS];
tint centersY[MAX_NR_SPIRALS];
tint dir[MAX_NR_SPIRALS];

int main(tint argc, char **argv)
{
    tint x,y,map_x,map_y,i;
    tint closest;
    double dist;
    double polar_r,polar_a;
    double delta_r=2.0,delta_a=0.1;
    double temp_y,temp_x;
    double cent_y,cent_x;
    long l;
    int nr_spirals = 1;
    int yinyang = 0;
    double yywidth = 10.0;
    
    FILE *fp;
    
    time(&l);
    srand(l);
    
    
    argc--; argv++;
    if (argc) {
	strcpy(maptabfile,*argv);
    } else {
	
	printf("Gentable usage:\n"
	       "\tgentable tabname.tab [-]<#spirals> <yywidth> <(float)delta_r> <(float)delta_a>\n"
	       "\tIf the first parameter starts with a '-' then the direction of rotation\n"
	       "\tchanges with the radius.\n"
	       "\t#spirals: number of spirals (0 for one centered spiral) (def: %d)\n"
	       "\tyywidth:  Width of section of constant direction (if changing dir.)\n"
	       "\tdelta_r:  change of radius (0 -> simple rotation) (def: %f)\n"
	       "\tdelta_a:  change of angle (def: %f)\n",
	       nr_spirals, delta_r, delta_a);
	exit(1);
    }

/*
    printf("%s %s\n", *(argv+1), *(argv+2));
*/
    
    argc--; argv++;
    if (argc) {
	yinyang = (*argv[0] == '-') ? 1 : 0;

	nr_spirals=atoi((*argv)+yinyang);
	if(nr_spirals == 0) {
	    centersX[0] = BUFF_WIDTH / 2;
	    centersY[0] = BUFF_HEIGHT / 2;
	    dir[0] = 1;
	    nr_spirals = 1;
	} else {
	    nr_spirals=max(min(nr_spirals, MAX_NR_SPIRALS),1);
	    for (i=0; i<nr_spirals; i++) {
		centersX[i]=rand()%BUFF_WIDTH;
		centersY[i]=rand()%BUFF_HEIGHT;
		dir[i]=rand()%5-2;
	    }
	}
    } 
    if ( yinyang) {
	argc--; argv++;
	if (argc) {
	    yywidth=atof(*argv);
	}
    }
    
    argc--; argv++;
    if (argc) {
	delta_r=atof(*argv);
    }
    argc--; argv++;
    if (argc) {
	delta_a=atof(*argv);
    }
    
    
    if ((fp=fopen(maptabfile,"wb"))!=NULL) {
	if( yinyang) 
	    printf("Writing mapping table: %s\n"
		   "  #spirals: %d  yywidth: %f  delta_a: %f  delta_r: %f\n" ,
		   maptabfile, nr_spirals, yywidth, delta_a, delta_r);
	else
	    printf("Writing mapping table: %s\n"
		   "  #spirals: %d  delta_a: %f  delta_r: %f\n" ,
		   maptabfile, nr_spirals, delta_a, delta_r);

	for (y=0; y<BUFF_HEIGHT; y++) {
	    printf("%3d/%3d \r",y+1,BUFF_HEIGHT);
	    
	    for (x=0; x<BUFF_WIDTH; x++) {
		closest=0;
		dist=9999999.0;
		
		temp_x=x;
		temp_y=y;
		for (i=0; i<nr_spirals; i++) {
		    if(dist>(sqrt((temp_x-centersX[i])*(temp_x-centersX[i])+
				  (temp_y-centersY[i])*(temp_y-centersY[i])))){
			closest=i;
			dist=sqrt((temp_x-centersX[i])*(temp_x-centersX[i])+
				  (temp_y-centersY[i])*(temp_y-centersY[i]));
		    }
		}
		
		if ((x==centersX[closest]) && (y==centersY[closest])) {
		    map=0;
		} else {
		    cent_y=centersY[closest];
		    cent_x=centersX[closest];
		    temp_x=abs(x-cent_x);
		    temp_y=abs(y-cent_y);
		    
		    polar_r=sqrt(temp_x*temp_x + temp_y*temp_y);
		    polar_a=atan2((double)(x-cent_x),(double)(y-cent_y));
		    
		    polar_r += (delta_r+(rand()%10)*0.01)*(double)dir[closest];
		    
		    if (polar_r<0)
			polar_r=0.0;
		    
		    if ( yinyang ) {
			
			polar_a -= delta_a * 3.0 *
			    (float)(5-(int)(polar_r/11) % 11)/5.0;

			if (((int)(polar_r/yywidth)%2)) {		
			    polar_a += delta_a;
			} else {
			    polar_a -= delta_a;
			}
		    } else {
			
			polar_a += (delta_a+(rand()%10)*0.01)
			    *(double)dir[closest];
		    }
		    	    
		    temp_y=polar_r*(cos(polar_a));
		    temp_x=polar_r*(sin(polar_a));
		    
		    map_x=temp_x+cent_x;
		    map_y=temp_y+cent_y;
		    
		    if ((map_y>=BUFF_HEIGHT) || (map_y<0) ||
			(map_x>=BUFF_WIDTH) || (map_x<0) ) {
			map_x=0;
			map_y=0;
		    }
		    
		    map_x=max(map_x,0);
		    map_y=max(map_y,0);
		    
		    map=map_y*BUFF_WIDTH+map_x;
		    
		}
		fwrite(&map,sizeof(tint),1,fp);
	    }
	}
	
	fclose(fp);
    }
    
}


