#!/bin/sh
# A faster version of which, that also prints ALL versions in your PATH,
# and accepts wildcards, e.g.: which '*uu*'. Silent if nothing found.
# Only works if test -x works...
# Modifyed by davida to only return the first match

case $# in
0) echo Usage: $0 cmd ...; exit 1;;
esac

dirs=`echo $PATH|sed 's/^:/. /
     s/:$/ ./
     s/::/ . /g
     s/:/ /g'`

for cmd
do
   for d in $dirs
   do
      for file in $d/$cmd
      do
         if test -x $file -a ! -d $file
         then
		echo $file
		exit 0
         fi
      done
   done
done
exit 1
