/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** sRefSetList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "basic.h"

static /*@notnull@*/ /*@only@*/ sRefSetList
sRefSetList_newEmpty (void)
{
  sRefSetList s = (sRefSetList) dmalloc (sizeof (*s));
  
  s->nelements = 0;
  s->nspace = sRefSetListBASESIZE; 
  s->elements = (sRefSet *) dmalloc (sizeof (*s->elements) * sRefSetListBASESIZE);

  return (s);
}

static void
sRefSetList_grow (/*@notnull@*/ sRefSetList s)
{
  int i;
  sRefSet *newelements;
  
  s->nspace += sRefSetListBASESIZE; 

  newelements = (sRefSet *) dmalloc (sizeof (*newelements) 
				     * (s->nelements + s->nspace));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }
  
  sfree (s->elements); 
  s->elements = newelements;
}

sRefSetList sRefSetList_add (sRefSetList s, /*@dependent@*/ sRefSet el)
{
  if (sRefSetList_isUndefined (s))
    {
      s = sRefSetList_newEmpty ();
    }

  if (s->nspace <= 0)
    {
      sRefSetList_grow (s);
    }
  
  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

void
sRefSetList_clear (sRefSetList s)
{
  if (sRefSetList_isDefined (s))
    {
      s->nspace += s->nelements;
      s->nelements = 0;
    }
}

void
sRefSetList_free (sRefSetList s)
{
  if (sRefSetList_isDefined (s))
    {
      sfree (s->elements);
      sfree (s);
    }
}
