;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Inline/walk.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jan  9 19:15:23 1995                          */
;*    Last change :  Thu Aug 15 07:58:34 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The inlining pass                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module inline_walk
   (include "Engine/pass.sch"
	    "Tools/trace.sch"
	    "Ast/node.sch")
   (import  tools_shape
	    tools_error
	    module_module
	    engine_param
	    ast_remove
	    (inline-sfun! inline_inline))
   (export  (inline-walk! <globals> ::symbol)
	    (inline-setup! ::symbol)
	    *kfactor*
	    *inlined-calls*
	    *non-inlined-calls*))

;*---------------------------------------------------------------------*/
;*    inline-walk! ...                                                 */
;*---------------------------------------------------------------------*/
(define (inline-walk! globals what)
   [assert (what) (memq what '(all reducer))]
   (pass-prelude "Inlining" reset-stat!)
   ;; we setup the inlining
   (inline-setup! what)
   ;; we scan all the local definitions to inline there body
   (for-each (lambda (g)
		(let ((kfactor (if (eq? (sfun-class (global-value g)) 'sifun)
				   1
				   *kfactor*)))
		   ;; I think that it is useless to inline the body of
		   ;; inline definitions. It only looses a little when this
		   ;; inline is used as values but I think this is rare.
		   (enter-function (global-id g))
		   (inline-sfun! g kfactor '())
		   (leave-function)))
	     globals)
   ;; and we just return the reachable variables
   (let loop ((globals     globals)
	      (new-globals '()))
      (cond
	 ((null? globals)
	  (pass-postlude (remove-var 'inline (reverse! new-globals))
			 show-stat!))
	 ((eq? (global-module (car globals)) *module*)
	  (loop (cdr globals) (cons (car globals) new-globals)))
	 (else
	  (loop (cdr globals) new-globals)))))

;*---------------------------------------------------------------------*/
;*    Statistics variables                                             */
;*---------------------------------------------------------------------*/
(define *inlined-calls* 0)
(define *non-inlined-calls* 0))

;*---------------------------------------------------------------------*/
;*    reset-stat! ...                                                  */
;*---------------------------------------------------------------------*/
(define (reset-stat!)
   (set! *inlined-calls* 0)
   (set! *non-inlined-calls* 0))

;*---------------------------------------------------------------------*/
;*    show-stat! ...                                                   */
;*---------------------------------------------------------------------*/
(define (show-stat!)
   (verbose 2 "      (inlined calls     : " *inlined-calls* #")\n")
   (verbose 2 "      (non inlined calls : " *non-inlined-calls* #")\n"))
   
   
;*---------------------------------------------------------------------*/
;*    inline-setup! ...                                                */
;*---------------------------------------------------------------------*/
(define (inline-setup! what)
   ;; we set the kfactor
   (case what
      ((all)
       (set! *kfactor* (*inlining-kfactor* *optim*)))
      ((reducer)
       (set! *kfactor* 1))
      (else
       (internal-error "inline-setup!" "Illegal mode" what))))

;*---------------------------------------------------------------------*/
;*    *kfactor* ...                                                    */
;*---------------------------------------------------------------------*/
(define *kfactor* 1)



