;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Effect/effect.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 13 13:46:44 1995                          */
;*    Last change :  Mon Apr 14 09:05:58 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The effect property                                              */
;*    -------------------------------------------------------------    */
;*    It is optional to have run the Effect pass before invoking       */
;*    this function. Nevertheless, firstly invoking Effect pass        */
;*    leads to better approximations.                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module effect_effect
   (include "Ast/node.sch")
   (export  (generic side-effect?::bool ::node)))

;*---------------------------------------------------------------------*/
;*    side-effect? ...                                                 */
;*---------------------------------------------------------------------*/
(define-generic (side-effect? node::node))

;*---------------------------------------------------------------------*/
;*    side-effect? ::node ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::node)
   #f)

;*---------------------------------------------------------------------*/
;*    side-effect? ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::var)
   (not (eq? (variable-access (var-variable node)) 'read)))

;*---------------------------------------------------------------------*/
;*    side-effect? ::node ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::node/effect)
   (let ((effect (node/effect-side-effect? node)))
      (if (boolean? effect)
	  effect
	  #t)))
 
;*---------------------------------------------------------------------*/
;*    side-effect? ::setq ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::setq)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::fail ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::fail)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::set-ex-it ...                                     */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::set-ex-it)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::jump-ex-it ...                                    */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::jump-ex-it)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::box-set! ...                                      */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::box-set!)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::app-ly ...                                        */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::app-ly)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::funcall ...                                       */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::funcall)
   #t)

;*---------------------------------------------------------------------*/
;*    side-effect? ::cast ...                                          */
;*---------------------------------------------------------------------*/
(define-method (side-effect? node::cast)
   (with-access::cast node (arg)
      (side-effect? arg)))



	    
