;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Ast/local.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Dec 27 17:39:21 1994                          */
;*    Last change :  Tue Aug  6 12:58:17 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The declaration of local variables                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_local
   (import  type_type
	    ast_var
	    ast_ident)
   (export  (clone-local::local ::local ::value)
	    (make-local-svar::local  ::symbol ::type)
	    (make-local-sexit::local ::symbol ::type ::sexit)
	    (make-local-sfun::local  ::symbol ::type ::sfun)))

;*---------------------------------------------------------------------*/
;*    *local-key* ...                                                  */
;*---------------------------------------------------------------------*/
(define *local-key* 0)

;*---------------------------------------------------------------------*/
;*    get-new-key ...                                                  */
;*---------------------------------------------------------------------*/
(define (get-new-key)
   (set! *local-key* (+fx *local-key* 1))
   *local-key*)

;*---------------------------------------------------------------------*/
;*    make-new-local ...                                               */
;*    -------------------------------------------------------------    */
;*    All local variables are allocated using this function.           */
;*---------------------------------------------------------------------*/
(define (make-new-local id type value)
   (let ((key (get-new-key)))
      (instantiate::local
	 (key key)
	 (id id)
	 (name (string-append (id->name id) "_" (integer->string key)))
	 (type type)
	 (value value))))

;*---------------------------------------------------------------------*/
;*    clone-local ...                                                  */
;*---------------------------------------------------------------------*/
(define (clone-local local value)
   (let ((key (get-new-key)))
      (with-access::local local (id)
	 (duplicate::local local
	    (key key)
	    (name (string-append (id->name id) "_" (integer->string key)))
	    (value value)))))

;*---------------------------------------------------------------------*/
;*    make-local-svar ...                                              */
;*---------------------------------------------------------------------*/
(define (make-local-svar id type)
   (make-new-local id type (instantiate::svar)))
  
;*---------------------------------------------------------------------*/
;*    make-local-sexit ...                                             */
;*---------------------------------------------------------------------*/
(define (make-local-sexit id type sexit)
   (make-new-local id type sexit))
  
;*---------------------------------------------------------------------*/
;*    make-local-sfun ...                                              */
;*    -------------------------------------------------------------    */
;*    All local variables are allocated using this function.           */
;*---------------------------------------------------------------------*/
(define (make-local-sfun id type sfun)
   (make-new-local id type sfun))
  
