;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/cigloo/Init/parse-args.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun 29 11:56:20 1995                          */
;*    Last change :  Thu Feb 26 15:04:19 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Command-line parsing                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module init_parse-args
   (include "Init/args.sch")
   (export  (parse-args args::pair))
   (import  engine_param
	    parser_lexer
	    write_version))

;*---------------------------------------------------------------------*/
;*    parse-args ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-args cmd-args)
   (args-parse (cdr cmd-args)
;*--- test preliminiaire ----------------------------------------------*/
	 (("-" ?name (synopsis "A source file name."))
	  (set! *src* (cons name *src*)))
;*--- L'aide ----------------------------------------------------------*/
	 (("?") (help args-parse-usage))
	 (("-help") (help args-parse-usage))
;*--- la version ------------------------------------------------------*/
	 (("-version" (synopsis "The current cigloo release."))
	  (print *cigloo-name*)
	  (exit 0))
	 (("-revision" (synopsis "The current cigloo release (short format)."))
	  (print *cigloo-version* (if (char? *cigloo-level*)
				      *cigloo-level*
				      ""))
	  (exit 0))
;*--- query -----------------------------------------------------------*/
	 (("-query" (synopsis "Dump the current configuration."))
	  (query))
;*--- -q --------------------------------------------------------------*/
	 (("-q" (synopsis "Do not load rc file."))
	  'nothing)
;*--- Le nom du resultat ----------------------------------------------*/
	 (("-o" ?name (synopsis "Name the output file <name>."))
	  (set! *dest* name))
;*--- --to-stdout -----------------------------------------------------*/
	 (("--to-stdout" (synopsis "Write C code on current output channel."))
	  (set! *verbose* -1)
	  (set! *dest* '--to-stdout))
;*--- Les options de verbosite ----------------------------------------*/
	 (("-s" (synopsis "Be silent."))
	  (set! *verbose* -1))
	 (("-v" (synopsis "-v[23]" "Be verbose."))
	  (set! *verbose* 1))
	 (("-v2")
	  (set! *verbose* 2))
	 (("-v3")
	  (set! *verbose* 3))
	 (("-w" (synopsis "Inhibit all warning messages."))
	  (set! *warning* #f))
	 (("-Wall" (synopsis "Warn about all possible errors."))
	  (set! *warning* 2))
;*--- open includes ---------------------------------------------------*/
	 (("-open-include" ?name (synopsis "Open include <name>."))
	  (if (or (pair? *open-include*) (null? *open-include*))
	      (set! *open-include* (cons name *open-include*))))
	 (("-open-includes" (synopsis "Open all includes."))
	  (set! *open-include* 'all))
;*--- scan includes ---------------------------------------------------*/
	 (("-scan-include" ?name (synopsis "Scan include <name>."))
	  (if (or (pair? *scan-include*) (null? *open-include*))
	      (set! *scan-include* (cons name *scan-include*))))
	 (("-scan-includes" (synopsis "Scan all includes."))
	  (set! *scan-include* 'all))
;*--- -I option -------------------------------------------------------*/
	 (("-I" ?name (synopsis "-I <name> | -I<name>"
				"Add <name> to the include directories list."))
	  (set! *include-path* (cons name *include-path*)))
	 (("-I?name")
	  (set! *include-path* (cons name *include-path*)))
;*--- define ----------------------------------------------------------*/
	 (("-define" (synopsis "Produce clauses for #define directives that do not take arguments [default]."))
	  (set! *define* #t))
	 (("-no-define" (synopsis "Dont' produce clauses for #define directives that do not take arguments."))
	  (set! *define* #f))
;*--- define-fun ------------------------------------------------------*/
	 (("-define-fun" (synopsis "Produce clauses for #define directives that take arguments [default]."))
	  (set! *define-fun* #t))
	 (("-no-define-fun" (synopsis "Dont' produce clauses for #define directives that take arguments"))
	  (set! *define-fun* #f))
;*--- type ------------------------------------------------------------*/
	 (("-type" ?name (synopsis "Add the type <name> to cigloo."))
	  (define-type-id name))
;*--- no-type ---------------------------------------------------------*/
	 (("-no-type" ?name (synopsis "Don't emit definition for type <name>."))
	  (set! *no-type* (cons name *no-type*)))
;*--- macro -----------------------------------------------------------*/
	 (("-macro" (synopsis "-macro[-fun|-var]"
			      "Produces macro definitions for functions and variables."))
	  (set! *macro-function* #t)
	  (set! *macro-variable* #t))
	 (("-macro-fun")
	  (set! *macro-function* #t))
	 (("-macro-var")
	  (set! *macro-variable* #t))
;*--- directives ------------------------------------------------------*/
	 (("-no-directives" (synopsis "Do not emit directives header."))
	  (set! *directives* #f))
;*--- include-directive -----------------------------------------------*/
	 (("-include-directive" (synopsis "Produce bigloo include directive."))
	  (set! *include-directive* #t))
;*--- hook ------------------------------------------------------------*/
	 (("-hookfile" ?name (synopsis "Load <name> to find user hooks."))
	  (set! *hookfile* name))
;*--- stub ------------------------------------------------------------*/
	 (("-fun-stub" (synopsis "Produce Eval stubs for functions (only with include directives)"))
	  (set! *eval-stub?* #t))
;*--- gcc extensions --------------------------------------------------*/
	 (("-gcc" (synopsis "Enable gcc extensions (e.g. inline, attributes)"))
	  (set! *gcc-extensions?* #t))
;*--- les sources -----------------------------------------------------*/
	 (else
	  (set! *src* (cons else *src*)))))
	
;*---------------------------------------------------------------------*/
;*    query ...                                                        */
;*---------------------------------------------------------------------*/
(define (query)
   (version)
   (newline)
   (print "setups:")
   (newline)
   (print "*include-path*         : " *include-path*)
   (print "*c-type-alist*         : " *c-type-alist*)
   (print "*c-unsigned-type-alist*: " *c-unsigned-type-alist*)
   (print "*c-signed-type-alist*  : " *c-signed-type-alist*)
   (print "*default-type*         : " *default-type*)
   (print "*hookfile*             : " *hookfile*)
   (exit 0))

;*---------------------------------------------------------------------*/
;*    help ...                                                         */
;*---------------------------------------------------------------------*/
(define (help usage)
   (version)
   (print "usage: cigloo [options] [src_name]*")
   (newline)
   (usage)
   (newline)
   (print "Shell Variables:")
   (print "   - TMPDIR             --  Tmp directory (default \"/tmp\").")
   (newline)
   (print "Runtime Command file:")
   (print "   - ~/.cigloorc")
   (exit 0))


   
