/* sockets.c
C functions for sockets in Scheme
tested for bigloo 1.9 under Solaris 2.4 and 2.5
Sven Hartrumpf (C) 1997
*/


#include <memory.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "sockets.h"


int c_accept_socket(int sockfd)
{
  struct sockaddr_in connecting_socket_address;
  int connecting_socket_length;
  connecting_socket_length = sizeof (struct sockaddr_in);
  return accept(sockfd, (struct sockaddr *) &connecting_socket_address,
                &connecting_socket_length);
}

int c_bind_socket(int sockfd, int port)
{
  struct sockaddr_in serv_addr;
  memset((char *) &serv_addr, 0, sizeof (serv_addr));
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  serv_addr.sin_port = htons(port);
  return bind(sockfd, (struct sockaddr *) &serv_addr, sizeof (serv_addr));
}

int c_close_socket(int sockfd)
{
  return close(sockfd);
}

int c_connect_socket(int sockfd, char* num_host_addr, int port)
{
  struct sockaddr_in serv_addr;
  memset ((char*) &serv_addr, 0, sizeof(struct sockaddr_in));
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = inet_addr(num_host_addr);
  serv_addr.sin_port = htons(port);
  return connect(sockfd, (struct sockaddr *) &serv_addr, sizeof(struct sockaddr_in));
}

int c_listen_socket(int sockfd, int backlog)
{
  return listen(sockfd, backlog);
}

int c_open_datagram_socket()
{
  return socket(AF_INET, SOCK_DGRAM, 0);
}

int c_open_stream_socket()
{
  return socket(AF_INET, SOCK_STREAM, 0);
}

int c_receive_socket(int sockfd, char* buffer, int length)
{
  return recv(sockfd, buffer, length, 0);
}

int c_send_socket(int sockfd, char* message, int length)
{
  return send(sockfd, message, length, 0);
}

int c_shutdown_socket(int sockfd)
{
  return shutdown(sockfd, 2);
}

int c_shutdown_socket_receive(int sockfd)
{
  return shutdown(sockfd, 0);
}

int c_shutdown_socket_send(int sockfd)
{
  return shutdown(sockfd, 1);
}
