static char dqs_free_rcsid[]="$Id: dqs_free.c,v 1.1.1.1 1997/04/10 15:10:32 green Exp $";

/*----------------------------------------------------
 * dqs_free.c Tom Green Mon Jan 31 10:42:44 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_free.c,v $
 * Revision 1.1.1.1  1997/04/10 15:10:32  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.12  1996/11/20 23:03:46  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.11  1996/03/12  17:12:06  nrl
 * removed aborts and replaced with an error messaging scheme
 * to send email to the dqs adminsitrator and wait for
 * actions by that administrator
 *
 * Revision 3.10  1996/02/07  13:08:01  nrl
 * Added "process leader" and TMP_FILES link capability
 *
 * Revision 3.9  1996/01/14  22:26:25  nrl
 * Added job_status_info to contain detailed information about
 * the job status
 *
 * Revision 3.8  1996/01/14  22:16:01  nrl
 * Added last_user delay function and consumables list to
 * queue definitions
 *
 * Revision 3.7  1995/06/21  16:57:35  nrl
 * Major scheduling changes... added a subpriority field to manage
 * things within the user submitted priority. Added priority info to the
 * accounting file.
 *
 * Revision 3.6  1995/02/22  14:29:23  nrl
 * added "FREE" macro to make sure all freed pointers are NULL,
 * replaced all calls to free( ) with FREE.
 *
 * Revision 3.5  1994/08/02  23:11:07  green
 * added support for a crude job staging mechanism
 *
 * Revision 3.4  1994/06/12  04:45:38  green
 * yanked conf.dqs_dshd_service
 *
 * Revision 3.3  1994/06/06  01:23:03  green
 * added "dqs_dshd_service" to the DQS config
 *
 * add "-par pvm" - though we do NOT intend to support it
 * (see dqs_start_pvm.c for a more thorough discussion)
 *
 * Revision 3.2  1994/06/05  16:53:52  green
 * added DQS_DSHD_SERVICE and dqs_dshd_service to required support files
 *
 * forced a SIGQUIT to children on death of parent(eg: "master") in
 * dqs_sig_handlers.c
 *
 * Revision 3.1  1994/06/03  00:25:49  green
 * replaced "DQSX_STR12" with "master_queue_exec_str" in support of MPI
 * mods
 *
 * Revision 3.0  1994/03/07  04:13:48  green
 * 3.0 freeze
 *
 * Revision 1.3  1994/02/23  19:27:17  green
 * fixed memory leak numbers 503 and 504
 *
 * added additional logging into dqs_resolve.c to track
 * memory leaks 505-510
 *
 * Revision 1.2  1994/02/09  19:48:07  green
 * syncing source with docs
 *
 * Revision 1.1.1.1  1994/02/01  17:57:40  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

 
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/**********************************************************************/
dqs_list_type *dqs_free_list(sp)
dqs_list_type *sp;

/*
  dqs_free_list - delete linked list dynamic memory
*/

{
     
     DENTER_EXT((DQS_EVENT,"dqs_free_list"));

     if (sp == (dqs_list_type *)NULL) {
          DEXITE;
          return ((dqs_list_type *)NULL);
     }
     
     sp->chain=dqs_free_list(sp->chain);
     sp->next=dqs_free_list(sp->next);
     sp->tid=dqs_free_list(sp->tid);


     FREE(sp->user);
     FREE(sp->str0);
     FREE(sp->str1);
     FREE(sp->str2);
     FREE(sp->str3);
     FREE(sp->buf);

     sp->rusage=dqs_free_rusage(sp->rusage);
     sp->queue=dqs_free_queue(sp->queue);
     sp->conf=dqs_free_conf(sp->conf);
     sp->job=dqs_free_job(sp->job);
     sp->me=dqs_free_me(sp->me);

     FREE(sp);

     DEXIT;
     return ((dqs_list_type *)NULL);
     
} /* dqs_free_list */


/************************************************************************/
dqs_rusage_type *dqs_free_rusage(r)
dqs_rusage_type *r;

/*
  dqs_free_rusage - delete a dqs_rusage_type structure.
*/

{

     DENTER_EXT((DQS_EVENT,"dqs_free_rusage"));

     if (!r)
     {
	  DEXITE;
	  return(r);
     }
     FREE(r->Version);
     FREE(r->qname);
     FREE(r->hostname);
     FREE(r->group);
     FREE(r->owner);
     FREE(r->job_name);
     FREE(r->account);
     FREE(r->DQSX_STR6);
     FREE(r->DQSX_STR7);
     FREE(r->DQSX_STR8);
     FREE(r->DQSX_STR9);
     FREE(r->DQSX_STR10);

     FREE(r);

     DEXIT;
     return(NULL);

}

/************************************************************************/
dqs_queue_type *dqs_free_queue(q)
dqs_queue_type *q;

/*
  dqs_free_queue - delete a dqs_queue_type structure.
*/

{

     DENTER_EXT((DQS_EVENT,"dqs_free_queue"));

     if (!q)
     {
          DEXITE;
          return(q);
     }
     FREE(q->Version);
     FREE(q->qname);
     FREE(q->qhostname);
     FREE(q->hostname);
     FREE(q->tmpdir);
     FREE(q->shell);
     FREE(q->klog);
     FREE(q->DQSX_STR22);
     FREE(q->DQSX_STR23);
     FREE(q->DQSX_STR24);
     FREE(q->DQSX_STR25);

     q->acl=dqs_free_list(q->acl);
     q->xacl=dqs_free_list(q->xacl);
     q->owner_list=dqs_free_list(q->owner_list);
     q->subordinate_list=dqs_free_list(q->subordinate_list);
     q->q_activation_list=dqs_free_list(q->q_activation_list);
     q->complex_list=dqs_free_list(q->complex_list);
     q->job_list=dqs_free_list(q->job_list);
     q->last_user=dqs_free_list(q->last_user);
     q->consumables=dqs_free_list(q->consumables);
     q->DQSX_L23=dqs_free_list(q->DQSX_L23);
     q->DQSX_L24=dqs_free_list(q->DQSX_L24);
     q->DQSX_L25=dqs_free_list(q->DQSX_L25);

     FREE(q);

     DEXIT;
     return(NULL);

}

/************************************************************************/
dqs_conf_type *dqs_free_conf(c)
dqs_conf_type *c;

/*
  dqs_free_conf - delete a dqs_conf_type structure.
*/

{

     DENTER_EXT((DQS_EVENT,"dqs_free_conf"));

     if (!c)
     {
          DEXITE;
          return(c);
     }
     FREE(c->Version);
     FREE(c->qmaster_spool_dir);
     FREE(c->execd_spool_dir);
     FREE(c->default_cell);
     FREE(c->qmaster_service);
     FREE(c->dqs_execd_service);
     FREE(c->klog);
     FREE(c->mailer);
     FREE(c->dqs_bin);
     FREE(c->administrator);
     FREE(c->default_account);
     FREE(c->DQSX_STR1);
     FREE(c->DQSX_STR2);
     FREE(c->DQSX_STR3);
     FREE(c->DQSX_STR4);
     FREE(c->DQSX_STR5);

     FREE(c);

     DEXIT;
     return(NULL);

}

/************************************************************************/
dqs_job_type *dqs_free_job(j)
dqs_job_type *j;

/*
   dqs_free_job - delete a dqs_job_type structure.
*/

{


     DENTER_EXT((DQS_EVENT,"dqs_free_job"));

     if (!j)
     {
          DEXITE;
          return(j);
     }
     FREE(j->Version);
     FREE(j->dqs_job_name);
     FREE(j->job_file);
     FREE(j->exec_file);
     FREE(j->owner);
     FREE(j->dqs_o_home);
     FREE(j->dqs_o_log_name);
     FREE(j->dqs_o_path);
     FREE(j->dqs_o_mail);
     FREE(j->dqs_o_shell);
     FREE(j->dqs_o_tz);
     FREE(j->dqs_o_workdir);
     FREE(j->dqs_o_host);

     j->account_list=dqs_free_list(j->account_list);


     FREE(j->cell);
     FREE(j->cwd);
     FREE(j->directive_prefix);


     j->stderr_path_list=dqs_free_list(j->stderr_path_list);
     j->exec_list=dqs_free_list(j->exec_list);
     j->group_list=dqs_free_list(j->group_list);
     j->hard_resource_list=dqs_free_list(j->hard_resource_list);
     j->soft_resource_list=dqs_free_list(j->soft_resource_list);
     j->hard_master_list=dqs_free_list(j->hard_master_list);
     j->soft_master_list=dqs_free_list(j->soft_master_list);
     j->mail_list=dqs_free_list(j->mail_list);


     FREE(j->job_name);

     j->stdout_path_list=dqs_free_list(j->stdout_path_list);
     j->passwd_list=dqs_free_list(j->passwd_list);

     FREE(j->Passwd);

     j->hard_queue_list=dqs_free_list(j->hard_queue_list);
     j->soft_queue_list=dqs_free_list(j->soft_queue_list);

     j->shell_list=dqs_free_list(j->shell_list);
     j->user_list=dqs_free_list(j->user_list);
     j->variable_list=dqs_free_list(j->variable_list);
     j->env_list=dqs_free_list(j->env_list);
     j->destin_identifier_list=dqs_free_list(j->destin_identifier_list);
     j->granted_destin_identifier_list=dqs_free_list(j->granted_destin_identifier_list);
     j->job_identifier_list=dqs_free_list(j->job_identifier_list);

     FREE(j->message);
     FREE(j->script_file);
     FREE(j->script_ptr);
     
     j->srvr_nm_list=dqs_free_list(j->srvr_nm_list);

     FREE(j->master_queue);
     FREE(j->master_queue_exec_str);
     FREE(j->DQSX_STR13)
     FREE(j->DQSX_STR14);
     FREE(j->DQSX_STR15)
     
     j->jid_hold_list=dqs_free_list(j->jid_hold_list);
     j->job_status_info=dqs_free_list(j->job_status_info);
     j->DQSX_L13=dqs_free_list(j->DQSX_L13);
     j->DQSX_L14=dqs_free_list(j->DQSX_L14);
     j->DQSX_L15=dqs_free_list(j->DQSX_L15);
     j->invalid_destin_identifier_list=dqs_free_list(j->invalid_destin_identifier_list);

     FREE(j->machine);

     if (j->script_argv_list) free(j->script_argv_list);

     FREE(j);

     DEXIT;
     return(NULL);

}

/************************************************************************/
dqs_me_type *dqs_free_me(m)
dqs_me_type *m;

/*
   dqs_free_me - delete a dqs_me_type structure.
*/

{

     DENTER_EXT((DQS_EVENT,"dqs_free_me"));

     if (!m)
     {
          DEXITE;
          return(m);
     }
     FREE(m->Version);
     FREE(m->dqs_formal_prog_name);
     FREE(m->qualified_prog_name);
     FREE(m->unqualified_prog_name);
     FREE(m->qualified_hostname);
     FREE(m->unqualified_hostname);
     FREE(m->user_name);
     FREE(m->default_cell);
     FREE(m->default_editor);
     FREE(m->DQSX_STR106);
     FREE(m->DQSX_STR107);
     FREE(m->DQSX_STR108);
     FREE(m->DQSX_STR109);
     FREE(m->DQSX_STR1010);
     
     FREE(m);

     DEXIT;
     return(NULL);

}

