/*
 * extmem.S
 *
 * Copy stuff to extended memory.
 *
 * This file is a part of Choose-OS. See the file README
 *
 * Copyright (c) Tuomo Valkonen 1997.
 */

	
#if defined(SUPPORT_BZIMAGE) || defined(SUPPORT_INITRD)

// copy 64k to extended memory
////////////////////////////////
copy_to_extmem:
	push	es
	pushad
	
	mov	ax,ds
	mov	es,ax
	mov	si,#copy_gdt
	mov	cx,#0x8000			// 64k in words
	mov	ax,#0x8700
	int	0x15
	jc	copy_error
	
	popad
	pop	es

	inc	byte ptr copy_dst_base+2	// add 64k
	jnz	end_copy
	inc	byte ptr copy_dst_base24
	
end_copy:
	ret

copy_error:
	mov	si,#str_copy_error
	br	die


// Data
/////////
str_copy_error:	.ascii	"Int15h failed to access extended memory!"
		.ascii	" (do ya have enough memory?)"
		.byte	0
		
#endif /* BZIMAGE || INITRD */
