/*
 * bg.c 
 *
 * Background file generator/color config stuff.
 * 
 * Copyright (c) Tuomo Valkonen 1997.
 */
 
#include<stdio.h>
#include<strings.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<errno.h>
#include<linux/fs.h>
 
#include<chos/chos.h>
#include<chos/main.h>
#include<chos/image.h>
#include<chos/install.h>
#include<chos/map.h>
#include<chos/mapfile.h>

static char* 	infoline1="Choose-OS v" CHOS_VERSIONSTR ", Copyright (c) Tuomo Valkonen 1996-1997.";
static char* 	infoline2="Up/Down arrows to select. Enter or hotkey to start. Space for command line.";
static char 	def_banner[80]="Choose-OS v"CHOS_VERSIONSTR" BootUp Menu.";
static char  	*banner=def_banner;
char		show_infoline=1;
char		(*background)[25][80][2];
static signed char	menux=-1,menuy=-1;

char*	color_list[16]={
	"black",
	"blue",
	"green",
	"cyan",
	"red",
	"magenta",
	"brown",
	"lightgray",
	"darkgray",
	"lightblue",
	"lightgreen",
	"lightcyan",
	"lightred",
	"lightmagenta",
	"yellow",
	"white"
};

char latin2ibm[256] = {
0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
0xFF,0xAD,0x9B,0x9C,0xA8,0x9D,0x7C,0x15,0xA8,0xA8,0xA6,0xAE,0xAA,0x2D,0xA8,0xA8,
0xF8,0xF1,0xFD,0xA8,0xA8,0xE6,0x14,0xFA,0xA8,0xA8,0xA7,0xAF,0xAC,0xAB,0xA8,0xA8,
0xA8,0xA8,0xA8,0xA8,0x8E,0x8F,0x92,0x80,0xA8,0x90,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
0xA8,0xA5,0xA8,0xA8,0xA8,0xA8,0x99,0xA8,0xA8,0xA8,0xA8,0xA8,0x9A,0xA8,0xA8,0xE1,
0x85,0xA0,0x83,0xA8,0x84,0x86,0x91,0x87,0x8A,0x82,0x88,0x89,0x8D,0xA1,0x8C,0x8B,
0xA8,0xA4,0x95,0xA2,0x93,0xA8,0x94,0xF6,0xA8,0x97,0xA3,0x96,0x81,0xA8,0xA8,0x98
};

void clear_bg(void)
{
	int i,j;
	
	for(j=0;j<25;j++){
		for(i=0;i<80;i++){
			(*background)[j][i][0]=0x00;
			(*background)[j][i][1]=0x07;
		}
	}
}

static void _put_text(int x,int y,char*str,char color)
{
	while(*str){
		if(x>=80 || y>24)
			break;
		(*background)[y][x][0]=latin2ibm[(unsigned char)*str];
		(*background)[y][x][1]=color;
		str++;x++;
	}
}

static void put_text(int x,int y,char*str)
{
	_put_text(x,y,str,mh->color);
}

static void check_collide(	int x1,int y1,int len1,char* name1,
				int x2,int y2,int len2,char* name2)
{
	if(y1!=y2)
		return;
		
	if(x2+len2<=x1)
		return;
		
	if(x2>=x1+len1)
		return;

	die(-1,"Position of \"%s\" on screen collides with \"%s\"!\n",name1,name2);
}

static void _finish_bg()			
{
	char*	timestr=NULL;
	int	a=menux;
	int	i,j;
	MF_ImageDes*	img;
	char	hotstring[4] = "?. ";
	char	timeleft[8];
	uchar	attr;
	
	// Check, count and validate all coordinates
	//	
	if(menux==-1){
		menux=3;a=0;
	}

	if(menuy==-1)
		menuy=3;
	if(mh->timex==-1){
		mh->timestrx=a;
		mh->timex=a+strlen(timestr="Time left: ");
	}if(mh->timey==-1)
		mh->timey=menuy+mh->nimages+1;

	if(mh->timey>mh->loady)
		mh->loady=mh->timey;

	if(view){
		sprintf(timeleft,"%3d",mh->delay);
		put_text(mh->timex,mh->timey,timeleft);
	}

	// Set coordinates for images for which they haven't already been set
	for(i=0,img=im->images;i<mh->nimages;i++,img++){
		if(img->x!=0xff)
			goto cont;
		img->x=menux;
		img->y=menuy+i;
		if(img->y>24)
			die(-1,"Invalid y-coordinate for \"%s\"\n",im->images[i].name);
		if(img->x+strlen(img->name)>80)
			die(-1,"Invalid x-coordinate for \"%s\" (would wrap)\n");
cont:
		if(view){
			attr=img->color;
			if (i==0){
				attr&=0x0F;
				if (attr==mh->selcolor) attr|=0x08;
				attr|=mh->selcolor<<4;
			}
			j=img->x;
			if (!(img->flags & CF_HOT_HIDDEN)){
				hotstring[0] = img->hotkey;
				_put_text(j,img->y,hotstring,attr);
				j += strlen (hotstring);
			}
			_put_text(j,img->y,img->name,attr);
		}
	}
	
	// Check for any possible collisions...
	for(i=0,img=im->images;i<mh->nimages;i++,img++){
		check_collide(img->x,img->y,strlen(img->name),img->name,
			      mh->timex,mh->timey,2,"timer");
			      
		for(j=i+1;j<mh->nimages;j++){
			check_collide(img->x,img->y,strlen(img->name),img->name,
					im->images[j].x,im->images[j].y,strlen(im->images[j].name),
					im->images[j].name);
		}
		if(img->y>=mh->loady)
			mh->loady=img->y+1;
	}
	if(mh->loady>25)
		die(-1,"String \"Loading...\" forced too low...\n");
		
	// Ok, all's ok - put all stuff in the background image.
	//
	if(timestr && mh->delay!=255)
		put_text(mh->timestrx,mh->timey,timestr);

	if(banner)
		put_text(0,1,banner);
	
	if(show_infoline){
		put_text(0,23,infoline1);
		put_text(0,24,infoline2);
	}
}


void finish_bg()
{
	int	fd,a;
	GEOMETRY geo;
	
	_finish_bg();
	
	// Try to write it
	//
	if( (fd=open(background_file,O_RDWR|O_TRUNC|O_CREAT),600)<0 )
		die(errno,background_file);
	
	if(write(fd,background,80*25*2)!=80*25*2)
		die(errno,background_file);

	if( !get_device(fd,&geo) )
		die(errno,background_file);

	mh->bg_drive=geo.device;
	
	for( a=0 ; a<8 ; a++ ){
		if((mh->bg_sects[a]=get_addr(fd,a,&geo))==0)
			die(-1,"Hole in %s\n",background_file);
		VER_BIOS(&geo,mh->bg_sects[a],background_file);
	}
	close(fd);
}

void do_backascii(char*file,int latin)
{
	int	fd;
	char	c;
	int	x=0,y=0;
	int	size;
	
	if((fd=open(file,O_RDONLY))<0)
		die(errno,file);
		
 	if((size=lseek(fd,0,SEEK_END))<0)
		die(errno,file);
		
	lseek(fd,0,SEEK_SET);

	clear_bg();

	while(y<25 && size--){
		if(read(fd,&c,1)<1)
			die(errno,file);
			
		if(c=='\n'){
			x=0;y++;continue;
		}
		if(c=='\r'){
			x=0;continue;
		}
		if(x>79)
			continue;
		if(c=='\t'){
			x+=8-(x&7);
			continue;
		}
		if(latin){
			if(c<' ')
				c=' ';
			(*background)[y][x][0]=latin2ibm[(unsigned char)c];
		} else {
			(*background)[y][x][0]=c;
		}
		(*background)[y][x][1]=mh->color;
		x++;
	}
}

void do_backdump(char*file)
{
	int	fd;
	int	size;
	
	if((fd=open(file,O_RDONLY))<0)
		die(errno,file);
		
 	if((size=lseek(fd,0,SEEK_END))<0)
		die(errno,file);
		
	lseek(fd,0,SEEK_SET);

	if(size>80*25*2)
		size=80*25*2;

	clear_bg();
	
	if(read(fd,background,size)<0)
		die(errno,file);
		
	mh->loady=size/160;
}

/* Set background image */
void do_background(char*backstr)
{
	char*str=backstr;
	
	while(*str && *str!=':')
		str++;
		
	if(!*str)
		die(-1,"Background type needed - \'ascii\', \'cp437\' or \'dump\'\n");

	*str='\0';
	
	if(!strcasecmp(backstr,"ascii"))
		do_backascii(str+1,1);
	else if(!strcasecmp(backstr,"cp437"))
		do_backascii(str+1,0);
	else if(strcasecmp(backstr,"dump"))
		die(-1,"Invalid background type.\n");
	else
		do_backdump(str+1);
	banner=NULL;
	
	verbose("Background set to %s\n",str+1);
}

void do_menupos(char*str)
{
	get_coord(str,&menux,&menuy);

	// Checked later... (most people don't have 40-byte long image names ;)...	
#if 0
	if(menux+BID_NAME_LEN>80)
		die(-1,"Menu X coordinate invalid.\n");
#endif
}

void do_timerpos(char*str)
{
	get_coord(str,&(mh->timex),&(mh->timey));

	mh->timestrx=mh->timex;
	
	if(mh->timex+3>80)
		die(-1,"Timer coordinates invalid.\n");
}

void do_banner(char* newbanner)
{
	if(strlen(newbanner)>80)
		die(-1,"ERROR: Banner too long (max. 80 chars).");
		
	if(!banner)
		banner=def_banner;

	memset(banner,0,80);
	strcpy(banner,newbanner);

	verbose("Banner is now \"%s\".\n",banner);
}

void do_infoline(char* on_off)
{
	if(!strcmp(on_off,"on"))
		show_infoline=1;
	else if(!strcmp(on_off,"off"))
		show_infoline=0;
	else
		cfgsyntax("Must be \"on\" or \"off\"");
		
	verbose("Infoline is now %s.\n",show_infoline?"on":"off");
}


void do_color(char*colorstr)
{
	mh->color=get_color(colorstr,NULL);

	verbose("Color set to %s on %s...\n",
		color_list[mh->color&0xf],
		color_list[(mh->color>>4)&0x7]);
}

void do_selection(char*colorstr)
{
	mh->selcolor=get_color(colorstr,NULL);
	
	if(mh->selcolor>7)
		die(-1,"Selection color must be <= 7\n");

	verbose("Selection color set to %s...\n",color_list[mh->selcolor]);
}


static char do_get_color(char* str,char** endptr)
{
	int	i=0,j;
	
	while(str[i]){
		if(str[i]==':' || str[i]==',')
			break;
		i++;
	}
	*endptr=&str[i];
found_end:

	for(j=0;j<16;j++){
		if(strncasecmp(str,color_list[j],i))
			continue;
		return j;
	}
	str[i]='\0';
	cfgerror("Invalid color \"%s\".\n",str);
}

char get_color(char*str,char**endptr)
{
	char*	ptr;
	char	c=do_get_color(str,&ptr),c2;

	if(*ptr){
		if(*ptr==':'){
			if(endptr){
				*endptr=ptr;
				return c;
			}
			cfgerror("Expected , or \\n");
		}
		if(*ptr!=',')
			cfgerror("Expected , or : ");
			
		c2=do_get_color(ptr+1,&ptr);
		if(*ptr && (!endptr || *ptr!=':'))
			cfgerror("Invalid color parameter");
			
		if(c2>0x7)
			cfgerror("Background must be <=7 !\n");

		c|=(c2<<4);
		if(endptr)
			*endptr=ptr;
	}
	return c;
}



void get_coord(char*str,signed char*x,signed char*y)
{
	int c;
	char*end;
	
	*x=*y=0;

	if(!*str)
		goto invalid_coords;

	c=strtoul(str,&end,0);
	
	if(c>79 || c<0)
		goto invalid_coords;
	*x=c;
	
	if(!*end)
		return;
	if(*end!=',')
		goto invalid_coords;
		
	c=strtoul(end+1,&end,0);
	
	if(c>24 || c<0 || *end)
		goto invalid_coords;
	*y=c;
	return;

invalid_coords:
	die(-1,"Invalid coordinates.\n");
}

// Stuff below taken from showscreen.c by 
// Bernhard Ehlers <BEhlers@t-online.de>
//

/*
 * Convert IBM-PC attributes into ansi escape sequence
 */
static void put_attr (uchar attr)
{
  static uchar col_tab[] = {0, 4, 2, 6, 1, 5, 3, 7};
  uchar col;

  putchar ('\033'); putchar ('[');
  col = col_tab[attr & 0x07];
  putchar ('3'); putchar ('0' + col); putchar (';');
  if ((attr & 0x08) == 0) putchar ('2');
  putchar ('1'); putchar (';');
  col = col_tab[(attr & 0x70) >> 4];
  putchar ('4'); putchar ('0' + col); putchar (';');
  if ((attr & 0x80) == 0) putchar ('2');
  putchar ('5');
  putchar ('m');
}

#define screen (*background)

void view_it(void)
{
  	uchar tab[256];
  	int i, j;
  	uchar attr;

	_finish_bg();	

	// Added this - in 50-line mode we wanna know where the background
	// starts. In 25-line mode this isn't seen.
	for(i=0;i<80;i++)
		putchar('-');
		
  	/* some IBM char can't be used, e.g. bell, CR, LF, Backspace, ... */
  	for (i = 0; i < 256; i++) tab[i] = i;
  	tab[0] = ' ';
  	for (i = 7; i < 16; i++) tab[i] = ' ';
  	tab[24] = '^';
  	tab[26] = '<';
  	tab[27] = '>';
  	tab[127] = 177;
  	tab[128 + 27] = 'c';

  	fputs ("\033(U\033[0m", stdout);
  	for (i = 0; i < 25; i++)
  	  {
  	    attr = 0x07; put_attr (attr);
  	    for (j = 0; j < 80; j++)
		{
		  if (screen[i][j][1] != attr)
		    {
		      attr = screen[i][j][1];
		      put_attr (attr);
		    }
		  putchar (tab[screen[i][j][0]]);
		}
	      fputs ("\033[0m", stdout);
	      if (i < 24) putchar ('\n');
	  }
	fputs ("\033(B", stdout); fflush(stdout);
	
  	if (isatty(0) && isatty(1)) getchar ();
}
