.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH XScreenSaver 1 "31-May-97" "X Version 11"
.SH NAME
xscreensaver-command - control a running xscreensaver process
.SH SYNOPSIS
.B xscreensaver-command
[\-help] [\-demo] [\-activate] [\-deactivate] [\-lock] [\-cycle] [\-next] [\-prev] [\-exit] [\-restart] [\-version] [\-time]
.SH DESCRIPTION
The \fIxscreensaver\-command\fP program controls a running \fIxscreensaver\fP
process by sending it client-messages.
.SH OPTIONS
.I xscreensaver-command
accepts the following options:
.TP 8
.B \-help
Prints a brief summary of command-line options.
.TP 8
.B \-demo
Cause the screensaver to enter its interactive demo mode, in which one
can experiment with the various graphics hacks available.  See 
.BR xscreensaver (1)
for details.
.TP 8
.B \-activate
Tell the screensaver to turn on immediately (that is, pretend that the 
user been idle for long enough.)  It will turn off as soon as there is
any user activity, as usual.

It is useful to run this from a menu; you may wish to run it as
.EX
sleep 5 ; xscreensaver-command -activate
.EE
to be sure that you have time to remove your hand from the mouse before
the screensaver comes on.
.TP 8
.B \-deactivate
Tell the screensaver to turn off, as if there had been user activity.
If locking is enabled, then the screensaver will prompt for a password
as usual.
.TP 8
.B \-lock
Like \fI\-activate\fP, but a password will be required before the screensaver
turns off, even if the screensaver's \fIlock\fP resource is false.  The 
display will be locked immediately even if the screensaver's \fIlockTimeout\fP
resource is non-zero.
.TP 8
.B \-cycle
Tell the screensaver to change which graphics hack it is running, just
as if the ``cycle'' timer had expired.  A new hack will be chosen randomly.
.TP 8
.B \-next
This is like either \fI\-activate\fP or \fI\-cycle\fP, depending on which is
more appropriate, except that the screenhack that will be run is the next
one in the list of programs, instead of a randomly-chosen one.  Repeatedly
executing this will cycle through each hack in turn (though using 
the \fI\-demo\fP option is probably an easier way to accomplish that.)
.TP 8
.B \-prev
This is like \fI\-next\fP, but cycles in the other direction.
.TP 8
.B \-exit
Causes the screensaver process to exit gracefully.  This is a safer and
easier way to kill the screensaver than by using \fIkill\fP.  

.B Warning:
never use \fIkill -9\fP with \fIxscreensaver\fP while the screensaver is
active.  If you are using a virtual root window manager, that can leave
things in an inconsistent state, and you may need to restart your window
manager to repair the damage.
.TP 8
.B \-restart
Causes the screensaver process to exit and then restart with the same command
line arguments.  This is a good way of causing the screensaver to re-read the
resource database.

If the screensaver is run from \fIxdm(1)\fP (that is, it is already running
before you log in) then you may want to issue the ``restart'' command from 
one of your startup scripts, so that the screensaver gets your resource
settings instead of the default ones.
.TP 8
.B \-version
Print (on stdout) the version number of the xscreensaver program that is 
running on $DISPLAY.  (To see the version number of \fIxscreensaver-command\fP
itself, use the \fI\-help\fP option.)
.TP 8
.B \-time
This option prints on stdout the time at which the screensaver last activated
(blanked the screen) or deactivated (restored the screen.)  Note that the
activation-time is not the last time at which the user was active, but is
some time later (it is the time at which either: xscreensaver decided that
the user has been idle long enough; or, the user explicitly activated the
screensaver or locker.)
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the host and display number of the screen whose saver is
to be manipulated.
.TP 8
.B PATH
to find the executable to restart (for the \fI\-restart\fP command).  
Note that this variable is consulted in the environment of 
the \fIxscreensaver\fP process, not the \fIxscreensaver-command\fP process.
.SH "SEE ALSO"
.BR X (1),
.BR xscreensaver (1)
.SH BUGS
Some diagnostics are reported on the stderr of the \fIxscreensaver\fP
process, not this process, so the caller of \fIxscreensaver-command\fP
may not see the error messages.
.SH COPYRIGHT
Copyright \(co 1992, 1993, 1997 by Jamie Zawinski.  
Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting documentation.  No
representations are made about the suitability of this software for any
purpose.  It is provided "as is" without express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@netscape.com>, 13-aug-92.
