/* xkeycaps, Copyright (c) 1991, 1992, 1993, 1994, 1995, 1996, 1997
 * Jamie Zawinski <jwz@netscape.com>
 *
 * Keymap file of the 102 keys PC-style keyboard, belgian layout (azerty).
 * Linux 2.0.30 / XFree86 3.3
 * By Bart Van Cutsem <Bart.VanCutsem@cs.kuleuven.ac.be>
 */

static const struct default_keycode_map linux102be_map [] = {
  {   9, 0,		{ XK_Escape }},
  {  10, 0,		{ XK_ampersand,	XK_1 }},
  {  11, Mod3Mask,	{ XK_eacute,	XK_2,	XK_at }},
  {  12, Mod3Mask,	{ XK_quotedbl,	XK_3,	XK_numbersign }},
  {  13, 0,		{ XK_apostrophe,	XK_4 }},
  {  14, 0,		{ XK_parenleft,	XK_5 }},
  {  15, Mod3Mask,	{ XK_section,	XK_6,	XK_asciicircum }},
  {  16, 0,		{ XK_egrave,	XK_7 }},
  {  17, 0,		{ XK_exclam,	XK_8 }},
  {  18, Mod3Mask,	{ XK_ccedilla,	XK_9,	XK_braceleft }},
  {  19, Mod3Mask,	{ XK_agrave,	XK_0,	XK_braceright }},
  {  20, 0,		{ XK_parenright,	XK_degree }},
  {  21, 0,		{ XK_minus,	XK_underscore }},
  {  22, 0,		{ XK_BackSpace }},
  {  23, 0,		{ XK_Tab }},
  {  24, 0,		{ XK_a,	XK_A }},
  {  25, 0,		{ XK_z,	XK_Z }},
  {  26, 0,		{ XK_e,	XK_E }},
  {  27, 0,		{ XK_r,	XK_R }},
  {  28, 0,		{ XK_t,	XK_T }},
  {  29, 0,		{ XK_y,	XK_Y }},
  {  30, 0,		{ XK_u,	XK_U }},
  {  31, 0,		{ XK_i,	XK_I }},
  {  32, 0,		{ XK_o,	XK_O }},
  {  33, 0,		{ XK_p,	XK_P }},
  {  34, Mod3Mask,	{ XK_dead_circumflex,	XK_diaeresis, XK_bracketleft }},
  {  35, Mod3Mask,	{ XK_dollar,	XK_asterisk,	XK_bracketright }},
  {  36, 0,		{ XK_Return }},
  {  37, ControlMask,	{ XK_Control_L }},
  {  38, 0,		{ XK_q,	XK_Q }},
  {  39, 0,		{ XK_s,	XK_S }},
  {  40, 0,		{ XK_d,	XK_D }},
  {  41, 0,		{ XK_f,	XK_F }},
  {  42, 0,		{ XK_g,	XK_G }},
  {  43, 0,		{ XK_h,	XK_H }},
  {  44, 0,		{ XK_j,	XK_J }},
  {  45, 0,		{ XK_k,	XK_K }},
  {  46, 0,		{ XK_l,	XK_L }},
  {  47, 0,		{ XK_m,	XK_M }},
  {  48, Mod3Mask,	{ XK_ugrave,	XK_percent,	XK_apostrophe }},
  {  49, 0,		{ XK_twosuperior,	XK_threesuperior }},
  {  50, ShiftMask,	{ XK_Shift_L }},
  {  51, Mod3Mask,	{ XK_asterisk,	XK_mu,	XK_grave }},
  {  52, 0,		{ XK_w,	XK_W }},
  {  53, 0,		{ XK_x,	XK_X }},
  {  54, 0,		{ XK_c,	XK_C }},
  {  55, 0,		{ XK_v,	XK_V }},
  {  56, 0,		{ XK_b,	XK_B }},
  {  57, 0,		{ XK_n,	XK_N }},
  {  58, 0,		{ XK_comma,	XK_question }},
  {  59, 0,		{ XK_semicolon,	XK_period }},
  {  60, 0,		{ XK_colon,	XK_slash }},
  {  61, Mod3Mask,	{ XK_equal,	XK_plus,	XK_asciitilde }},
  {  62, ShiftMask,	{ XK_Shift_R }},
  {  63, 0,		{ XK_KP_Multiply }},
  {  64, Mod1Mask,	{ XK_Alt_L }},
  {  65, 0,		{ XK_space }},
  {  66, LockMask,	{ XK_Caps_Lock }},
  {  67, 0,		{ XK_F1,	XK_F13 }},
  {  68, 0,		{ XK_F2,	XK_F14 }},
  {  69, 0,		{ XK_F3,	XK_F15 }},
  {  70, 0,		{ XK_F4,	XK_F16 }},
  {  71, 0,		{ XK_F5,	XK_F17 }},
  {  72, 0,		{ XK_F6,	XK_F18 }},
  {  73, 0,		{ XK_F7,	XK_F19 }},
  {  74, 0,		{ XK_F8,	XK_F20 }},
  {  75, 0,		{ XK_F9,	XK_F21 }},
  {  76, 0,		{ XK_F10,	XK_F22 }},
  {  77, 0,		{ XK_Num_Lock }},
  {  78, 0,		{ XK_Scroll_Lock }},

  {  79, 0,		{ XK_Home,	XK_KP_7,
			XK_KP_7,	XK_Home }},
  {  80, 0,		{ XK_Up,	XK_KP_8,
			XK_KP_8,	XK_Up }},
  {  81, 0,		{ XK_Prior,	XK_KP_9,
			XK_KP_9,	XK_Prior }},
  {  82, 0,		{ XK_KP_Subtract }},
  {  83, 0,		{ XK_Left,	XK_KP_4,
			XK_KP_4,	XK_Left }},
  {  84, 0,		{ XK_Begin,	XK_KP_5,
			XK_KP_5,	XK_Begin }},
  {  85, 0,		{ XK_Right,	XK_KP_6,
			XK_KP_6,	XK_Right }},
  {  86, 0,		{ XK_KP_Add }},
  {  87, 0,		{ XK_End,	XK_KP_1,
			XK_KP_1,	XK_End }},
  {  88, 0,		{ XK_Down,	XK_KP_2,
			XK_KP_2,	XK_Down }},
  {  89, 0,		{ XK_Next,	XK_KP_3,
			XK_KP_3,	XK_Next }},
  {  90, 0,		{ XK_Insert,	XK_KP_0,
			XK_KP_0,	XK_Insert }},
  {  91, 0,		{ XK_Delete,	XK_KP_Decimal,
			XK_KP_Decimal,	XK_Delete }},
  {  94, Mod3Mask,	{ XK_less,	XK_greater, XK_backslash }},
  {  95, 0,		{ XK_F11,	XK_F23 }},
  {  96, 0,		{ XK_F12,	XK_F24 }},
  {  97, 0,		{ XK_Home }},
  {  98, 0,		{ XK_Up }},
  {  99, 0,		{ XK_Prior }},
  { 100, 0,		{ XK_Left }},
  { 102, 0,		{ XK_Right }},
  { 103, 0,		{ XK_End }},
  { 104, 0,		{ XK_Down }},
  { 105, 0,		{ XK_Next }},
  { 106, 0,		{ XK_Insert }},
  { 107, 0,		{ XK_Delete }},
  { 108, 0,		{ XK_KP_Enter }},
  { 109, ControlMask,	{ XK_Control_R }},
  { 110, 0,		{ XK_Pause, XK_Break }},
  { 111, 0,		{ XK_Print, XK_Execute }},
  { 112, 0,		{ XK_KP_Divide }},
  { 113, Mod3Mask,	{ XK_Mode_switch }}
};
