/* xkeycaps, Copyright (c) 1991, 1992, 1993, 1994, 1996
 * Jamie Zawinski <jwz@netscape.com>
 *
 * This file describes the default keymap for the
 * Gateway 2000 AnyKey programmable PC keyboard.
 * Generated by Jarrod Smith <jsmith@scripps.edu>
 *
 * Important notes about this keyboard:
 * 
 * In order for all the keysyms to work properly, the programmable ROM
 * inside the keyboard may need to be reset to factory default by pressing
 * <Ctrl>-<Alt>-<Suspnd Macro>
 * even if you have NEVER programmed anything into the keyboard!  If you
 * have programmed macros in that you don't want to lose, you should be
 * able to save them by using the DOS utility that came with the keyboard
 * BEFORE you reset the ROM.
 * 
 * I couldn't get xmodmap to get the BackSpace keysym working right for my
 * keyboard until I did this.  It would let me change the keysym for my
 * backspace key from Delete to BackSpace which is what I wanted it to do,
 * but I have no clue what the BackSpace keysym was doing!  Certainly not
 * Backspacing!!!  It worked on the command-line, but in some X apps it
 * would give me the <+/-> character, and in others, nothing...   weird.
 * 
 * Also, there are four diagonal cursor keys on this keyboard (up-left,
 * up-right, down-left, down-right) which each generate two keycodes per
 * keypress event.   I didn't know what to do about this in the
 * gw2k-codes.h file, so I just put in the first keycode that gets
 * generated (see the comments in row4 and row6 in that file).  Also, I
 * didn't know what to put in the gw2k-caps.h file since there are no
 * diagonal arrow keycaps to put on the keys, so again, I put the keycap
 * that corresponds to the first keycode generated (I tried putting both
 * on, but it looked funny to me) and "shifted" the arrows to differentiate
 * them from the normal up and down keys.
 */

static const struct default_keycode_map gw2k_map [] = {

/* This key has a keycode, but no keysym in the default map */
  { 111, 0,		{ XK_Print }},	/* Print Screen */
					 
  {   9, 0,		{ XK_Escape }},
  {  10, 0,		{ XK_1,	XK_exclam }},
  {  11, 0,		{ XK_2,	XK_at }},
  {  12, 0,		{ XK_3,	XK_numbersign }},
  {  13, 0,		{ XK_4,	XK_dollar }},
  {  14, 0,		{ XK_5,	XK_percent }},
  {  15, 0,		{ XK_6,	XK_asciicircum }},
  {  16, 0,		{ XK_7,	XK_ampersand,
			XK_braceleft }},
  {  17, 0,		{ XK_8,	XK_asterisk,
			XK_bracketleft }},
  {  18, 0,		{ XK_9,	XK_parenleft,
			XK_bracketright }},
  {  19, 0,		{ XK_0,	XK_parenright,
			XK_braceright }},
  {  20, 0,		{ XK_minus,	XK_underscore,
			XK_backslash }},
  {  21, 0,		{ XK_equal,	XK_plus }},
  {  22, 0,		{ XK_Delete }},
  {  23, 0,		{ XK_Tab }},
  {  24, 0,		{ XK_q,	XK_Q,
			XK_q }},
  {  25, 0,		{ XK_w,	XK_W,
			XK_w }},
  {  26, 0,		{ XK_e,	XK_E }},
  {  27, 0,		{ XK_r,	XK_R,
			XK_r }},
  {  28, 0,		{ XK_t,	XK_T,
			XK_t }},
  {  29, 0,		{ XK_y,	XK_Y,
			XK_y }},
  {  30, 0,		{ XK_u,	XK_U,
			XK_u }},
  {  31, 0,		{ XK_i,	XK_I,
			XK_i }},
  {  32, 0,		{ XK_o,	XK_O,
			XK_o }},
  {  33, 0,		{ XK_p,	XK_P,
			XK_p }},
  {  34, 0,		{ XK_bracketleft,	XK_braceleft }},
  {  35, 0,		{ XK_bracketright,	XK_braceright,
			XK_asciitilde }},
  {  36, 0,		{ XK_Return }},
  {  37, ControlMask,	{ XK_Control_L }},
  {  38, 0,		{ XK_a,	XK_A }},
  {  39, 0,		{ XK_s,	XK_S,
			XK_s }},
  {  40, 0,		{ XK_d,	XK_D }},
  {  41, 0,		{ XK_f,	XK_F }},
  {  42, 0,		{ XK_g,	XK_G,
			XK_g }},
  {  43, 0,		{ XK_h,	XK_H,
			XK_h }},
  {  44, 0,		{ XK_j,	XK_J,
			XK_j }},
  {  45, 0,		{ XK_k,	XK_K,
			XK_k }},
  {  46, 0,		{ XK_l,	XK_L,
			XK_l }},
  {  47, 0,		{ XK_semicolon,	XK_colon }},
  {  48, 0,		{ XK_apostrophe,	XK_quotedbl }},
  {  49, 0,		{ XK_grave,	XK_asciitilde }},
  {  50, ShiftMask,	{ XK_Shift_L }},
  {  51, 0,		{ XK_backslash,	XK_bar }},
  {  52, 0,		{ XK_z,	XK_Z,
			XK_z }},
  {  53, 0,		{ XK_x,	XK_X,
			XK_x }},
  {  54, 0,		{ XK_c,	XK_C }},
  {  55, 0,		{ XK_v,	XK_V,
			XK_v }},
  {  56, 0,		{ XK_b,	XK_B }},
  {  57, 0,		{ XK_n,	XK_N,
			XK_n }},
  {  58, 0,		{ XK_m,	XK_M,
			XK_m }},
  {  59, 0,		{ XK_comma,	XK_less }},
  {  60, 0,		{ XK_period,	XK_greater }},
  {  61, 0,		{ XK_slash,	XK_question }},
  {  62, ShiftMask,	{ XK_Shift_R }},
  {  63, 0,		{ XK_KP_Multiply }},
  {  64, Mod1Mask,	{ XK_Alt_L,	XK_Meta_L }},
  {  65, 0,		{ XK_space }},
  {  66, LockMask,	{ XK_Caps_Lock }},
  {  67, 0,		{ XK_F1,	XK_F11 }},
  {  68, 0,		{ XK_F2,	XK_F12 }},
  {  69, Mod3Mask,	{ XK_F3,	XK_F13 }},
  {  70, 0,		{ XK_F4,	XK_F14 }},
  {  71, 0,		{ XK_F5,	XK_F15 }},
  {  72, 0,		{ XK_F6,	XK_F16 }},
  {  73, 0,		{ XK_F7,	XK_F17 }},
  {  74, Mod3Mask,	{ XK_F8,	XK_F18 }},
  {  75, 0,		{ XK_F9,	XK_F19 }},
  {  76, Mod3Mask,	{ XK_F10,	XK_F20 }},
  {  77, Mod2Mask,	{ XK_Num_Lock }},
  {  78, 0,		{ XK_Multi_key }},
  {  79, 0,		{ XK_KP_7 }},
  {  80, 0,		{ XK_KP_8 }},
  {  81, 0,		{ XK_KP_9 }},
  {  82, 0,		{ XK_KP_Subtract }},
  {  83, 0,		{ XK_KP_4 }},
  {  84, 0,		{ XK_KP_5 }},
  {  85, 0,		{ XK_KP_6 }},
  {  86, 0,		{ XK_KP_Add }},
  {  87, 0,		{ XK_KP_1 }},
  {  88, 0,		{ XK_KP_2 }},
  {  89, 0,		{ XK_KP_3 }},
  {  90, 0,		{ XK_KP_0 }},
  {  91, 0,		{ XK_KP_Decimal }},
  {  94, 0,		{ XK_less,	XK_greater,
			XK_bar }},
  {  95, 0,		{ XK_F11 }},
  {  96, 0,		{ XK_F12 }},
  {  97, 0,		{ XK_Home }},
  {  98, 0,		{ XK_Up }},
  {  99, 0,		{ XK_Prior }},
  { 100, 0,		{ XK_Left }},
  { 102, 0,		{ XK_Right }},
  { 103, 0,		{ XK_End }},
  { 104, 0,		{ XK_Down }},
  { 105, 0,		{ XK_Next }},
  { 106, 0,		{ XK_Insert }},
  { 107, 0,		{ XK_Delete }},
  { 108, 0,		{ XK_KP_Enter }},
  { 109, ControlMask,	{ XK_Control_R }},
  { 110, 0,		{ XK_Pause }},
  { 112, 0,		{ XK_KP_Divide }},
  { 113, Mod5Mask,	{ XK_Mode_switch }},
  { 114, 0,		{ XK_Break }}
  };
