.\" Up-to-date as of 2-Feb-1998 Guylhem AZNAR (guylhem@oeil.qc.ca)
.TH AFTERSTEP 1.4 "February 1998" AfterStep
.SH NAME
afterstep \- X11 window manager
.SH SYNOPSIS
.B afterstep [-d
.I dpy
.B ] [-debug] [-f
.I config_file
.B ] [-s]
.SH WARNING
This 
.I afterstep.man
file is not very up to date, please refer to New-in-1.4 or look.NEWFEATURES
examples for Zap, GetHelp, ChangeWindow, ChangeBackground, ChangeLook &
ChangeFeel, TitleTextMode, ResizeMoveGeometry and start menu directory.

.SH DESCRIPTION & HISTORY
.I AfterStep
is a continuation of the BowMan window manager which was
originally put together by Bo Yang.  BowMan was based on the fvwm window 
manager, written by Robert Nation.  Fvwm was based on code from twm.  And 
so on...  It is designed not only to emulate some of the look and feel of
the NEXTSTEP(tm) user interface, but also to add useful, requested, and neat 
features.  The changes which comprise
.I AfterStep's
personality were originally part of BowMan development, but due to a desire
to move past SIMPLE EMULATION and into a niche as its OWN valuable window
manager, the previous designers decided to change the project name and move
on.

Some major changes from
.I fvwm 1.24
include:
.RS
1. NEXTSTEP(tm)-alike title bar, title buttons, borders and corners.
.RE
.RS
2. 
.I AfterStep's
.I Wharf
To avoid copyright complications it is not called a "Dock".
.RE
.RS
3. NEXTSTEP(tm) style menus. However the menus are not controlled by
applications, they are more of pop-up service lists on the root window.
.RE
.RS
4. NEXTSTEP(tm) style icons. The default icons are consistent with those in
the NEXTSTEP(tm) interface, but they are configurable.
.RE
.RS
5. Dissociation of Pager desktops for background pixmaps and configuration :
each desktop can have its own configuration, its own look, its own background
picture and all this can be changed on fly with Start/Desktop menu.
.RE

However, flexibility was not traded off. Initiation files, in
.IR ~/GNUstep/Library/AfterStep
, recognizes most of the fvwm 1.24r commands.
.SH SPECIAL NOTE FOR XFREE86 USERS
XFree86 provides a virtual screen whose operation  can  be
confusing  when used in conjunction with this virtual window manager.
With XFree86, windows  which  appear  on  the virtual  screen  actually  get
drawn into video memory, so the virtual screen size is limited by available
video memory.

With
.I AfterStep's
virtual desktop, windows which do not appear
on the screen do not actually get drawn  into  video  RAM.
The size of the virtual desktop is limited to about 32,000
by 32,000 pixels. It is probably impractical to use a
virtual desktop more than about 5 times the visible screen in
each direction.  Note that memory usage with  the  virtual
desktop  is  a  function of  the  number of windows which
exist. The size of the desktop makes no difference.

When becoming familiar with
.I AfterStep
, it is  recommended  that
you  disable XFree86's virtual screen, by setting the virtual
screen size to the physical screen size. When familiar with
.I AfterStep
, you may want to re-enable XFree86's virtual screen.
.SH COPYRIGHTS
.I AfterStep
is distributed under GNU GPL v2.
However, AfterStep was based on
.I BowMan
which derived from
.I Fvwm
code, which is in turn derived from
.I twm
code, thus some C source file from
.I AfterStep
shares copyrights with 
.I twm.

.I AfterStep
is copyright 1996 by Frank Fejes, Alfredo Kojima, and Dan Weeks.
& copyright 1998 by Guylhem Aznar, Raphael Goulais, and Rob Malda.

Please see the file COPYING included with the
.I AfterStep
distribution for the conditions that are incumbent on the users of
.I AfterStep
due to its relations to fvwm and twm.

AUTHORS AND ALL OTHER CONTRIBUTERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
NO EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTUOUS
ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
.SH ANATOMY OF A WINDOW
.I AfterStep
puts  a  decorative border on the top and bottom of most windows. This
border consists of a bar on the bottom that is divided into three sections.
These sections are referred to as "handles".
There is also a top bar called the title bar which is used to display
the name of the window and two title-bar buttons.

Unless the standard defaults files are modified, pressing
mouse button 1 on the titlebar will begin a move
operation on the window. Pressing button 1 on the bottom handle 
bar will begin a resize operation. Pressing button 2 on the titlebar will move
the window to the foreground or the background.

The default configuration has 2 title-bar buttons on each side of the
title-bar, with one extra one on the right side.

.SH BUTTONS

Click[mouse button] is abbreviated to CN and buttons are called 1/2 3/4/5 from
left to right :

1 will change to next window with C1 or C2 and open help file with C3
2 will open window functions with C1 and open window list with C2 or C3

(window title is between 2 and 3)

3 will iconify the window with C1 and maximise the window with C2 or C3
4 will hide the window under its titlebar with C1 and stick it to the screen
(if you move on your desktop) with C2 or C3

5 will kill the window, nicely with C1 or C2 and badly with C3

See the section on "Mouse" for more information.  Further modifications to
.I AfterStep's
behavior can be made creating a file in
~/GNUstep/Library/AfterStep/desktop/looks/ , using examples a guide.

Shaped windows such as xeyes or oclock get a title bar that floats above
the window and no bottom bar.  The background area of shaped windows is
transparent.  If you are tight on memory, you can disable the SHAPE
extensions by modifying configure.h and recompiling
.I AfterStep.
This way shaped windows get a solid color background and you save about
60 kbytes of memory when no shaped windows are present.
Of couse, shaped window are nicer with SHAPE enabled ! 
.SH THE VIRTUAL DESKTOP
.I AfterStep
provides multiple virtual desktops for users who wish
to use them. The screen is a viewport onto a desktop which
is larger than (or the same size as) the screen.  Several
distinct desktops  can   be accessed. Concept: one desktop
for each project, or one desktop  for  each  application,
when  view  applications are distinct.  Since each desktop
can be larger than the physical screen, windows which  are
larger  than  the  screen, or large groups of related
windows, can easily be viewed.

The size of the each virtual desktop must be specified  at
start-up (default:  2  times  the  physical  size  of the
screen). All virtual desktops must be the same  size.  The
total  number  of distinct desktops need not be specified,
but is limited to approximately 4 billion total. All windows
on the current desktop can be displayed in a Pager,
or miniature view or the current desktop.  Windows  which
are  not on the current desktop can be listed, along with
their geometries, in a window list, accessible as a pop-up
menu.

"Sticky" windows  are windows which transcend the virtual
desktop by "Sticking to the screen's glass."  They  always
stay  put  on  the  screen.  This is convenient for things
like clocks and xbiff's, so you only need to run one  such
gadget, and it always stays with you.

Window  geometries  are specified relative  to the current
viewport. That is, xterm -geometry +0+0, will always show up
in  the  upper-left  hand corner of the visible portion of
the screen. It is permissible to specify geometries  which
place  windows on the virtual desktop, but off the screen.
For example, if the visible screen is 1000 by 1000 pixels,
and  the desktop size is 3x3, and the current viewport is
at the upper left hand corner of the desktop, then  invoking
xterm -geometry +1000+1000 will place the window just
off of the lower right hand corner of the screen.  It  can
be  found by moving the mouse to the lower right hand corner
of the screen, and waiting for it to scroll into view.
There  is currently no way to cause a window to map onto a
desktop  other than the currently active desk.
A geometry specified as  something  like xterm -geometry -5-5
will  generally  place  the windows lower right hand
corner 5 pixels from the lower right hand  corner  of  the
visible  portion of the screen. Not all applications
support window geometries with negative offsets.

Some applications, like xterm and xfontsel, allow the user
to  specify  the start-up desk on the command line. xterm
-xrm "*Desk:1" will start an xterm on desk number 1. Other
applications do not understand this option but you can force
them to start on a desktop if you edit 'feel' in
~/GNUstep/Library/AfterStep/desktop/feels/ and define StartsOnDesk X in
Style.

.SH INITIALIZATION
During  initialization,
.I AfterStep
will search for a configuration file which describes key and
button bindings, and a few  other  things.  The format  of
these  files will be described later. First,
.I AfterStep
will search for a directory named GNUstep/Library/AfterStep/ in the user's
home directory.  Failing that, it will look for
/usr/share/afterstep/ for system-wide defaults.
If that file is not found,
.I AfterStep
will exit.

If you use system-wide defaults, 'startmenu' file in this directory must be
world writtable (run 'chmod 666 startmenu'). It is a serious security hole !

You can also launch
.I AfterStep
with -f flag to use your former
.I .steprc
file, like : afterstep -f ~/myold.steprc
.I AfterStep
will  set  two  environment  variables which will be
inherited  by  its  children.  These  are  $DISPLAY  which
describes  the  display on which
.I AfterStep 
is running. $DISPLAY
may be unix:0.0 or :0.0, which doesn't work too well  when
passed  through  rsh  to another machine, so $HOSTDISPLAY
will also be set, and will use a network-ready description
of  the display. Unfortunately, $HOSTDISPLAY will use the
tcp/ip transport protocol, even for a  local  connection,
so  $DISPLAY  should  be used for local connections, as it
may use unix-domain sockets, which are faster.
.SH ICONS
By default,
.I AfterStep
is compiled with XPM extensions which allow 
one to use color icons similar to those in NEXTSTEP(tm), ctwm, Microsoft
Windows (tm), or the Macintosh (tm).  In order to use these options, you
will need the XPM  package,  which should be available at:
ftp://ftp.x.org/contrib/libraries.  XPM extensions can be removed from
.I AfterStep
if one wants to have monochrome icons and doesn't want pixmap tiled
titlebars, etc.
.SH MODULES
A  module  is  a separate program, which runs as a separate unix
process, but transmits commands to
.I AfterStep
to execute.  These modules get many kinds of window information from
.I AfterStep.
Users can  write their  own  modules  to  do any weird or bizarre
manipulations, without affecting the integrity of
.I AfterStep
itself.

Modules MUST be spawned by
.I AfterStep,
(i.e. not executed from the command line) so that
.I AfterStep
can set up two pipes used for communication between the module and
.I AfterStep.
Modules can be spawned during
.I AfterStep
initialization via  the Module  option, or at any time during the X
session by use
of the Module built-in function. Modules can exist for the duration
of  the X session, or can perform a single task and exit.

If a module is still active when
.I AfterStep
is told  to  quit,
.I AfterStep
will close down the communication pipes, and
wait to receive a SIGCHLD from the module, indicating that
it  has detected the pipe closure, and has exited. If modules
fail to detect the pipe closure,
.I AfterStep
will exit after approximately  30 seconds anyway. The number of
simultaneously executing modules is limited by the operating
system's maximum number of simultaneously open files, usually
between 60 and 256.

Modules are documented in their own manual pages.
.SH ICCCM COMPLIANCE
.I AfterStep
attempts  to  be  ICCCM  2.0  compliant.  As of this 1.4 release,
colormap handling is not completely ICCCM compliant.
In addition, ICCCM states that it should be possible
for applications to receive ANY keystroke,  which  is  not
consistent  with the  keyboard   shortcut approach used in
.I AfterStep
and most other window managers.  The user can disable any
.I AfterStep
keystroke that should be passed to the application and not intercepted by
the window manager.

.SH OPTIONS
.IP "-d displayname"
Manage  the  display called, "displayname", instead of the name obtained from 
the environment variable $DISPLAY.
.IP -debug

Puts X transactions in synchronous mode, which dramatically slows things down, 
but guarantees that
.I AfterStep's
internal error messages are correct.
.IP "-f config_file"
Causes 
.I AfterStep
to use an old format .steprc
.I 'config_file'
instead of
.IR ~/GNUstep/Library/AfterStep
directory where the window manager configuration files are actually.
.IP -s
Run
.I AfterStep
on only the specified screen of a multi-screen display.  Normally,
.I AfterStep
will attempt to start up on all screens of a multi-screen display.  The 
"specified screen" is the one provided in the DISPLAY environment variable, 
or provided through the
.I -d
option.
.SH CONFIGURATION OPTIONS
The configuration directory, usually
.IR ~/GNUstep/Library/AfterStep/
,contains many files used to describe mouse and button bindings, colors, the
virtual display size, and related items.  This section describes the
configuration options.  
Each file from this directory plus the ones in desktop/looks and desktop/feels
contain different options but only files ending with the colordepth of your
display will be used (i.e. the colors it can manage, for example 8bpp or 16bpp)
Lines within the configuration files beginning
with '#' will be ignored by
.I AfterStep.
Lines starting with '*' are expected to contain module configuration commands.
Module are configured by ~/GNUstep/Library/AfterStep/respective module name
files.

StdForeColor
.I colorname
.RS
Sets  the foreground  color  for  menus   and  non-selected  window  titles 
to
.I colorname.
When using a monochrome screen,  this  option  is  ignored, and
black is used.
.RE

StdBackColor
.I colorname
.RS
Sets  the background  color  for  menus,  and non-selected  windows to
.I colorname.
When using a monochrome  screen,  this option  is  ignored, and
white is used.
.RE

StickyForeColor
.I colorname
.RS
Sets the foreground color for  non-selected  window
sticky  (Sticks-to-glass) titles to
.I colorname.
When using a monochrome screen, this option is ignored,
and black is used.
.RE

StickyBackColor
.I colorname
.RS
Sets the background color for  non-selected  window sticky (Sticks-to-glass)
windows to
.I colorname.
When using a monochrome screen, this option is ignored,
and  white is used.
.RE

HiForeColor
.I colorname
.RS
Sets the color for selected window's title to
.I colorname.
When using a monochrome screen, this option is ignored, and black is used.
Note that this currently also controls the menu highlights, popup menu titles
and the icon title font.  This is a "feature."
.RE

HiBackColor
.I colorname
.RS
Sets the background color for the selected window to
.I colorname.
When using a monochrome screen, this option is ignored, and white is used.
Note that this also controls the IconTitle background color.
.RE

MenuForeColor
.I colorname
.RS
Sets the menu foreground color.  When using monochrome, this option is ignored.
.RE

MenuBackColor
.I colorname
.RS
Sets the menu background color.  When using monochrome, this option is ignored.
.RE

MenuStippleColor
.I colorname
.RS
Sets the color for shaded out entries in menus (for
functions which  are  not allowed on the currently
selected  window).  When  using  monochrome,   this
option  is  ignored, and a stipple pattern is used.
.RE

MenusHigh
.RS
Makes the popup menu submenus appear at the top of the
parent menu instead of starting at the point in the parent window where
the submenu item lies.
.RE

PagerFont
.I fontname
.RS
Makes
.I AfterStep
use the font
.I fontname
instead of "fixed" for the pager labels.
.RE

TextureTypes
.I focusedtitle unfocusedtitle stickytitle menutitle menuitem
.RS
Specifies the type of gradient fill to be used on each of the
above parts of the
.I AfterStep
windows.  Currently valid values are:
.nf
0 - No texture
1 - Wharf-style gradient
2 - Horizontal one way gradient
3 - Horizontal cylindrical gradient
4 - Vertical one way gradient
5 - Vertical cylindrical gradient
128 - User specified pixmap (See TitlePixmap, etc)
.fi
.B TextureTypes 1 1 1 1 1.
This makes all gradients fill from the upper left to the lower right with your
specified colors.
.RE

TextureMaxColors
.I title unfocusedtitle stickytitle menutitle menuitem
.RS
The number of colors to use on textures.  Default is
.B TextureMaxColors  10 10 10 10 10
on 8 bpp screens and
.B TextureMaxColors  128 128 128 128 128
on 16+ bpp screens. The actual number of allocated colors may be lower.
You must at least specify a value for
.I title.
.RE

TitleTextureColor
.I from to
.RS
Colors that the gradient will go
.I from
and
.I to
when gradients are drawn in a window titlebar.  The default values for from and 
to are #101030 and  #303080 respectively.  Values must be in either standard
X color names or hex notation.
.RE

UTitleTextureColor
.I from to
.RS
Colors that the gradient will go
.I from
and
.I to
when gradients are drawn in a non-focused window titlebar.  The default values for from and 
to are #86868a and  #c0b6c3 respectively.  Values must be in either standard
X color names or hex notation.
.RE

STitleTextureColor
.I from to
.RS
Colors that the gradient will go
.I from
and
.I to
when gradients are drawn in a sticky window titlebar.  The default values for
from and to are #86868a and #c0b6c3 respectively.  Values must be in either standard
X color names or hex notation.
.RE

MenuTextureColor
.I from to
.RS
Colors that the gradient will go
.I from
and
.I to
when gradients are drawn on the menu entries.  The default values for from and 
to are #101030 and  #404090 respectively.  Values must be in either standard
X color names or hex notation.
.RE

MTitleTextureColor
.I from to
.RS
Colors that the gradient will go
.I from
and
.I to
when gradients are drawn for menu titles.  The default values for from and 
to are #101030 and  #303080 respectively.  Values must be in either standard
X color names or hex notation.
.RE

TitlePixmap
.I xpmname
.RS
If the TextureType of the focused titlebar is set to 128, this command
causes the xpm defined by
.I xpmname
to be tiled in the titlebar instead of a solid color or a gradient texture.
Note that the titlebar by default can show a pixmap of up to 19 pixels in
height, though it may be of any length.  One need not specify the complete
path if the xpm is in the directory defined by PixmapPath.
.RE

UTitlePixmap
.I xpmname
.RS
If the TextureType of unfocused titlebars is set to 128, this
command causes the xpm defined by
.I xpmname
to be tiled in the titlebar instead of a solid color or a gradient texture.
Note that the titlebar by default can show a pixmap of up to 19 pixels in
height, though the xpm graphic may be of any actual height and length.  The
full path to the xpm is not required if it is in the directory defined by
PixmapPath.
.RE

STitlePixmap
.I xpmname
.RS
If the TextureType of sticky titlebars is set to 128, this
command causes the xpm defined by
.I xpmname
to be tiled in the titlebar of sticky windows instead of a solid color or
a gradient texture.  Note that the titlebar by default can show a pixmap of
up to 19 pixels in height, though the xpm graphic may be of any actual height
and length.  The full path to the xpm is not required if it is in the
directory defined by PixmapPath.
.RE

TexturedHandle
.RS
Turns on textures for all window handles.  The
handle texture will be the same as the texture used in the window's
titlebar.
.RE

GradientText
.RS
Causes a gradient to be applied to the titlebar text of the focused
window.  The gradient colors are set using TextGradientColor.
.RE

TextGradientColor
.I from to
.RS
Colors that the gradient will go
.I from
and
.I to
when gradients are drawn for the titlebar text.  The default values for from
and to are #101030 and  #303080 respectively.  Values must be in either
standard X color names or hex notation.
.RE

TitleTextAlign
.I num
.RS
Defines the alignment of the window title in the titlebar.  The
allowable values for
.I num
are as follows:
.nf
1: left aligned
2: right aligned
3: center aligned (default)
.fi
.RE

TitlebarNoPush
.RS
Causes the titlebar not to appear to be "pushed in" when you click on
it with a mouse button.  This is useful to reduce video strain or if you use
textured pixmaps that do not look good "pushed in."
.RE

TitleButton
.I num xpmname
.RS
Defines the pixmaps to use instead of the default NEXTSTEP(tm) style
titlebar buttons that are the default.  Up to 8 buttons are possible.
.I num
specifies the position of the button on the window and is an integer
from 1-8.  The positions are indicated as below:
.nf
1 3 5 7   TitleBarText  8 6 4 2
.fi
Note that you must bind an action to any new buttons you add using
the Mouse definitions.  The pixmap defined by
.I xpmname
should be exactly 10x10 pixels to fit inside the gray button bevel.
.RE

Font
.I fontname
.RS
Makes
.I AfterStep
use the font
.I fontname
instead of "fixed" for
menus, the resize indicators, and icon  labels  (if IconFont is not specified).
.RE

WindowFont
.I fontname
.RS
Makes
.I AfterStep
use the font
.I fontname
instead of "fixed" for the window title bar.
.RE

.\" NoBorder
.\" .I windowname
.\" .RS
.\" Keeps
.\" .I AfterStep
.\" from putting decorative borders on windows named
.\" .I windowname.
.\" This command has  no  effect on  the  title-bar.
.\" This is handy for clocks and
.\" similar gadgets that you don't want to take up  too
.\" much space.
.\" .I windowname
.\" can be a window's name or its class.
.\" 
NoTitle
.I windowname
.RS
Keeps
.I AfterStep
from putting a titlebar in the decorations
for windows named
.I windowname.
This  is  handy for clocks and similar gadgets that you don't want
to take up too much  space.
.I windowname
can be a window's name or its class.

.I Windowname
can  contain  the wildcards "*" and "?"
which match window names in the normal  unix  filename
matching  manner: "*" matches any number of any character and "?"
matches one of any character.  Actual "*", "?", and "\\"
characters in a window name can be entered by  preceding
the character with a "\\".
.RE

Sticky
.I windowname
.RS
Sticky windows "stick to the screen's glass."  That
is,  they don't move the the viewport into the virtual
desktop changes.
.I windowname
can be a window's name or its class.  See NoTitle for a discussion of the
.I windowname
parameter.
.RE

StaysOnTop
.I windowname
.RS
These   windows  always  try  to stay on top of the
other windows. This might be handy  for  clocks  or
mailboxes that you would always like to be visible.
If the window is explicitly lowered,  it  will  not
try  to  force  its way back to the top until it is
explicitly raised.
.I windowname
can  be  a window's name or its class. See NoTitle for
a discussion of the
.I windowname
parameter.
.RE

StartsOnDesk
.I windowname desk-number
.RS
This  command causes windows whose name or class is
.I windowname
to be initially placed on desktop number
.I desk-number.  windowname
should be enclosed in double quotes.  If  the  window  requires  interactive
placement, an outline will be displayed on the current desk,
but the window will appear on the specified desk.
See NoTitle for a discussion of the
.I windowname
parameter.
.RE

CirculateSkip
.I windowname
.RS
Causes  windows  with  the  indicated  name  to  be
skipped over when the  CirculateUp,  CirculateDown or Warp
functions  are  invoked.
.I windowname
can be a window's name or its class.
See NoTitle for a discussion of the
.I windowname
parameter.
.RE

CirculateSkipIcons
.RS
Causes circulate and warp operations to  skip  over
iconified windows.
.RE

WindowListSkip
.I windowname
.RS
Causes  windows  with the indicated name to be left
out of the window list.  See NoTitle for a discussion of the
.I windowname
parameter.
.RE

NoFocus
.I windowname
.RS
Causes  windows  with the indicated name to not take the focus when
the pointer moves over them in focus-follows-mouse (the default) mode,
or when the window is clicked in ClickToFocus mode.
See NoTitle for a discussion of the
.I windowname
parameter.
.RE

Style
.I windowname options
.RS
This command is intended to  replace  the commands
NoFocus, NoBorder, NoTitle,  StartsOnDesk, Sticky, StaysOnTop,
Icon, WindowListSkip, CirculateSkip, SuppressIcons,
BoundaryWidth, NoBoundaryWidth, StdForeColor, and
StdBackColor with a single flexible and comprehensive
command.  This command is used to set attributes of a 
window to values  other than the default, or to set
the  window-manager default styles.
.I windowname
can  be  a  window's  name,  class   or
resource  string. It  can  contain the wildcards "*"
and/or "?", which are matched in the usual unix filename manner.
.I options
is a comma separated list containing all or
some of the keywords BorderWidth, HandleWidth, NoFocus,
Icon/NoIcon, NoTitle/Title, NoHandles/Handles,
WindowListSkip/WindowListHit, CirculateSkip/CirculateHit,
StaysOnTop/StaysPut, Sticky/Slippery, StartIconic/StartNormal,
Color, ForeColor, BackColor, StartsOnDesk/StartsAnyWhere,
and IconTitle/NoIconTitle.

In the above  list,  some options  are  listed  as
style-option/opposite-style-option.  The  opposite-style-option
for entries that have  them  describes
the default behavior, and can be used if you
want to change the default behavior.

Icon takes an (optional) unquoted string  argument
which  is the icon bitmap or pixmap to use.  StartsOnDesk
takes a numeric argument which is the desktop number on which
the window should be initially placed.  BorderWidth takes a
numeric argument which is  the width of the border to place the
window if it does not have resize-handles.  HandleWidth takes
a numeric argument which is the height of the bottom bar
to place with the window if it has resize handles.

Color takes two arguments. The first is the window label's 
text color, and the second is the window decoration's normal
background color.  The two colors are separated with a slash.
If the use of a slash causes  problems, then the separate
ForeColor and BackColor options can be used.

An example:

.nf
# Change default AfterStep behavior to no titlebars on windows!
# Also, define a default icon.
Style "*" NoTitle,Icon unknown1.xpm,BorderWidth 4,HandleWidth 5

# now, window specific changes:
Style "WinList"    NoHandles,Sticky,WindowListSkip
# modules with AfterStep 
Style "Pager"      StaysOnTop, NoHandles,Sticky,WindowListSkip
Style "*clock"     NoHandles,Sticky,StaysOnTop,WindowListSkip
Style "xbiff"      Sticky,WindowListSkip
Style "Wharf"      NoHandles,Sticky,WindowListSkip
Style "sxpm"       NoHandles

# Put title-bars back on xterms only!
Style "xterm"      Title, Color black/grey
Style "rxvt"       Icon term.xpm
Style "xterm"      Icon rterm.xpm
Style "xcalc"      Icon xcalc.xpm
Style "xbiff"      Icon mail1.xpm
Style "xmh"        Icon mail1.xpm, StartsOnDesk 2
Style "xman"       Icon xman.xpm
Style "matlab"     Icon math4.xpm, StartsOnDesk 3
Style "xmag"       Icon magnifying_glass2.xpm
Style "xgraph"     Icon graphs.xpm
Style "Maker"      StartsOnDesk 1
Style "signal"     StartsOnDesk 3
.fi

Note that all properties for a window will be read
together. In the above example "Pager" gets the
property StaysOnTop via an exact window name match,
but  also gets NoHandles,Sticky, and WindowListSkip
by a match to "AfterStep*".  It  will get  NoTitle  by
virtue of a match to "*". If conflicting styles are
specified for a window, then the last style  specified will be used.

If  the NoIcon attribute is set, then the specified
window will simply disappear when it is  iconified.
The  window  can  be recovered through the window list.
If Icon is set without an argument, then  the
NoIcon  attribute is cleared, but no icon is specified.
An example which allows  only  the Pager
module icon to exist:

.nf
Style "*" NoIcon
Style "Pager" Icon
.fi
.RE

CenterOnCirculate
.RS
When  circulating,  the desktop page containing the
window which the pointer is moving to is  automatically
selected.  If CenterOnCirculate is selected,
then
.I AfterStep
will do its best  to  center  the  target
window  in  the  desktop viewport, rather than just
lining up to the closest page.
.RE

DeskTopSize
.I HorizontalxVertical
.RS
Defines the virtual desktop size in units of the physical screen size.
.RE

DeskTopScale
.I Scale
.RS
Defines  the  virtual desktop scale with respect to the screen.
.RE

BoundaryWidth
.I Width
.RS
Changes the bottom bar (handle) size (in pixels) on windows to the specified
value.  The default size is 8.
.RE

NoBoundaryWidth
.I Width
.RS
Changes the width of the bottom bar (handle) for windows
with no titles and no resize corners.  The default is 0.
Any positive or zero value is acceptable.  The handles without
resize corners have the same mouse and keyboard bindings as
the handles on normal windows.
.RE

XORvalue
.I number
.RS
Changes the value with which bits are  XOR'ed  when
doing  rubber-band  window moving or resizing. Setting
this value is a trial-and-error process.
.RE

EdgeScroll
.I horizontal vertical
.RS
Specifies the percentage of a page to  scroll  when
the  cursor  hits the edge of a page. If you don't
want any paging or scrolling when you hit the  edge
of  a  page, include EdgeScroll 0 0 in your look
file. If you want whole pages, use  EdgeScroll  100
100.  Both  horizontal and vertical should be positive numbers.

If the horizontal and vertical percentages are multiplied by 1000,
then scrolling will wrap around at
the edge of  the  desktop.  If  "EdgeScroll  100000
100000"  is  used,
.I AfterStep
will scroll by whole pages, wrapping around at the edge of the desktop.
.RE

PagingDefault
.I pagingdefaultvalue
.RS
Tells
.I AfterStep
if  it  should  start up  with  paging
enabled  or disabled.  "PagingDefault 0" will start
.I AfterStep
with paging disabled, "PagingDefault 1"  will
start
.I AfterStep
with paging enabled by default.
.RE

EdgeResistance
.I scrolling moving
.RS
Tells  how  hard it should be to change the desktop
viewport by moving the mouse over the edge  of  the
screen,  and how hard it should be to move a window
over the edge of the screen.

The first parameter  tells  how   milliseconds  the
pointer  must  spend on the screen edge before
.I AfterStep
will move the viewport. This is intended for people
who  use  EdgeScroll  100 100, but find themselves
accidentally flipping pages when  they  don't  want
to.

The second parameter tells how many pixels over the
edge of the screen a window's edge must move before
it actually moves partially off the screen.

Note  that, with EdgeScroll 0 0, it is still possible
to move or resize windows across  the edge  of
the  current  screen. By making the first parameter
to EdgeResistance 10000, this  type  of  motion  is
impossible.  With EdgeResistances less than 10000,
but greater than 0, moving over pages becomes  difficult
but not impossible.
.RE

OpaqueMove
.I percentage
.RS
Tells
.I AfterStep
the  maximum size  window  with which
opaque window movement should be used. The percentage
is  percent  of  the total   screen area. With
OpaqueMove 0, all windows will be moved  using  the
traditional  rubber-band  outline.  With OpaqueMove
100, all windows will be move as solid windows. The
default  is OpaqueMove 5 which allows small windows
to be moved in an opaque manner, but large  windows
to be moved as rubber-bands.  Using this option with
large values can slow down your video response on
slower systems.
.RE

ClickToFocus [\fIflag\fP]
.RS
Normally keyboard input goes to the window the mouse pointer is in. If
this option is set, the keyboard input (aka focus) stays with one
window until a new window is clicked on.

If the (optional) \fIflag\fP is given a nonzero value, a mouse button
click that changes the keyboard focus is caught and processed only by
\fIAfterStep\fP.  If the \fIflag\fP is zero, or is not supplied, a
click that changes the focus is passed through for the application to
process.

When the flag is nonzero, it is useful to assign a NoFocus style to all
applications that are entirely mouse-controlled (e.g. Wharf).
.RE

SloppyFocus
.RS
This option changes the way focus-follows-mouse (the \fIAfterStep\fP
default) mode behaves when the mouse pointer enters the root window
(that is, the background area).  Normally, the keyboard focus would
disappear at this stage, but when SloppyFocus is on, exiting a window
to enter the root window leaves the focus unchanged.  The focus will
not be removed from the last (non-root) window you visited until the
mouse pointer enters a new window.

SloppyFocus has no effect in ClickToFocus mode.
.RE

ClickToRaise \fIbuttons\fP
.RS
In focus-follows-mouse mode, ClickToRaise specifies mouse \fIbuttons\fP
that raise a partially obscured window to the top.  On a window that is
fully visible (except a normal window may still be below \fBStaysOnTop\fP
windows) all the mouse buttons behave normally.  Please note that in most
applications you can use mouse buttons in combination with the shift key
to avoid the ClickToRaise behavior when needed.

In click-to-focus mode, ClickToRaise specifies the mouse \fIbuttons\fP that
raise an unfocused window to the top.  The rest of the mouse buttons merely
change the focus without raising, although you can have them do delayed
raising with the AutoRaise command or the Auto module.

In both focusing modes, ClickToRaise is not triggered on window
decorations such as the title bar, but only on the application area.

The mouse buttons are numbered as in the \fBButton\fP command.  You
can specify any or all of your mouse buttons here as a space- or 
comma-separated list.
.RE

OpaqueResize
.RS
Causes resize operations to be done with the window itself, instead
of an outline.  Using this option does not always work well on slower
video systems.
.RE

DontMoveOff
.RS
Prevents windows from being moved off or  initially
placed off of the desktop.  A few programs will not
work correctly if you use this  option.  This  only
keeps  windows  from  being completely lost off the
edge of the desktop. It insists on keeping 16  pixels
on  the  desktop, but doesn't care a bit about
keeping the whole window on the desk.  See  EdgeResistance
if you don't like having windows partially
off the screen.
.RE

AutoRaise \fIdelay\fP
.RS
This built-in was replaced by the module
.I Auto(1).
.RE

Pager
.I X_Location Y_Location
.RS
Enables a paging style of moving across  the  desktop.
A  Pager  window  will appear at (
.I X_Location, Y_Location
) (not a pop-up). Miniature  versions  of
all  the windows on the virtual desktop
are shown in the pager.  The color of the miniature
version  is  the same as the color of the full-size
window's border.

In the Pager window, pressing mouse button  1  will
move  the desktop viewport to the selected page (in
click-to-focus mode, it will also move the keyboard
focus  to the window whose miniature you click on).
Pressing button 2 on a window  in the  pager  will
begin a window move, using the miniature to quickly
move the window anywhere on the desktop.  Pressing
button 3 will move the top-left corner of the viewport
to the location of the button press, even  if
it does not line up with a page.  Dragging button 3
will cause the selected viewport to scroll  as  you
move   the  pointer.  The Pager   is  automatically
sticky, but does not automatically StayOnTop.
.RE

Mouse
.I Button Context Modifiers Function
.RS
Defines a mouse binding.
.I Button
is the mouse button number.  If  Button  is  zero, then any button will
perform the specified function.
.I Context
describes in what context the binding applies. Valid contexts
are R for the root window,  W  for  an  application
window,  T  for  a window title bar, S for a window
titlebar, or bottom bar, F for a window frame (the
handle corners), I for an Icon window, or any combination of these letters.
1 is for the left title-bar button and 2 is for the title-bar button
A  is  for any context except for title-bar
buttons. For instance, a context of FST will  apply
when  the mouse   is anywhere in a window's border,
except the title-bar buttons.

.I Modifiers
is any combination of N for no modifiers,
C for  control,   S for shift, M for Meta, or A for
any modifier.  For example, a modifier of CM  will
apply  when  both the Meta and shift keys are down.
.I Function
is one of the following:
.I AfterStep's
built in functions, a Pop-up menu, or a user-defined function.
.RE

Key
.I keyname Context Modifiers Function
.RS
Binds  a  keyboard key to a specified
.I AfterStep
built in function. Definition is the same as  for  a  mouse
binding,  except  that  the  mouse button number is
replaced with a key name. The
.I keyname
is one of the
entries from /usr/include/X11/keysymdef.h, with the
leading XK_  omitted.  The
.I Context
and
.I Modifiers
fields are defined as in the mouse binding.
.I Function
is one of the following:
.I AfterStep's
built in functions, a Pop-up menu, or an exec call to a program.

Binding  a key to a title-bar button will not cause
that button to appear unless a mouse  binding  also
exists.
.RE

IconBox
.I left top right bottom
.RS
Defines  regions  of  the screen in which to place
icons. Up to four icon boxes can be defined. If  an
IconBox  line is provided, the icons will automatically
be placed in them, if possible. Each  time  a
window  is  iconified,  a new place is found for it.
Icon boxes are searched for  space  going left  to
right,  then top to bottom. Icons will not be automatically
placed on top of  other  icons,  but  they  may  be
placed  underneath  application windows. If left or
right is negative, then
.I AfterStep
will add  the  screen
width  to it.  If  top or bottom is negative, then
.I AfterStep
will add the screen height to it. NOTE: -0  is
not  parsed  as  the  right  or bottom pixel on the
screen. You have to use -1 instead.

If no IconBox line is provided, or all  icon  boxes
are  full, then
.I AfterStep
will place icons near the current pointer location.
.RE

StubbornIconPlacement
.RS
When used with IconBoxes, causes  icons   to  avoid
placing themselves underneath existing windows.
.RE

StubbornIcons
.RS
Changes de-iconification behavior a bit. Instead of
having windows always de-Iconify themselves on  the
current  page,  the  de-iconify into their original
position.
.RE

SuppressIcons
Prevents icon windows from being created or  drawn.
When  used  with  the  window-list, this provides a
sort of icon manager.
.RE

StickyIcons
.RS
Causes icons to always stick to the screen's glass.
That  is, icons always follow you around the desktop.
When a window is  de-iconified,  it  gets  unstuck.
Some people find this a useful way of moving
windows around.
.RE

IconTitle
.RS
Makes \fIAfterStep\fP add icon titles to the application's icon.  Note
that using icon titles will leave less space for the application icon
itself on the button, since the icontitle covers up part of the button.
.RE

IconFont
.I fontname
.RS
Makes \fIAfterStep\fP use the font
.I fontname
instead  of "fixed" for the IconTitle fonts.
.RE

ButtonNoBorder
.RS
Defines that the icon buttons should not have any borders drawn around
them.  This is particularly useful to have "flat" icon buttons, or if
one defines a pixmap as the background for the buttons that already
includes a border.
.RE

ButtonTextureType
.I num
.RS
Defines the gradient type to use on the icon buttons.  See the
discussion of TextureTypes for the allowable values for
.I num.
Use 0 for num if you want to set a solid color for the texture with
ButtonBgColor.
.RE

ButtonTextureColor
.I from to
.RS
Colors that the gradient will go from and to when
gradients are drawn for icon buttons.  The default
values for
.I from
and
.I to
are #101030 and #303080 respectively.   Values must be in either standard X
color names or hex notation.
.RE

ButtonMaxColors
.I NumColors
.RS
The number of colors to use on icon button textures.
The default is 10 on 8-bit video systems and 128 on 16+ bit
video systems.
.RE

ButtonBgColor
.I Color
.RS
If ButtonTextureType is set to 0, this command forces \fIAfterStep\fP to
use
.I Color
for the button background.   The default value for
.I Color
is #bdbebd.  Values must be in either standard X color names or hex notation.
.RE

ButtonPixmap
.I xpmname
.RS
Defines the xpm file to be used as the background for icon buttons.
This xpm will be what shows through the transparent pixels in the
application's defined xpm icon.  Application icons can be defined
using Icon or Style.
.RE

IconPath
.I path
.RS
Specifies the full path name of a directory  where
bitmap (monochrome) icons  can be found.
The path should start with a slash. Multiple directories may
be  specified  in a colon separated list, just like
the PATH environment  variable.  
.RE

PixmapPath
.I path
.RS
Specifies the  full path name of a directory where
pixmap (color) icons can be found. The path  should
start  with  a  slash.  Multiple directories may be
specified in a colon separated list, just like  the
PATH environment variable.
.RE

Icon
.I windowname bitmap-file
.RS
Specifies the  bitmap to be used for a window when
it is iconified.  The
.I windowname
can be an applications
window  name  or  class  name,  and  must be
enclosed in quotes. The
.I bitmap-file
is  either  the
full  path name to a standard X11 bitmap file, or a
file in the IconPath or PixmapPath.  The  specified
bitmap/pixmap  is used  in  preference to any icon
supplied by the window itself.

If
.I AfterStep
is compiled  with XPM  support  for  color
icons, then can be an XPM pixmap file.

.I windowname
should be enclosed in double quotes, but
.I bitmap-file
should not. No environmental  variables
should be used in the bitmap-file specification.

If
.I windowname
is an empty string, then the specified
file is the default icon, and will be used  if
no other icon bitmap or pixmap can be found:

Icon "" my-favorite-icon
.RE

DecorateTransients
.RS
Causes  transient windows, which are normally left
undecorated, to be given  the  usual
.I AfterStep
decorations. Note  that some pop-up windows, such as the
xterm menus, are not managed by the window manager,
and still do not receive decorations.
.RE

RandomPlacement
.RS
Causes  windows  which would normally require user placement
to be automatically  placed  in ever-so-slightly random locations.
.RE

SmartPlacement
.RS
Causes  windows  which would normally require user placement
to be automatically  placed  in a  smart
location  - a location in which they do not overlap
any other windows on the screen. If no  such  position
can be found, user-placement or random placement
will be used as a fall-back method.  For  the
best of all possible worlds, use both random placement and SmartPlacement.
.RE

StubbornPlacement
.RS
When using SmartPlacement, causes new  windows  to
avoid placing themselves over icons.
.RE

NoPPosition
.RS
Instructs
.I AfterStep
to ignore the PPosition field when
adding new windows.   Adherence  to  the  PPosition
field is required for some applications, but if you
don't have one of those, its a real headache.
.RE

ClickTime
.RS
.I delay
Specifies the  maximum  delay  (in  milli-seconds)
between a button press and a button release for the
Function builtin to consider  the action  a  mouse
click. The default delay is 150 milli-seconds.

The same delay is used to decide whether a pop-up menu brought up by
pressing a mouse button should stay visible after the mouse button is
released.
.RE

ModulePath
.RS
Specifies a  path  for
.I AfterStep
to search when looking for a module to load.  The path is  a  colon
separated  list, just like the usual Unix PATH environment
variable. Individual directories do  not  need
trailing slashes.
.RE

Module
.I ModuleName
.RS
Specifies a  module which should be spawned during
initialization. The modules in the main distribution are :
Animate, Auto, Clean, Ident, Save, Wharf, Audio, Banner, Form, Pager,
Scroll and  WinList.
These modules have their own man pages.
.I Module
can  also  be  used  as  a builtin.  Modules can be short lived transient
programs, or,  like  Wharf,  can be  intended  to
remain  for  the  duration of the X session.
Modules called by
.I Module
will be terminated by the window-manager  prior  to
restarts  and quits, if possible. See the introductory section on modules.
.RE

Cursor
.I cursor_num cursor_type
.RS
This provides a very awkward way of changing cursor
styles.  Cursor  num  tells  which  cursor  you are
changing, and is a number between 0 and 12, as follows:

.nf
0 POSITION      - used when initially placing windows
1 TITLE         - used in a window title-bar
2 DEFAULT       - used in windows that don't bother to set 
                  their cursor
3 SYS           - used in one of the title-bar buttons
4 MOVE          - used when moving or resizing windows
5 WAIT          - used during an EXEC builtin command
6 MENU          - used in menus
7 SELECT        - used for various builtin commands such as 
                  iconify
8 DESTROY       - used for DESTROY and DELETE built-ins
9 TOP           - used in the top side-bar of a window
10 RIGHT        - used in the right side-bar (not available) 
11 BOTTOM       - used in the bottom handle of a window
12 LEFT         - used in the left side-bar (not available)
13 TOP_LEFT     - used in the top left corner
14 TOP_RIGHT    - used in the top right corner
15 BOTTOM_LEFT  - used in the bottom left corner
16 BOTTOM_RIGHT - used in the bottom right corner
.fi

The cursor_type  argument  is a number which tells
the cursor shape to use. The available numbers  can
be  found in /usr/include/X11/cursorfont.h, and are
currently even numbers between 0 and  152.  At  the
current time, the following cursor types are available.

.nf
0   X_cursor              2   arrow
4   based_arrow_down      6   based_arrow_up
8   boat                  10  bogosity
12  bottom_left_corner    14  bottom_right_corner
16  bottom_side           18  bottom_tee
20  box_spiral            22  center_ptr
24  circle                26  clock
28  coffee_mug            30  cross
32  cross_reverse         34  crosshair
36  diamond_cross         38  dot
40  dotbox                42  double_arrow
44  draft_large           46  draft_small
48  draped_box            50  exchange
52  fleur                 54  gobbler
56  gumby                 58  hand1
60  hand2                 62  heart
64  icon                  66  iron_cross
68  left_ptr              70  left_side
72  left_tee              74  leftbutton
76  ll_angle              78  lr_angle
80  man                   82  middlebutton
84  mouse                 86  pencil
88  pirate                90  plus
92  question_arrow        94  right_ptr
96  right_side            98  right_tee
100 rightbutton           102 rtl_logo
104 sailboat              106 sb_down_arrow
108 sb_h_double_arrow     110 sb_left_arrow
112 sb_right_arrow        114 sb_up_arrow
116 sb_v_double_arrow     118 shuttle
120 sizing                122 spider
124 spraycan              126 star
128 target                130 tcross
132 top_left_arrow        134 top_left_corner
136 top_right_corner      138 top_side
140 top_tee               142 trek
144 ul_angle              146 umbrella
148 ur_angle              150 watch
152 xterm
.fi
.RE

AppsBackingStore
.RS
Causes   application  windows  to request  backing
store. Specifying this  option  causes  the  window
manager  to  fail to be ICCCM compliant. While this
option can speed things up in an X-terminal,  where
re-draws  of  windows is expensive, it may not help
much on regular workstations.
.RE

SaveUnders
.RS
Causes the
.I AfterStep
decoration frames to request  saveunders.  This will cause 
.I AfterStep
to save those portions of windows that are not visible to memory (not video memory).
This can significantly improve the performance
during opaque moves, but it causes a significant increase in memory usage.
This can also cause garbled display with some applications.
.RE

BackingStore
.RS
Causes
.I AfterStep
decorations to request backing store. See the discussion for AppsBackingStore.
.RE

Popup
.I PopupName
.RS
Starts the definition of a pop-up menu  which  will
later  be bound to a mouse button or key.
.I PopupName
must be  enclosed in  quotes.   Menu  entries  are
included  on lines following the Popup keyword. The
menu definition ends with the  key  word  EndPopup.
Menu  entries are specified as shown in the following example.
The first word on each  line  is  the
built-in function which will be performed, followed
by the caption (enclosed in quotes) which will  be
shown in the menu, followed by any additional arguments
needed by the  built-in  function.  Sub-menus
can  be  specified  by using the Popup built-in, as
long as the sub-menu was  defined earlier  in  the
configuration file.

.nf
Popup "Window Ops"
       Title   "Window Ops"
       Move    "Move"
       Resize  "Resize"
       Raise   "Raise"
       Lower   "Lower"
       Iconify "(De)Iconify"
       Nop     " "
       Destroy "Destroy"
       Title   "HARDCOPY"
       Exec    "Hardcopy"  exec xdpr &
       Exec    "Hardcopy RV"  exec xdpr -rv &
EndPopup
.fi

Note  that  if  a tab character is embedded in the
caption of a menu entry, then  the  text  following
the tab will be entered into a second column in the
menu, and the entire menu will  be  left-adjusted.
This  is  intended  for  shortcut labeling. The tab
character must really be a tab. If it  is expanded
into spaces it will not work! For example

.nf
Popup "Window Ops"
       Title   "Window Ops    Alt-F1"
.fi

Is  the  start of a left adjusted menu. Alt-F1 will
be placed toward the right side of the menu.
Shortcut keys may be specified in the menu  definition
by preceding the character with an ampersand.
The ampersand will not be displayed, but the  character
after it will be displayed at the right side of the same entry,
and if the user presses the corresponding key,  then  that
item  will  be activated as if the user had clicked
on it with the mouse.  Only alphabetic and  numeric
characters may be used as shortcut keys.  The shift
state of  the  keyboard  is  ignored  when  testing
shortcut characters. For example:-

.nf
Popup "Window Ops"
       Maximize "Ma&ximise" 100 100
EndMenu
.fi
 
When  this  menu is popped up, the entry will appear as "Maximize x",
and pressing the x key will cause  the  current
window to be maximized. Shortcut keys are not
operative unless  MENU_HOTKEYS  was  defined  when building
.I AfterStep.
If  WINDOWLIST_HOTKETS  was  also defined, then hot keys are automatically  added  to
the WindowList when it is displayed.
.RE

Function
.I FunctionName
.RS
Starts  the  definition of a complex function, composed of the
.I AfterStep
built-in  functions,  which  will later  be bound to a mouse button or key.
.I FunctionName
must be enclosed in quotes.  Function  entries
are  included  on lines following the Function keyword.
The definition ends with the  key  word  EndFunction.
Function  entries are specified as shown
in the following example. The first  word on  each
line  is  the  built-in function which will be per-
formed, followed the type of  event  which  should
trigger  the  action (enclosed in quotes), followed
by any additional arguments needed by the built-in
function. Menus can be specified by using the Popup
built-in, as long as the menu was defined  earlier
in the configuration file.

The  trigger actions which are recognized are Immediate,
Motion, Click, DoubleClick and TripleClick. Immediate
actions  are  executed  as  soon as the function is
activated, even if a window has not been  selected.
If  there are  actions  other than immediate ones,
.I AfterStep
will wait to see if the user is clicking, double-clicking,
triple-clicking or dragging the mouse. After the decision
is made
.I AfterStep
will execute  only  the builtins
from  the function definition whose trigger action
matches the action performed by the  user.  If  the
following example were bound to button 1 in a window
title-bar, then, when button 1 is pressed,
.I AfterStep
would  wait  150  msec  to  see  if  the  button is
released. If the button is not released,
.I AfterStep
will start  a move operation. When the move operation is
complete, a raise operation will be performed. If a
button  release  is  detected,  then
.I AfterStep
will wait another 150 msec for a second click.  If  only  one
click  is detected, then the window will be raised.
If two clicks are detected,  the  window  will  be
alternately  raised  and lowered. If three clicks are
detected the window will be Shaded or un-Shaded, depending
on the prior state of the window. The 150 msec wait
duration can be altered using the ClickTime option.

.nf
Function "Move-or-Raise"
       Move         "Motion"
       Raise        "Motion"
       Raise        "Click"
       RaiseLower   "DoubleClick"
       Shade        "TripleClick"
EndFunction
.fi

The  clicking, double-clicking and triple-clicking concepts do not
carry through to using keyboard shortcuts.

Two  special  functions  exist:  InitFunction   and
RestartFunction.  The  InitFunction  will be called
when
.I AfterStep
is started for the first time  in  any  X
session,  and  can  be  used  to start modules, set
background  patterns,  and  begin programs.   The
restart  function will  be  called  when
.I AfterStep
is restarted. It can be used to start modules and  set
background  patterns,  but  probably  should not be
used to start programs.
.RE
.SH BUILT IN FUNCTIONS
.I AfterStep
supports a small set of built in functions which  can
be bound to keyboard or mouse buttons.

Nop
.RS
Does  nothing.  This is used to insert a blank line
or separator in a menu. If the menu item specification
is Nop " ", then a blank line is inserted. If
it looks like Nop "",  then  nothing is inserted.
.RE

Title
.RS
Does  nothing.  This is used to insert a title line
in a popup or menu.
.RE

Beep
.RS
Makes the computer beep.
.RE

Quit
.RS
Exits
.I AfterStep,
generally causing X to exit too.
.RE

Restart \fIname WindowManagerName\fP
.RS
Causes
.I AfterStep
to re-read itself if
WindowManagerName = afterstep, or to switch to an alternate window manager
if WindowManagerName != afterstep.  If the  window  manager
is  not in your default search path, then you
should use the full path  name  for
.I WindowManagerName.

.I WindowManagerName
is  not  quoted,  but
.I name
is.
.I name
is the name that appears in a menu, if that is
where the function is called from.
.I name
is required even if the function is not called from a menu, for
ease of parsing.

This  command  should not have a trailing ampersand
or any command line arguments, and should not  make
use  of any environmental variables. Of the following
examples, the first three are sure losers,  but
the fourth is OK:

.nf
Key F1 R N Restart " " afterstep &
Key F1 R N Restart " " $(HOME)/bin/afterstep
Key F1 R N Restart " " twm -f .mystartupfile
Key F1 R N Restart " " /usr/local/bin/afterstep
.fi
.RE

Refresh
.RS
Causes  all  windows on the screen to re-draw themselves.
.RE

Move
.RS
Allows the user to move a window. If  called  from 
somewhere in a window or its border, then that window will be moved.
If called from the root  window,
then  the user will be allowed to select the target window
.RE

Resize
.RS
Allows the user to resize a window.
.RE

Raise
.RS
Allows the user to raise a window.
.RE

Lower
.RS
Allows the user to lower a window.
.RE

.IP RaiseLower
.RS
Alternately raises and lowers a window.
.RE

Shade
.RS
Emulates the MacOS WindowShade feature.  Once activated the window will
become a titlebar only.
.RE

Delete
.RS
Sends a message to a window asking that  it  remove itself, frequently causing the application to exit.
.RE

Destroy
.RS
Destroys a window. Guaranteed to  get  rid  of  the
window, but is a fairly violent way to terminate an
application.
.RE

Close
.RS
If the window accepts the delete window protocol, a
message  is  sent to the window asking it to grace-
fully remove itself. If the window does not  under-
stand  the  delete window protocol, then the window
is destroyed.
.RE

Iconify \fI[value]\fP
.RS
Iconifies a window if it is not already  iconified,
or  de-iconifies  it if it is already iconified. If
the optional argument value is positive,  the  only
iconification will be allowed, and de-iconification
will be inhibited. It the optional argument is negative, only de-iconification will be allowed.
.RE

Maximize \fI[horizontal vertical]\fP
.RS
Without its optional arguments, Maximize causes the
window to alternately  switch  from  a  full-screen
size to its normal size.

With  the optional arguments horizontal and vertical, which are expressed as percentage  of  a  full
screen,  the  user  can control the new size of the
window.  If  horizontal  > 0,  then  the  horizontal
dimension of  the  window  will be set to horizontal*screen_width/100. The vertical resizing is similar.
For example, the following will switch a window to the full vertical
size of the screen:
Maximize 0 100

The following causes windows to be stretched to the full width:
Maximize 100 0

This makes a window that is half the screen size in each direction:
Maximize 50 50

Values larger than 100 can be used with caution.
.RE

Stick
.RS
Makes  a window sticky if it is not already sticky, or non-sticky if it is already sticky.
.RE

Scroll \fIhorizontal vertical\fP
.RS
Scrolls the virtual desktop's viewport by
.I horizontal
pages in the x-direction, and
.I vertical
pages in the y-direction. Either or both entries may be negative.
Both
.I horizontal
and
.I vertical
values are expressed in percent of pages, so Scroll  100  100
means  to scroll  down  and left by one full page.
Scroll 50 25 means to scroll left half a  page  and
down  a  quarter  of  a  page.  The scroll function
should not be called from pop-up  menus.  Normally,
scrolling stops at the  edge of the desktop.

If the horizontal and vertical percentages are multiplied
by 1000, then scrolling will wrap around at
the  edge of  the desktop. If "Scroll 100000 0" is
executed over and over,
.I AfterStep
will move to the  next
desktop  page  on each  execution,  and   will wrap
around at the edge of the desktop,  so  that  every
page is hit in turn.
.RE

TogglePage
.RS
Temporarily disables edge scrolling.  Edge scrolling can be re-enabled by
calling this again.
.RE

CursorMove \fI horizontal vertical \fP
.RS
Moves the mouse pointer by
.I horizontal
pages in  the x-direction, and
.I vertical
pages in the y-direction.
Either or both entries may be negative. Both
.I horizontal
and
.I vertical
values are expressed in percent
of pages, so CursorMove 100 100 means to move  down
and  left by one full page. CursorMove 50 25 means
to move left half a page and down a  quarter  of  a
page.  The CursorMove function should not be called
from pop-up menus.
.RE

CirculateUp \fI[name window_name]\fP
.RS
Causes the pointer to move to the previous  window
in  the list of windows for which CirculateSkip has
not not been specified as CirculateSkip.

If the optional arguments are  supplied,  then  the
focus  will move to the first window whose name (or
icon  name  or  class)  matches
.I window_name.
The  optional  argument  name is required if
.I window_name
is supplied, and is enclosed in quotes. This  argument
is  the  name  which  appears in menus if the
function is called from a menu, but serves no  purpose if the function is not called from a menu

Here's  an  example that moves the focus to an xterm
window when Alt-F1 is pressed:

Key F1 A M CirculateUp "whatever" xterm
.RE

CirculateDown \fI[name window_name]\fP
.RS
Causes the pointer to move to the next  window  in
the list of windows for which CirculateSkip has not
not been specified as CirculateSkip.

If the optional arguments are  supplied,  then  the
focus  will move to the first window whose name (or
icon  name  or  class)  matches
.I window_name.
The optional  argument  name is required if
.I window_name
is supplied, and is enclosed in quotes. This  argument
is  the  name  which  appears in menus if the
function is called from a menu, but serves no  purpose if the function is not called from a menu
.RE

Warp \fI[name window_name]\fP
.RS
Same  as CirculateDown, but De-Iconifies any iconified windows as it focuses on them.
.RE

Wait \fIname\fP
.RS
This built-in is intended to be used in
.I AfterStep
functions  only.  It  causes execution of a function to
pause until a new window named
.I name
appears.
.I AfterStep
remains  fully  functional  during  a wait. This is
particularly useful in the InitFunction, if you are
trying to start windows on specific desktops:

.nf
Function "InitFunction"
       Exec "I"  exec xterm -geometry 80x64+0+0
       Wait "I"  xterm
       Desk "I"  0 2
       Exec "I"  exec xmh -font fixed -geometry 507x750+0+0 &
       Wait "I"  xmh
       Desk "I"  0 0
EndFunction
.fi

The  above  function starts an xterm on the current
desk, waits for it to map itself, then switches  to
desk  2,  and  starts  an xmh. After the xmh window
appears, control moves to desk 0.
.RE

Focus
.RS
Moves the viewport or window as needed to make  the selected  window  visible.  Sets the keyboard focus
to the  selected  window. Raises  the  window  if needed  to  make it visible. Warps the pointer into
the selected window  in  focus-follows-mouse  mode.
Does  not de-iconify.  This  function is primarily
handy  when  used  with a  module  such  as  the  WinList.
.RE

Desk
.I arg1 arg2
.RS
Changes to another desktop (workspace, room).

If  arg1  is non zero, then the next desktop number
will be the current desktop number plus arg1. Desktop
numbers, like arg1 can be negative.

If  arg1  is zero, then the new desktop number will be arg2.

The  number  of  active  desktops is   determined dynamically.
Only desktops which contain windows or are currently being displayed are active.  Desktop
numbers  must be between 2147483647 and -2147483648 (is that enough?).
.RE

WindowsDesk \fInew_desk\fP
.RS
Moves the selected window to the desktop specified as new_desk.
.RE

GotoPage \fIx y\fP
.RS
Moves the desktop viewport to page (x,y). The upper left page is (0,0),
the upper right is (N,0), where N is one less than the current number of horizontal
pages specified in  the  DeskTopSize  command.
The lower  left page is (0,M), and the lower right page
is (N,M), where M is the desktop's vertical size as
specified in the DeskTopSize command. The GotoPage
function should not be used in a pop-up menu.
.RE

WindowList \fIarg1 arg2\fP
.RS
Generates a pop-up menu (and pops it up)  in  which
the  title and geometry of each of the windows currently
on the desk top are shown. The  geometry  of
iconified windows  is shown in brackets. Selecting
an item from the window list pop-up menu will cause
that  window  to be moved onto the desktop if it is
currently not on it, will move the desktop viewport
to  the  page containing the upper left hand corner
of the window, will de-iconify the window if it  is
iconified, and will raise the window.

If arg1 is an even number, then the windows will be
listed using the window name (the name  that  shows
up  in  the title-bar). If it is odd, then the window's
icon name is used.

If arg1 is less than 2, then  all windows  on  all
desktops  (except those   listed  in WindowListSkip
directives), will be show.

If arg1 is 2 or 3, then only windows on the current
desktop will be shown.

If  arg1  is  4  or 5, then only windows on desktop
number arg2 will be shown.
.RE

Exec \fIname command\fP
.RS
Executes
.I command.
.I command
is not quoted,  but
.I name
is.
.I name
is the name that appears in a menu, if
that is where the function is called from.
.I name
is required  even if the function is not called from a
menu, for ease of parsing.

The following example binds function key F1 in  the
root  window,  with no modifiers, to the exec function.
The program
.BR rxvt (1)
will  be  started, with  an assortment of options.

Key F1 R N Exec "rxvt" exec rxvt -fg yellow -bg blue -e /bin/tcsh &
.RE

Popup
.RS
NOTE: This built-in takes a slightly different form
when used to bind a sub-menu into a  menu than  it
does  when  binding the main menu to a key or mouse
button. The form described here is  for  binding  a
main menu to a key or mouse button.
Used  to bind a previously defined pop-up menu to a
key or mouse button.

The following example binds mouse buttons 2  and  3
to  a  pop-up called "Window Ops", whose definition
was provided as an  example  earlier  in  this  man
page.   The  menu will pop-up if the buttons 2 or 3
are pressed  in  the  window  frame,  side-bar,  or
title-bar,  with  no modifiers (none of shift, control, or meta).

.nf
Mouse 2   FST  N    Popup "Window Ops"
Mouse 3   FST  N    Popup "Window Ops"
.fi

Pop-ups can be bound to keys through the use of the
key modifier. Pop-ups can be operated without using
the mouse by binding to keys, and operating via the
up arrow, down arrow, and enter keys.

The following example defines a  sub  menu,
"Quit-Verify"  and  binds  it  into  a  main menu, called "Utilities".

.nf
Popup "Quit-Verify"
       Title   "Really Quit AfterStep?"
       Quit    "Yes, Really Quit"
       Restart "Restart AfterStep" afterstep
       Nop     "No, Don't Quit"
EndPopup

Popup "Utilities"
       Title   "Utilities"
       Exec    "Xterm"      exec xterm &
       Exec    "Rxvt"       exec rxvt &
       Exec    "Top"        exec rxvt -T Top -n Top -e top &
       Exec    "Calculator" exec xcalc &
       Exec    "Xman"       exec xman &
       Exec    "Xmag"       exec xmag &
       Popup   "Exit AfterStep"     Quit-Verify
EndPopup
.fi

Sub-menus must be defined prior to the main menu in
which  they  are  bound.  Sub-menu  nesting can be
arbitrarily deep.
.RE

Function
.RS
Used to bind a previously defined function to a key
or mouse button.

The  following  example  binds  mouse button 1 to a
function called "Move-or-Raise",  whose  definition
was  provided  as an  example  earlier in this man
page. After performing this binding,
.I AfterStep
will execute to move-or-raise function whenever button 1 is
pressed in a window title-bar.

Mouse 1    T      A       Function "Move-or-Raise"
.RE

Module
.I ModuleName
.RS
Specifies a module which should be spawned. At  the
current  time,  the only included modules are
.I Wharf
and
.I Pager.
Wharf will normally  be  spawned  during
initialization  instead  of  in response to a mouse
binding or menu action. Modules can be short  lived
transient programs,  or,  like  Wharf,  can be
intended to remain for the duration of the  X  session.  Module  will  be  terminated  by the
window manager prior to restarts and quits, if possible.
.RE
.SH KEYBOARD SHORTCUTS
All window-manager operations can  be  performed
from  the  keyboard, so mouse-less operation should not be
difficult. In addition to  scrolling  around  the  virtual
desktop  by  binding  the  Scroll  built-in to appropriate
keys, Pop-ups, move, resize and most other  built-ins  can
be bound to keys. Once a built-in function is started, the
pointer is moved by using the up, down,  left,  and  right
arrows,  and  the action is terminated by pressing return.
Holding down the shift key will cause the pointer movement
to  go  in  larger steps, and holding down the control key
will cause the cursor movement to go in smaller steps.
Standard emacs and vi cursor movement
controls (^n, ^p, ^f, ^b, and ^j, ^k, ^h, ^l) can be  used
instead of the arrow keys.
.SH SUPPLIED CONFIGURATION
A  sample  configuration file, sample.steprc was supplied
with the
.I AfterStep
distribution. It is not anylonger because of the new
configuration format, which include many well commented files
and can be used as a source of examples for
.I AfterStep
configuration.
.SH USE ON MULTI-SCREEN DISPLAYS
.I AfterStep
does work on multi-screen displays.
If the -s command line argument is not given to
.I AfterStep
, it will automatically start up on every screen on the specified display.
After
.I AfterStep
starts, each  screen  is  treated independently. Re-starts of
.I AfterStep need to be performed separately on each screen.
The  use of  EdgeScroll  0  0  is
strongly recommended for multi-screen displays.

You  may need  to  quit on each screen to quit from the X
session completely.

Multi-screen support is only available if you compile with -DMULTIPLE_SCREENS

.SH SEE ALSO
.BR Wharf (1),  Animate (1), Audio (1),  Auto (1), asclock (1), Banner (1), Pager (1)
.SH AUTHORS
Frank Fejes (frank@canweb.net)

Alfredo Kenji Kojima (kojima@inf.ufrgs.br)

Dan Weeks (dan@mango.sfasu.edu)

Guylhem Aznar (guylhem@oeil.qc.ca)

Chris Ridd (C.Ridd@isode.com)

Rob Malda (malda@imagegroup.com)
.E
