dnl
define(AC_CONFIGURE_PART,[dnl
AC_MSG_RESULT()
AC_MSG_RESULT(__ $1 __)
])dnl
dnl
define(AC_CHECK_PERL_INTERPRETER,[dnl
AC_MSG_CHECKING([for Perl language])
AC_ARG_WITH(perl,dnl
[  --with-perl=PATH        force the usage of a specific Perl 5 interpreter],
perlprog=$with_perl
perlvers=`$perlprog -v | grep version | sed -e 's/.* version //' -e 's/ built.*//' -e 's/ with.*//'`
,
TMPFILE=/tmp/ac.$$
rm -f $TMPFILE
touch $TMPFILE
c=0
for dir in `echo $PATH | sed -e 's/:/ /g'` /tmp; do
    for perl in perl5 perl miniperl; do
         if test -f "$dir/$perl"; then
             if test -x "$dir/$perl"; then
                 perl="$dir/$perl"
                 version=`$perl -v | grep version | sed -e 's/.* version //' -e 's/ built.*//' -e 's/ with.*//'`
                 versionnum="`echo $version | sed -e 's/\.//g' -e 's/_//g'`"
                 versionnum=`expr $versionnum - $c`
                 echo "$versionnum $version $perl" >>$TMPFILE
             fi
         fi
    done
    c=`expr $c + 1`
done
perlvers="`cat $TMPFILE | sort -u | tail -1 | cut '-d ' -f2`"
perlprog="`cat $TMPFILE | sort -u | tail -1 | cut '-d ' -f3`"
rm -f $TMPFILE
)dnl
PATH_PERL=$perlprog
AC_MSG_RESULT([$perlprog v$perlvers])
AC_SUBST(PATH_PERL)
AC_SUBST(perlprog)
AC_SUBST(perlvers)
])dnl
dnl
define(AC_CHECK_PERL_MODULE,[dnl
AC_MSG_CHECKING([for Perl module $1 ($2)])
TMPFILE=/tmp/ac.$$
rm -f $TMPFILE
cat >$TMPFILE <<'EOT'
eval {
    require $1;
    if ('$2' ne 'ANY') {
        $1->require_version('$2');
    }
};
if ([$]@) {
    print "failed";
} else {
    print "ok";
}
EOT
rc=`$path_perl $TMPFILE`; 
rm -f $TMPFILE
if test ".$rc" = .ok; then
    have_$3=1
    AC_MSG_RESULT([found])
else
    have_$3=0
    AC_MSG_RESULT([not found])
fi
AC_SUBST(have_$3)
])dnl
define(AC_BUILT_PARAMS,[dnl

AC_CANONICAL_HOST
built_system=$host
AC_SUBST(built_system)

AC_MSG_CHECKING(for built user)

username="$LOGNAME"
if test ".$username" = .; then
    username="$USER"
    if test ".$username" = .; then
        username="`whoami 2>/dev/null | sed -e 's/\n$//'`"
        if test ".$username" = .; then
            username="`who am i 2>/dev/null | cut '-d ' -f1`"
            if test ".$username" = .; then
                username="unknown"
            fi
        fi
    fi
fi
hostname="`uname -n | sed -e 's/\n$//'`"
if test ".$hostname" = .; then
    hostname="`hostname | sed -e 's/\n$//'`"
    if test ".$hostname" = .; then
        hostname="unknown"
    fi
fi
hostname="`echo $hostname | sed -e 's/\..*//'`"
if test -f /etc/resolv.conf; then
    domainname="`grep domain /etc/resolv.conf | sed -e 's/.*domain//' -e 's/^[[ 	]]*//' -e 's/^ *//' -e 's/^	*//' -e 's/^\.//' -e 's/^/./'`"
    if test ".$domainname" = .; then
        domainname="`grep search /etc/resolv.conf | sed -e 's/.*search//' -e 's/^[[ 	]]*//' -e 's/^ *//' -e 's/^	*//' -e 's/ .*//' -e 's/^\.//' -e 's/^/./'`"
    fi
else
    domainname="";
fi
built_user="$username@$hostname$domainname"
AC_SUBST(built_user)
AC_MSG_RESULT($built_user)

AC_MSG_CHECKING(for built date)
built_date="`date '+%d-%b-%Y' 2>/dev/null | sed -e 's/\n$//'`"
dnl # SunOS has no %b/%Y... ARGL!
if test ".$built_date" = .; then
    built_date="`date '+%d-%m-19%y' | sed -e 's/\n$//'`"
fi
AC_MSG_RESULT($built_date)
AC_SUBST(built_date)

])dnl
dnl
