/*
 * File:     main1.C (no user interface)
 *
 * Author:   Michael Hofer (until May 92) and Michael Pichler
 *
 * Created:  01 Apr 92
 *
 * Changed:  25 May 94
 *
 */


#include "memleak.h"

#include "scene3d.h"
#include "polyhed.h"
#include "camera.h"
#include "light.h"

#include <ge3d/ge3d.h>

#include <stdio.h>
#include <iostream.h>


void showtext (const char* file)
{
  cerr << "showtext (" << file << ")." << endl;
}


void showimage (const char* file)
{
  cerr << "showimage (" << file << ")." << endl;
}

int verbose = 0;

// note: swapbuffers () must be called explicitly

/*
void demoanim (Scene3D& scene)
{
  point3D pos, look;
  scene.getCameraPositon (pos);
  scene.getCameraLookat (look);

//cerr << "pos : " << pos.x << ", " << pos.y << ", " << pos.z << endl;
//cerr << "look: " << look.x << ", " << look.y << ", " << look.z << endl;

  look.x = look.y = look.z = 0;
  vector3D pos_look;
  sub3D (pos, look, pos_look);
  float r = sqrt (dot3D (pos_look, pos_look));

  for (int i = 0, phi = 5;  i < 57;  i++, phi += 9)
  { 
    // pos.z += 1;  // zoom out
    r *= 1.03;
    pos_look.x = r * cos (phi * M_PI / 180);
    pos_look.z = r * sin (phi * M_PI / 180);
    pos_look.y = r * sin (phi * M_PI / 720);
    add3D (pos_look, look, pos);
    scene.setCameraParams (pos, look);
    scene.draw ();
    ge3d_swapbuffers ();
  }
  for (i = 0; i < 25; i++)
  { scl3D (pos_look, 0.91);  
    add3D (pos_look, look, pos);
    scene.setCameraParams (pos, look);
    scene.draw ();
    ge3d_swapbuffers ();
 }
//cerr << "pos : " << pos.x << ", " << pos.y << ", " << pos.z << endl;
//cerr << "look: " << look.x << ", " << look.y << ", " << look.z << endl;

} // demoanim
*/


static void demorotate (Scene3D& scene)
{
  Camera* cam = scene.getCamera ();

  if (!cam)
    return;

  point3D center;
  init3D (center, 0, 0, 0);

  for (;;)
  {
    cam->rotate (-0.1, 0.0, center);
    scene.draw ();
    ge3d_swapbuffers ();
  }

} // demorotate



static void demopick (Scene3D& scene)
{

  // change perspective of VW
  point3D pos, look;

  pos.x = -10.7884;
  pos.y = 2.2421;
  pos.z = 14.1917;
  look.x = -4.4169;
  look.y = 2.2421;
  look.z = 6.48439;
  scene.setCameraParams (pos, look);

  scene.draw ();
  ge3d_swapbuffers ();

  cerr << endl;

/*
  for (float fy = 0.975; fy > 0; fy -= 0.05)  // 0.025, 0.075, ..., 0.975
  { for (float fx = 0.025; fx < 1; fx += 0.05)
      cerr << scene.pickObject (fx, fy) << "    ";
    cerr << endl;
  }
*/

  // short demo: 0.25, 0.5, 0.75
  for (float fy = 0.75; fy > 0.1; fy -= 0.25)
  { for (float fx = 0.25; fx < 0.9; fx += 0.25)
      cerr << scene.pickObject (fx, fy) << "    ";
    cerr << endl;
  }

} // demopick



void waitkey ()
{
//  char c;

  cerr << " press return. ";
//  scanf ("%c", &c);      // reading from stdin crashes under GL !!!
//  cin >> c;
  
  cerr << endl;
} // waitkey



int main ()
{
#ifdef MEMLEAK
  MemLeakBegin ();
#endif

  Scene3D* scene = New Scene3D;

  ge3d_openwindow ();
  ge3d_setbackgcolor (0.75, 0.75, 0.75);

  scene->readScene ("../data/cube/cube");
  demorotate (*scene);

//  scene->readScene ("../data/bar/bar");

//  scene->readScene ("../data/car/car");

//  cout << "Smooth shading." << endl;

/*
  scene->draw () // (ge3d_wireframe);  // smooth shading
  ge3d_swapbuffers ();

  point3D pos, look;
  scene->getCameraPosition (pos);
  scene->getCameraLookat (look);

  cerr << "position: " << pos.x << ", " << pos.y << ", " << pos.z << endl;
  cerr << "lookat  : " << look.x << ", " << look.y << ", " << look.z << endl;


  cerr << "Picking!" << endl;

  demopick (*scene);
*/
  Delete scene;

#ifdef MEMLEAK
  MemLeakEnd ();
#endif

  ge3d_close ();  // waits "forever"

/*
  waitkey ();
  cout << "Wireframe.     " << endl;
  scene.draw (ge3d_wireframe);
  ge3d_swapbuffers ();
  waitkey ();
  cout << "Hidden line.   " << endl;
  scene.draw (ge3d_hidden_line);
  ge3d_swapbuffers ();
  waitkey ();
  cout << "Flat shading.  " << endl;
  scene.draw (ge3d_flat_shading);
  ge3d_swapbuffers ();
  waitkey ();

  cerr << "Animation.";
  demoanim (scene);
  waitkey ();

  cerr << "Picking.  ";
  demopick (scene);
*/

}  // main
