// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1996,97
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        editdlg.h
//
// Purpose:     interface to scene (editing) dialogs
//
// Created:     15 Oct 96   Alexander Nussbaumer
//
// Changed:     21 Feb 97   Alexander Nussbaumer
//
// Changed:     21 Feb 97   Michael Pichler
//
// $Id: editdlg.h,v 1.4 1997/03/25 15:36:28 anuss Exp $
//
//</file>



#ifndef harmony_scene_dialogs_h
#define harmony_scene_dialogs_h

#include <ge3d/vectors.h>

// #include "vrmlscene.h"
#include <InterViews/window.h>

#include <hyperg/utils/str.h>

class SceneWindow;
class VRMLScene;
class SceneMenus;

class ApplikationWindow;
class Button;
class Image;
class WidgetKit;
class LayoutKit;
class Patch;
class FieldSlider;
class WFileBrowser;
class WFileChooser;
class FieldBrowser;
class FieldEditor31;
class ColourDialog;

class AdjValue;
class RString;

class FileTable
{
  public:
    FileTable ();
    ~FileTable ();

    int load (const RString& path);
    int size ()
    { return listsize_; }

    int getObjectName (int index, RString& name);
    int getFileName (int index, RString& name);

    void getPath (RString& name)
    { name = path_; }

  private:
    void clearTable ();

    enum { tablesize_ = 128 };
    int listsize_;

    RString* objectname_[tablesize_];
    RString* filename_[tablesize_];

    RString path_;

}; // FileTable


class InsertObjectDialog
{
  public:
    InsertObjectDialog (WidgetKit* kit, const LayoutKit* layout, SceneWindow* scene, SceneMenus* themenus);
    ~InsertObjectDialog ();

    void toggleWindow ();
    void unmapWindow ();
    int isMapped ()
    { return (win_ && win_->is_mapped ()); }

  private:
    void buildWindow ();
    void initSetBrowser ();
    void loadSet ();
    void insertObject ();
    void fileChooser ();
    void selectObject ();
    void makeWWWInline ();
    void accept (FieldEditor31*, char)  // aguments for FieldActionCallback31
    { makeWWWInline (); }

    ApplicationWindow* win_;
    SceneWindow* scene_;
    VRMLScene* vrmlscene_;
    SceneMenus* themenus_;
    WidgetKit* kit_;
    const LayoutKit* layout_;

    WFileBrowser* objectbrowser_;
    WFileBrowser* setbrowser_;
    FileTable filetable_;
    RString* setname_;
    RString* setpath_;
    Patch* titlepatch_;
    enum { primitivenumber_ = 4 };
    int primitive_[primitivenumber_];
    int vrmlprimitive_;
    
    FieldEditor31* urleditor_;
    FieldBrowser* fieldbrowser_;
    WFileChooser* filechooser_;

}; // InsertObjectDialog


class WWWAnchorDialog
{
  public:
    WWWAnchorDialog (
      WidgetKit* kit, const LayoutKit* layout, SceneWindow* scene, SceneMenus* themenus
    );
    ~WWWAnchorDialog ();

    void toggleWindow ();
    void unmapWindow ();
    void update (const char* url, const char* description);
    int isMapped ()
    { return (win_ && win_->is_mapped ()); }

  private:
    void buildWindow ();

    void reset ();
    void applyWWWAnchor ();
    void deleteWWWAnchor ();
    void accept (FieldEditor31*, char)  // aguments for FieldActionCallback31
    { applyWWWAnchor (); }

    ApplicationWindow* win_;
    SceneWindow* scene_;
    VRMLScene* vrmlscene_;
    SceneMenus* themenus_;
    WidgetKit* kit_;
    const LayoutKit* layout_;

    FieldEditor31* urleditor_;
    FieldEditor31* descriptioneditor_;
    RString org_url_;
    RString org_description_;

}; // WWWAnchorDialog



class TextureDialog
{
  public:
    TextureDialog (
      WidgetKit* kit, const LayoutKit* layout, SceneWindow* scene, SceneMenus* themenus
    );
    ~TextureDialog ();

    void toggleWindow ();
    void unmapWindow ();
    void update (const char* path, int wraph, int wrapv, 
                 float transx, float transy, float rot, float scalex, float scaley);
    void clear ();
    int isMapped ()
    { return (win_ && win_->is_mapped ()); }

  private:
    enum { num_sliders = 5 };

    void buildWindow ();
    void accept (FieldEditor31*, char);  // aguments for FieldActionCallback31
    void reset ();         // reset to original values
    void resetTexture ();  // reset button
    void selectItem ();
    void applyTexture ();
    void reloadFiletable ();
    void fileChooser ();
    Image* getImage (const char* path);

    WFileBrowser* browser_;
    ApplicationWindow* win_;
    SceneWindow* scene_;
    VRMLScene* vrmlscene_;
    SceneMenus* themenus_;
    WidgetKit* kit_;
    const LayoutKit* layout_;
    Patch* patch_;
    Button* applybutton_;

    FileTable filetable_;

    int org_wraph_, org_wrapv_;
    Button* wraph_button_;
    Button* wrapv_button_;
    float org_values[5];
    FieldSlider* slider_[num_sliders];
    WFileChooser* filechooser_;
    RString org_url_;
    FieldEditor31* urleditor_;

}; // TextureDialog


class MaterialDialog
{
  public:
    MaterialDialog (SceneWindow* scene, SceneMenus* themenus);
    ~MaterialDialog ();

    void update (float* ambientColor, float* diffuseColor, float* specularColor, float* emissiveColor, 
                 float* /*shininess*/, float* /*transparency*/);
    void unmapWindow ();
    void toggleWindow ();
    int isMapped ();
    void closedColourDialog (ColourDialog* /*coldlg*/);

  private:
    void buildWindow ();
    void applyMaterial (ColourDialog* /*coldlg = 0*/);

    SceneWindow* scene_;
    VRMLScene* vrmlscene_;
    SceneMenus* themenus_;

    ColourDialog* colourdialog_;

}; // MaterialDialog


class StructureViewerDialog
{
  public:
    StructureViewerDialog (
      WidgetKit* kit, const LayoutKit* layout, SceneWindow* scene, SceneMenus* themenus
    );
    ~StructureViewerDialog ();
    void toggleWindow ();
    void unmapWindow ();
    int isMapped ()
    { return (win_ && win_->is_mapped ()); }

    void clear ();
    void append (const char* node, const char* name, int level, int selection);
    void selectItem (int item = -1);
    void setPasteName (RString& name);
    void setNodeNameField (RString& name);
    void storeAdjustable ();
    void useStoredAjustable ();

  private:
    void buildWindow ();
    void buildBrowser ();
    void selectNode ();
    void applyName (FieldEditor31*, char);

    void viewSelectedNode ();
    void deleteSelectedNode ();
    void cutSelectedNode ();
    void copySelectedNode ();
    void pasteSelectedNode ();
    void selectParent ();
    void selectChild ();
    void selectNext ();
    void selectPrevious ();
    void removeSelection ();

    WFileBrowser* browser_;
    ApplicationWindow* win_;
    SceneWindow* scene_;
    VRMLScene* vrmlscene_;
    SceneMenus* themenus_;
    WidgetKit* kit_;
    const LayoutKit* layout_;

    int listsize_;
    FieldEditor31* nodename_;
    FieldBrowser* pastename_;
    
    float upper_;  // adjustable position

}; // StructureViewerDialog


class GridDialog
{
  public:
    GridDialog (WidgetKit* kit, const LayoutKit* layout, SceneWindow* scene, SceneMenus* themenus);
    ~GridDialog ();
    void toggleWindow ();
    void unmapWindow ();
    int isMapped ()
    { return (win_ && win_->is_mapped ()); }

    void update ();

  private:
    void buildWindow ();
    void resetValues ();
    void changeBoundaries (float* lower, float* upper);

    void setGrid ();
    void xaxis ()  { setGrid (); }
    void yaxis ()  { setGrid (); }
    void zaxis ()  { setGrid (); }
    void setToRelativeMetric ();
    void setToAbsoluteMetric ();

    void applyValues ()
    { setGrid (); }

    Button* checkbox_[3];
    FieldSlider* slider_[5];
    AdjValue* adjvalue_[5];  // 3 for positionfield, 1 for distance, 1 for extent
    int absolutemetric_;
    vector3D min_, max_;

    ApplicationWindow* win_;
    SceneWindow* scene_;
    VRMLScene* vrmlscene_;
    SceneMenus* themenus_;
    WidgetKit* kit_;
    const LayoutKit* layout_;

}; // GridDialog


class TransformDialog
{
  public:
    TransformDialog (
      WidgetKit* kit, const LayoutKit* layout, SceneWindow* scene, SceneMenus* themenus
    );
    ~TransformDialog ();

    void toggleWindow ();
    void unmapWindow ();

    void updateTranslation (const vector3D& translate);
    void updateRotation (const vector3D& rotate, float angle);
    void updateScaling (const vector3D& scale);
    void clear ();
    void clearRotation ();

    enum { model, world };
    int coordinateSystem ()
    { return coordinatesystem_; }
    int isMapped ()
    { return (win_ && win_->is_mapped ()); }

  private:
    void buildWindow ();
    void resetValues ();

    void applyValues ();
    void accept (FieldEditor31*, char)
    { applyValues (); }

    void toggleCoordSystem ();

    FieldEditor31* translate_[3];
    FieldEditor31* rotate_[3];
    FieldEditor31* angle_;
    FieldEditor31* scale_[3];

    int coordinatesystem_;

    ApplicationWindow* win_;
    SceneWindow* scene_;
    VRMLScene* vrmlscene_;
    SceneMenus* themenus_;
    WidgetKit* kit_;
    const LayoutKit* layout_;

}; // TransformDialog


class ViewpointDialog
{
  public:
    ViewpointDialog (
      WidgetKit* kit, const LayoutKit* layout, SceneWindow* scene, SceneMenus* themenus
    );
    ~ViewpointDialog ();

    void toggleWindow ();
    void unmapWindow ();

    void clear ();
    void append (const char* number, const char* name);
    void select (int item = -1);
    void clearValues ();
    void updateValues (
      const char* name, const float* pos, const float* axis, float angle, float viewangle, const char*  camtype
    );
    int isMapped ()
    { return (win_ && win_->is_mapped ()); }

  private:
    void buildWindow ();
    void selectItem ();
    void acceptItem ();
    void applyViewpoint ();
    void accept (FieldEditor31*, char)
    { applyViewpoint (); }
    void setViewpoint ();
    void resetValues ();

    void addVP ();
    void deleteVP ();

    WFileBrowser* browser_;
    ApplicationWindow* win_;
    SceneWindow* scene_;
    VRMLScene* vrmlscene_;
    SceneMenus* themenus_;
    WidgetKit* kit_;
    const LayoutKit* layout_;

    int listsize_;
    FieldEditor31* position_[3];
    FieldEditor31* orientation_[3];
    FieldEditor31* angle_;
    FieldEditor31* name_;
    FieldEditor31* viewangle_;
    FieldBrowser* camertype_;

}; // ViewpointDialog



#endif
