/* -*-Mode: C;-*-
 * XDELTA - RCS replacement and delta generator
 * Copyright (C) 1997  Josh MacDonald
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: map.c 1.7 Sun, 12 Oct 1997 20:29:34 -0700 jmacd $
 */

#include "xdelta.h"

#ifndef _WIN32
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/mman.h>
#endif

#ifdef BUFSIZE
#undef BUFSIZE
#endif

#define BUFSIZE (1<<13)

MappedFile*
map_file (const gchar *filename)
{
  MappedFile *map;
#ifdef _WIN32
  FILE* it = fopen (filename, FOPEN_READ_ARG);
  int n_read = 0, t_read = 0;
  char* n_seg = g_new (char, BUFSIZ);
  int n_seg_len = BUFSIZ;

  if (!it)
    return NULL;

  for (;;)
    {
      /* Windows seems to adjust some read buffer size at
       * the first read so that if you ask for a larger amount
       * later you don't get it.  now by my reading of a UNIX
       * man page, that's wrong.  As a result, I read a fixed
       * size even though I've expanded the buffer to be much
       * larger. */
      n_read = fread (n_seg + t_read, 1, BUFSIZ, it);

      if (n_read < 0)
	return NULL;

      t_read += n_read;

      if (n_read < BUFSIZ)
	break;

      if (t_read == n_seg_len)
	{
	  n_seg_len *= 2;
	  n_seg = g_realloc (n_seg, n_seg_len);
	}
    }

  map = g_new (MappedFile, 1);

  map->seg = n_seg;
  map->len = t_read;

  return map;
#else
  struct stat sbuf;
  int fd;

  if (stat (filename, &sbuf))
    {
      perror ("stat");
      return FALSE;
    }

  if ((fd = open (filename, O_RDONLY)) < 0)
    {
      perror ("open");
      return FALSE;
    }

  map = g_new (MappedFile, 1);

  map->len = sbuf.st_size;
  map->seg = mmap (0, sbuf.st_size, PROT_READ, MAP_PRIVATE, fd, 0);

  if (!map->seg)
    {
      g_free (map);
      return NULL;
    }

  return map;
#endif
}
