#include "libpdftex.h"

integer t1_length1, t1_length2, t1_length3;

static char *standard_glyph_names[MAX_CHAR_NUM] = {
notdef, notdef, notdef, notdef, notdef, notdef, notdef, notdef, notdef,
notdef, notdef, notdef, notdef, notdef, notdef, notdef, notdef, notdef,
notdef, notdef, notdef, notdef, notdef, notdef, notdef, notdef, notdef,
notdef, notdef, notdef, notdef, notdef, "space", "exclam", "quotedbl",
"numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft",
"parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash",
"zero", "one", "two", "three", "four", "five", "six", "seven", "eight",
"nine", "colon", "semicolon", "less", "equal", "greater", "question", "at",
"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O",
"P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft",
"backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a",
"b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p",
"q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar",
"braceright", "asciitilde", notdef, notdef, notdef, notdef, notdef, notdef,
notdef, notdef, notdef, notdef, notdef, notdef, notdef, notdef, notdef,
notdef, notdef, notdef, notdef, notdef, notdef, notdef, notdef, notdef,
notdef, notdef, notdef, notdef, notdef, notdef, notdef, notdef, notdef,
notdef, "exclamdown", "cent", "sterling", "fraction", "yen", "florin",
"section", "currency", "quotesingle", "quotedblleft", "guillemotleft",
"guilsinglleft", "guilsinglright", "fi", "fl", notdef, "endash", "dagger",
"daggerdbl", "periodcentered", notdef, "paragraph", "bullet",
"quotesinglbase", "quotedblbase", "quotedblright", "guillemotright",
"ellipsis", "perthousand", notdef, "questiondown", notdef, "grave", "acute",
"circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", notdef,
"ring", "cedilla", notdef, "hungarumlaut", "ogonek", "caron", "emdash",
notdef, notdef, notdef, notdef, notdef, notdef, notdef, notdef, notdef,
notdef, notdef, notdef, notdef, notdef, notdef, notdef, "AE", notdef,
"ordfeminine", notdef, notdef, notdef, notdef, "Lslash", "Oslash", "OE",
"ordmasculine", notdef, notdef, notdef, notdef, notdef, "ae", notdef, notdef,
notdef, "dotlessi", notdef, notdef, "lslash", "oslash", "oe", "germandbls",
notdef, notdef, notdef, notdef
};

#define T1_BUF_SIZE   1024

#define ENC_BUITIN    0
#define ENC_STANDARD  1

typedef unsigned char byte;

typedef struct {
    char *name;
    byte *data;
    unsigned short len;
    boolean used;
} cs_entry;

static cs_entry *cs_tab, *cs_ptr;
static unsigned short t1_dr, t1_er;
static unsigned short t1_c1 = 52845, t1_c2 = 22719;
static unsigned short t1_cslen, t1_lenIV;
static char t1_line[T1_BUF_SIZE], *t1_line_ptr, *cs_start;
static boolean t1_in_eexec, t1_ispfa, t1_charstring;
static FILE *t1_file;


#define T1_OPEN()       typeonebopenin(t1_file)
#define T1_CLOSE()      xfclose(t1_file, filename)
#define T1_GETCHAR()    xgetc(t1_file)
#define T1_EOF()        feof(t1_file)
#define T1_PREFIX(s)    (!strncmp(t1_line, s, strlen(s)))
#define T1_PUTCHAR(c)   pdfout(c)

#define T1_CHECK_EOF()                                     \
    if (T1_EOF())                                          \
        FAIL("unexpected end of file");

#define T1_PRINTF(S) do {                                  \
    sprintf(t1_line, S);                                   \
    t1_line_ptr = strchr(t1_line, 0);                      \
    t1_putline();                                          \
} while (0)

static int hexval(int c)
{
    if (c >= 'A' && c <= 'F')
        return c - 'A' + 10;
    else if (c >= 'a' && c <= 'f')
        return c - 'a' + 10;
    else if (c >= '0' && c <= '9')
        return c - '0';
    else
        return 0;
}

static byte edecrypt(byte cipher)
{
    byte plain;
    if (t1_ispfa) {
        while (cipher == 10 || cipher == 13)
            cipher = T1_GETCHAR();
        cipher = (hexval(cipher) >> 4) + hexval(T1_GETCHAR());
    }
    plain = (cipher^(t1_dr >> 8));
    t1_dr = (cipher + t1_dr)*t1_c1 + t1_c2;
    return plain;
}

static byte cdecrypt(byte cipher, unsigned short *cr)
{
    byte plain = (cipher^(*cr >> 8));
    *cr = (cipher + *cr)*t1_c1 + t1_c2;
    return plain;
}

static byte eencrypt(byte plain)
{
    byte cipher = (plain^(t1_er >> 8));
    t1_er = (cipher + t1_er)*t1_c1 + t1_c2;
    return cipher;
}

static void t1_marker(int c, int m) 
{
    int i;
    while (c == 10 || c == 13) {
        c = T1_GETCHAR();
        T1_CHECK_EOF();
    }
    if (c != 128)
        FAIL("invalid marker");
    if (T1_GETCHAR() != m)
        FAIL("invalid block type");
    for (i = 0; i < 4; i++) {
        T1_GETCHAR();
        T1_CHECK_EOF();
    }
} 

static boolean t1_suffix(char *s) 
{
    char *s1 = t1_line_ptr - 1, 
         *s2 = strchr(s, 0) - 1;
    if (*s1 == 10)
        s1--;
    while (s1 >= t1_line && s2 >= s) {
        if (*s1-- != *s2--)
            return false;
    }
    return s1 >= t1_line - 1;
}

static void t1_getline() 
{
    int c, l;
    char *p;
restart:
    t1_line_ptr = t1_line;
    t1_cslen = 0;
    c = T1_GETCHAR();
    while (!T1_EOF()) {
        if (t1_in_eexec) 
            c = edecrypt(c);
        APPEND_CHAR_TO_BUF(c, t1_line_ptr, t1_line, T1_BUF_SIZE);
        if (c == 10)
            break;
        if (t1_charstring && !t1_cslen && 
            (t1_line_ptr - t1_line > 4) && 
            (t1_suffix(" RD ") || t1_suffix(" -| ")))
        {
            p = t1_line_ptr - 5;
            while (*p !=  ' ')
                p--;
            t1_cslen = l = atoi(p + 1);
            cs_start = t1_line_ptr;
            CHECK_BUF(t1_line_ptr - t1_line + l, T1_BUF_SIZE);
            while (l-- > 0) {
                *t1_line_ptr++ = edecrypt(T1_GETCHAR());
                T1_CHECK_EOF();
            }
        }
        c = T1_GETCHAR();
    }
    APPEND_EOL(t1_line_ptr, t1_line, T1_BUF_SIZE);
    if (t1_line_ptr - t1_line <= 1)
        goto restart;
}

void t1_putline() 
{
    char *p = t1_line;
    if (t1_line_ptr - t1_line <= 1)
        return;
    if (t1_in_eexec) 
        while (p < t1_line_ptr)
            T1_PUTCHAR(eencrypt(*p++));
    else 
        while (p < t1_line_ptr)
            T1_PUTCHAR(*p++);
}

void t1_scan_param() 
{
    int i, k;
    char *p, buf[T1_BUF_SIZE], *q, *r;
    key_entry *key;
    if (*t1_line != '/')
        return;
    if (T1_PREFIX("/lenIV")) {
        t1_lenIV = atoi(strchr(t1_line, ' ') + 1);
        return;
    }
    for (key = font_keys; key - font_keys  < MAX_KEY_CODE; key++)
        if (!strncmp(t1_line + 1, key->t1name, strlen(key->t1name)))
          break;
    if (key - font_keys == MAX_KEY_CODE)
        return;
    p = t1_line + strlen(key->t1name) + 1;
    key->valid = true;
    if (*p == ' ')
        p++;
    if ((k = key - font_keys) == FONTNAME_CODE) {
        r = ++p; /* skip the slash */
        for (q = buf; *p != ' ' && *p != 10; *q++ = *p++);
        *q = 0;
        key->value.s = xstrdup(buf);
        if (is_included() && is_subsetted()) {
            strcpy(buf, p);
            sprintf(r, "%s+%s%s", fm_cur->prefix, key->value.s, buf);
            t1_line_ptr = strchr(r, 0);
        }
        return;
    }
    if ((k == STEMV_CODE ||  k == FONTBBOX1_CODE) &&
        (*p == '[' || *p == '{'))
        p++;
    if (k == FONTBBOX1_CODE) {
        for (i = 0; i < 4; i++) {
            key[i].value.i = atoi(p);
            if (*p == '-')
                p++;
            while (isdigit(*p++));
        }
        return;
    }
    key->value.i = atoi(p);
}

void cs_store()
{
    char *p, *q, buf[T1_BUF_SIZE];
    for (p = t1_line, q = buf; *p != ' ';)
        *q++ = *p++;
    *q = 0;
    cs_ptr->name = xstrdup(buf + 1); /* don't store the slash */
    cs_ptr->len = t1_cslen;
    cs_ptr->data = XTALLOC(cs_ptr->len + 9, byte);
    cs_ptr->used = false;
    bcopy(cs_start - 4, cs_ptr->data, cs_ptr->len + 9);
    cs_ptr++;
}

#define cs_getchar() cdecrypt(*data++, &cr)

static void cs_mark(char *name)
{
    byte *data;
    int i, b;
    long val1, val2, cs_len;
    unsigned short cr;
    cs_entry *cs;
    for (cs = cs_tab; cs < cs_ptr; cs++) {
        if (!strcmp(cs->name, name)) {
            if (cs->used)
                return;
            else {
                cs->used = true;
                cr = 4330; 
                cs_len = cs->len;
                data = cs->data + 4;
                for (i = 0; i < t1_lenIV; i++, cs_len--)
                    cs_getchar();
                while (cs_len > 0) {
                    --cs_len;
                    b = cs_getchar();
                    if (b >= 32) {
                        val2 = val1;
                        if (b <= 246)
                            val1 = b - 139;
                        else if (b <= 250) {
                            --cs_len;
                            val1 = ((b - 247) << 8) + 108 + cs_getchar();
                        } 
                        else if (b <= 254) {
                            --cs_len;
                            val1 = -((b - 251) << 8) - 108 - cs_getchar();
                        } 
                        else if (b == 255) {
                            cs_len -= 4;
                            val1 =  (cs_getchar() & 0xff) << 24;
                            val1 |= (cs_getchar() & 0xff) << 16;
                            val1 |= (cs_getchar() & 0xff) <<  8;
                            val1 |= (cs_getchar() & 0xff) <<  0;
                            if (sizeof(int) > 4 && val1 & (1U << 31))
                                for (i = 4; i < sizeof(int); i++)
                                    val1 |= 0xff << (i * 8);
                        }
                    }
                    else if (b == 12) {
                        cs_len--;
                        if (cs_getchar() == 6) {
                            cs_mark(standard_glyph_names[val1]);
                            cs_mark(standard_glyph_names[val2]);
                        }
                    }
                }
                return;
            }
        }
    }
    WARN("glyph `%s' undefined" AND name);
}

void writet1()
{
    int i, size_pos, cs_dict_size, cs_count, encoding;
    char buf[T1_BUF_SIZE], *save_line1, *save_line2, *p;
    cs_entry *cs;
    filename = fm_cur->ff_name;
    packfilename(maketexstring(filename), getnullstr(), getnullstr());
    if (!T1_OPEN()) {
        WARN("cannot open Type 1 font file for reading");
        font_file_not_found = true;
        return;
    }
    TEX_PRINTF("<%s" AND fm_cur->ff_name);
    t1_lenIV = 4;
    t1_dr = 55665;
    t1_er = 55665;
    t1_in_eexec = false;
    t1_charstring = false;
    if ((i = T1_GETCHAR()) != 128)
        t1_ispfa = true;
    else
        t1_marker(i, 1);
    if (!is_included()) { /* scan parameters from font file */
        do {
            T1_CHECK_EOF();
            t1_getline();
            t1_scan_param();
        } while (!T1_PREFIX("currentfile eexec"));
        if (!t1_ispfa) {
            i = T1_GETCHAR();
            t1_marker(i, 2);
        }
        t1_in_eexec = true;
        for (i = 0; i < 4; i++) {
            T1_CHECK_EOF();
            edecrypt(T1_GETCHAR());
        }
        do {
            T1_CHECK_EOF();
            t1_getline();
            t1_scan_param();
        } while (!(T1_PREFIX("2 index /CharStrings") ||
             T1_PREFIX("dup /CharStrings") ||
             T1_PREFIX("/Subrs")));
        TEX_PRINTF(">");
        T1_CLOSE();
        return;
    } 
    if (!is_subsetted()) { /* include entire font */
        pdfsaveoffset = pdfoffset;
        do {
            T1_CHECK_EOF();
            t1_getline();
            t1_scan_param();
            t1_putline();
        } while (!T1_PREFIX("currentfile eexec"));
        t1_length1 = pdfoffset - pdfsaveoffset;
        if (!t1_ispfa) {
            i = T1_GETCHAR();
            t1_marker(i, 2);
        }
        pdfsaveoffset = pdfoffset;
        t1_in_eexec = true;
        for (t1_line_ptr = t1_line, i = 0; i < 4; i++) {
            edecrypt(T1_GETCHAR());
            T1_CHECK_EOF();
            *t1_line_ptr++ = 0;
        }
        t1_putline(); /* to put the first four bytes */
        do {
            T1_CHECK_EOF();
            t1_getline();
            t1_scan_param();
            t1_putline();
        } while (!(T1_PREFIX("2 index /CharStrings") ||
                 T1_PREFIX("dup /CharStrings") ||
                 T1_PREFIX("/Subrs")));
        t1_charstring = true;
        do {
            T1_CHECK_EOF();
            t1_getline();
            t1_putline();
        } while (!t1_suffix("mark currentfile closefile"));
        t1_length2 = pdfoffset - pdfsaveoffset;
        if (!t1_ispfa)
            t1_marker(T1_GETCHAR(), 1);
        pdfsaveoffset = pdfoffset;
        t1_in_eexec = false;
        t1_charstring = false;
        do {
            T1_CHECK_EOF();
            t1_getline();
            t1_putline();
        } while (!t1_suffix("cleartomark"));
        t1_length3 = pdfoffset - pdfsaveoffset;
        TEX_PRINTF(">");
        T1_CLOSE();
        return;
    } 
    /* the rest is for partial downloading */
    pdfsaveoffset = pdfoffset;
    T1_CHECK_EOF();
    t1_getline();
    while (!T1_PREFIX("/Encoding")) {
        t1_scan_param();
        t1_putline();
        T1_CHECK_EOF();
        t1_getline();
    }
    if (t1_suffix("def")) {
        sscanf(t1_line + strlen("/Encoding"), "%s", buf);
        if (!strcmp(buf, "StandardEncoding"))
            encoding = ENC_STANDARD;
        else 
            FAIL("cannot subset font (unknown predefined encoding `%s')"
                 AND buf);
        t1_putline(); /* write the predefined encoding */
    }
    else {
        encoding = ENC_BUITIN; /* the font has its own built-in encoding */
        /*
        T1_PRINTF("/Encoding 256 array\n0 1 255 {1 index exch /.notdef put} for\n");
        */
        t1_putline();
    }
    if (is_reencoded()) { /*  we needn't read the built-in encoding */
        /*
        T1_PRINTF("readonly def\n");
        */
        if (encoding == ENC_BUITIN) do {
            T1_CHECK_EOF();
            t1_getline();
            t1_putline();
        } while (!t1_suffix("readonly def"));
    }
    else if (encoding == ENC_BUITIN) { /* we must read the built-in encoding */
        for (i = 0; i < MAX_CHAR_NUM; i++)
            builtin_glyph_names[i] = notdef;
        do {
            T1_CHECK_EOF();
            t1_getline();
            if (sscanf(t1_line, "dup %u%s put", &i, buf) == 2 &&
                *buf == '/' && pdfischarused(tex_font, i)) {
                builtin_glyph_names[i] = xstrdup(buf + 1); /* skip the slash */
                t1_putline();
            }
        } while (!t1_suffix("readonly def"));
        T1_PRINTF("readonly def\n");
    }
    do {
        T1_CHECK_EOF();
        t1_getline();
        t1_scan_param();
        t1_putline();
    } while (!T1_PREFIX("currentfile eexec"));
    t1_length1 = pdfoffset - pdfsaveoffset;
    if (!t1_ispfa) {
        i = T1_GETCHAR();
        t1_marker(i, 2);
    }
    pdfsaveoffset = pdfoffset;
    t1_in_eexec = true;
    for (t1_line_ptr = t1_line, i = 0; i < 4; i++) {
        edecrypt(T1_GETCHAR());
        T1_CHECK_EOF();
        *t1_line_ptr++ = 0;
    }
    t1_putline(); /* to put the first four bytes */
    T1_CHECK_EOF();
    t1_getline();
    while (!(T1_PREFIX("2 index /CharStrings") ||
             T1_PREFIX("dup /CharStrings") ||
             T1_PREFIX("/Subrs")))
    {
        t1_scan_param();
        t1_putline();
        T1_CHECK_EOF();
        t1_getline();
    }
    t1_charstring = true;
    if (T1_PREFIX("/Subrs")) do {
        t1_putline();
        T1_CHECK_EOF();
        t1_getline();
    } while (!(T1_PREFIX("2 index /CharStrings") ||
             T1_PREFIX("dup /CharStrings")));
    size_pos = strstr(t1_line, "/CharStrings") +
        strlen("/CharStrings") + 1 - t1_line;
    cs_dict_size = atoi(t1_line + size_pos);
    cs_ptr = cs_tab = XTALLOC(cs_dict_size, cs_entry);
    save_line1 = xstrdup(t1_line);
    T1_CHECK_EOF();
    t1_getline();
    while (t1_cslen) {
        cs_store();
        T1_CHECK_EOF();
        t1_getline();
    }
    save_line2 = xstrdup(t1_line);
    if (is_reencoded())
        cur_glyph_names = enc_tab[fm_cur->encoding].glyph_names;
    else if (encoding == ENC_BUITIN)
        cur_glyph_names = builtin_glyph_names;
    else if (encoding == ENC_STANDARD)
        cur_glyph_names = standard_glyph_names;
    for (i = 0; i < MAX_CHAR_NUM; i++)
        if (pdfischarused(tex_font, i))
            if (cur_glyph_names[i] == notdef)
                WARN("character %d is mapped to %s" AND
                     i AND notdef);
            else
                cs_mark(cur_glyph_names[i]);
    cs_mark(notdef);
    for (cs_count = 0, cs = cs_tab; cs < cs_ptr; cs++)
        if (cs->used)
            cs_count++;
    t1_line_ptr = t1_line;
    for (p = save_line1; p - save_line1 < size_pos;)
        *t1_line_ptr++ = *p++;
    for (;isdigit(*p); p++);
    sprintf(t1_line_ptr, "%u", cs_count);
    strcat(t1_line_ptr, p);
    XFREE(save_line1);
    t1_line_ptr = strchr(t1_line_ptr, 0);
    t1_putline();
    for (cs = cs_tab; cs < cs_ptr; cs++) {
        if (cs->used) {
            sprintf(t1_line, "/%s %u", cs->name, cs->len);
            p = strchr(t1_line, 0);
            bcopy(cs->data, p, cs->len + 9);
            p += cs->len + 9;
            t1_line_ptr = p;
            t1_putline();
        }
        XFREE(cs->data);
    }
    sprintf(t1_line, "%s", save_line2);
    t1_line_ptr = strchr(t1_line, 0);
    t1_putline();
    XFREE(save_line2);
    while (!t1_suffix("mark currentfile closefile")) {
        T1_CHECK_EOF();
        t1_getline();
        t1_putline();
    }
    t1_length2 = pdfoffset - pdfsaveoffset;
    if (!t1_ispfa)
        t1_marker(T1_GETCHAR(), 1);
    pdfsaveoffset = pdfoffset;
    t1_in_eexec = false;
    t1_charstring = false;
    while (!t1_suffix("cleartomark")) {
        T1_CHECK_EOF();
        t1_getline();
        t1_putline();
    }
    t1_length3 = pdfoffset - pdfsaveoffset;
    TEX_PRINTF(">");
    XFREE(cs_tab);
    T1_CLOSE();
}
