// conv_config.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// Methods for protected RealConverter::ConfigRequester class and its subclasses
// These internal classes request user input for converter parameters such as
// playback level and output port.

#include "localdefs.h"
#include "converter.h"
#include "query_templates.h"
#include "request.h"
#include "sndconfig.h"

RealConverter::ConfigRequester::ConfigRequester(RealConverter* converter)
		: TitledRequester("Converter Settings:"),
		  myConverter(converter) {}

void
RealConverter::ConfigRequester::configureRequest(Request* request) {
	request->appendValue(
#if defined( __GNUG__ ) || !defined(TEMPLATES_WORK_REALLY_WELL)
		new Query<int>(
			"Record Gain:",
			createSetterGetter(
				myConverter,
				&RealConverter::setRecordLevel,
				&RealConverter::currentRecordLevel),
			Range(0, 100),
			true
		)
#else
		createQuery(
			"Record Gain:",
			myConverter,
			&RealConverter::setRecordLevel,
			&RealConverter::currentRecordLevel,
			Range(0, 100),
			true
		)
#endif
	);
	request->appendValue(
#if defined( __GNUG__ ) || !defined( TEMPLATES_WORK_REALLY_WELL )
		new Query<int>(
			"Playback Gain:",
			createSetterGetter(
				myConverter,
				&RealConverter::setPlayLevel,
				&RealConverter::currentPlayLevel),
			Range(0, 100),
			true
		)
#else
		createQuery(
			"Playback Gain:",
			myConverter,
			&RealConverter::setPlayLevel,
			&RealConverter::currentPlayLevel,
			Range(0, 100),
			true
		)
#endif
	);
}

#ifdef NeXT

#include "next_dac.h"

void
NextConverter::NextConfigRequester::configureRequest(Request* request) {
	ConfigRequester::configureRequest(request);
}

boolean
NextConverter::NextConfigRequester::confirmValues() {
	return ConfigRequester::confirmValues();
}

#endif /* Next */

#ifdef SGI_DACS

#include "sgi_dac.h"

void
SGIConverter::SGIConfigRequester::configureRequest(Request* request) {
	ConfigRequester::configureRequest(request);
	SGIConverter* sc = (SGIConverter *) myConverter;
	source = sc->currentInputSource();
	request->appendChoice("Input Source:", "|microphone|line|digital|",
		&source,
		true
	);
	polite = sc->dontInterrupt ? True : False;
	request->appendChoice("Converter resource access mode:",
		"|rude|polite|",
		&polite,
		true
	);
}

boolean
SGIConverter::SGIConfigRequester::confirmValues() {
	if(ConfigRequester::confirmValues()) {
		SGIConverter* sc = (SGIConverter *) myConverter;
		sc->dontInterrupt = (polite == True);
		return sc->setInputSource(InputSource(source));	
	}
	return false;
}

#endif /* SGI_DACS */

#ifdef SPARC_DACS

#include "sun_dac.h"

void
SunConverter::SunConfigRequester::configureRequest(Request* request) {
	SunConverter* sc = (SunConverter *) myConverter;
	ChoiceValue inputPort = 0;
	ChoiceValue outputPort = 0;
	if(sc->reOpen()) {
		ConfigRequester::configureRequest(request);
		inputPort = sc->currentInputPort();
		outputPort = sc->currentOutputPort();
		sc->close();
		request->appendChoice("Input Port:", "|mike|line|",
				     &inputPort, true);
		request->appendChoice("Output Port:", "|speaker|headphone|",
		                     &outputPort, true);
	}
	else
		request->appendLabel("Unable to open converter device");
}

boolean
SunConverter::SunConfigRequester::confirmValues() {
	SunConverter* sc = (SunConverter *) myConverter;
	boolean status = false;
	if(sc->reOpen()) {
		if(ConfigRequester::confirmValues()) {
			status = sc->setInputPort(SunConverter::InputPort(inputPort));
			status = status && sc->setOutputPort(SunConverter::OutputPort(outputPort));
		}
		sc->close();
	}
	return status;
}

#endif /* SPARC_DACS */

#ifdef VOXWARE_DACS

#include "vw_converter.h"

void
VW_Converter::VW_ConfigRequester::configureRequest(Request* request) {
	ConfigRequester::configureRequest(request);
}

#endif /* VOXWARE_DACS */
