/*================================================================
 * preload samples in a midi file using AWElib
 *================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/wait.h>
#include "util.h"
#include "midievent.h"
#include "controls.h"
#include "seq.h"
#include "channel.h"

#include <awebank.h>
#include <sfopts.h>

static void load_fonts(MidiInfo *mp, char *fontfile, LoadList *lp, int bank);

static LoadList *pload;

void preload_sample(MidiInfo *mp, char *fontfile)
{
	MidiEvent *ev;
	int i, rc;

	pload = NULL;

	channel_init(mp);

	ev = mp->list;
	for (i = 0; i < mp->nlists; i++, ev++) {
		do_midi_event(ev, mp, EV_PRELOAD);
	}

	if (pload) {
		load_fonts(mp, fontfile, pload, 0);
		free_loadlist(pload);
	}
}

static void load_fonts(MidiInfo *mp, char *fontfile, LoadList *lp, int bank)
{
	int rc;
	if (! mp->sample_cleared) {
		seq_remove_samples();
		mp->sample_cleared = TRUE;
	}
	awe_read_option_file(fontfile);
	awe_option.default_bank = bank;
	rc = awe_load_bank(fontfile, lp, FALSE);
	if (rc != AWE_RET_OK && ctl) {
		ctl->cmsg(CMSG_INFO, -1, "preload: couldn't load all fonts: %s", fontfile);
	}
}

void add_preload(int chn, int preset, int bank, int keynote)
{
	SFPatchRec pat;
	LoadList *rec;

	pat.preset = preset;
	pat.bank = bank;
	pat.keynote = keynote;
	for (rec = pload; rec; rec = rec->next) {
		if (awe_match_preset(&rec->pat, &pat))
			return;
	}
	pload = add_loadlist(pload, &pat, NULL);
}

/*----------------------------------------------------------------*/

void load_sub_sf(MidiInfo *mp, char *args)
{
	load_fonts(mp, args, NULL, 1);
}

