%{
/*
  $Id: cfparse.y,v 1.7 1996/08/22 12:53:14 luik Exp $

  cfparse.y - yacc based config file parser for omirrd.
  Based on gram.y of rdist source of the BSD 4.3-Net/2 release.
  UCB copyrights: see below.
  Modified by Andreas Luik, <luik@pharao.s.bawue.de>.

*/

/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "common.h"

#if defined(RCSID) && !defined(lint)
static char rcsid[] UNUSED__ = "$Id: cfparse.y,v 1.7 1996/08/22 12:53:14 luik Exp $";
#endif /* defined(RCSID) && !defined(lint) */

#if defined(SCCSID) && !defined(lint)
static char sccsid[] UNUSED__ = "@(#)gram.y	5.6 (Berkeley) 6/1/90";
#endif /* not lint */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "libomirr.h"
#include "error.h"
#include "cfnl.h"
#include "cfvar.h"
#include "cf.h"
#include "optflags.h"
#include "omirrd.h"


struct mask {
    unsigned long set_flag;
    unsigned long clear_flag;
};

int yyerror(char *s);
int yylex(void);


static CfNameList last_nl;
static CfSubCmd last_sc;

%}

%term EQUAL	1
%term LP	2
%term RP	3
%term SM	4
%term ARROW	5
%term COLON	6
%term DCOLON	7
%term NAME	8
%term STRING	9
%term INSTALL	10
%term EXCEPT	11
%term OPTION	12

%union {
	char *string;
	unsigned long ulong;
	struct mask mask;
	CfSubCmd subcmd;
	CfNameList namelist;
}

%type <string> NAME, STRING
%type <ulong> options
%type <mask> OPTION
%type <subcmd> INSTALL, EXCEPT, subcmdlist, subcmd
%type <namelist> namelist, names, opt_namelist

%%

file:		  /* VOID */
		| file command
		;

command:	  NAME EQUAL namelist = {
			(void) cfSetVar($1, $3);
		}
		| namelist ARROW namelist subcmdlist = {
			cfAddCmd(C_TYPE_ARROW, NULL, $1, $3, $4);
		}
		| NAME COLON namelist ARROW namelist subcmdlist = {
			cfAddCmd(C_TYPE_ARROW, $1, $3, $5, $6);
		}
		| error
		;

namelist:	  NAME = {
			$$ = cfAllocNameListEnt($1);
		}
		| LP names RP = {
			$$ = $2;
		}
		;

names:		  /* VOID */ {
			$$ = last_nl = NULL;
		}
		| names NAME = {
			if (last_nl == NULL)
				$$ = last_nl = cfAllocNameListEnt($2);
			else {
				last_nl = cfAppendNameListEnt(last_nl, $2);
				$$ = $1;
			}
		}
		;

subcmdlist:	  /* VOID */ {
			$$ = last_sc = NULL;
		}
		| subcmdlist subcmd = {
			if (last_sc == NULL)
				$$ = last_sc = $2;
			else {
				last_sc->sc_next = $2;
				last_sc = $2;
				$$ = $1;
			}
		}
		;

subcmd:		  INSTALL options opt_namelist SM = {
			CfNameList nl;

			$1->sc_options = $2;
			if ($3 != NULL) {
				nl = cfExpandVars($3);
				if (nl) {
					if (nl->n_next != NULL)
					    yyerror("only one name allowed\n");
					$1->sc_name = nl->n_name;
					free(nl);
				} else
					$1->sc_name = NULL;
			}
			$$ = $1;
		}
		| EXCEPT namelist SM = {
			if ($2 != NULL)
				$1->sc_args = cfExpandVars($2);
			$$ = $1;
		}
		;

options:	  /* VOID */ = {
			$$ = option_flag;
		}
		| options OPTION = {
			$$ |= $2.set_flag;
			$$ &= ~$2.clear_flag;
		}
		;

opt_namelist:	  /* VOID */ = {
			$$ = NULL;
		}
		| namelist = {
			$$ = $1;
		}
		;

%%

static FILE *fin;		/* input file used by yylex() */

#define INMAX	3500		/* maximum line and string length in input */

#define any(C,S)    (strchr(S,C) != NULL)

int yylex(void)
{
	static char yytext[INMAX]; /* XXX fixed length, should be made dynamic */
	register int c;
	register char *cp1, *cp2;
	
again:
	switch (c = getc(fin)) {
	case EOF:  /* end of file */
		return(0);

	case '#':  /* start of comment */
		while ((c = getc(fin)) != EOF && c != '\n')
			;
		if (c == EOF)
			return(0);
	case '\n':
		current_line++;
	case ' ':
	case '\t':  /* skip blanks */
		goto again;

	case '=':  /* EQUAL */
		return(EQUAL);

	case '(':  /* LP */
		return(LP);

	case ')':  /* RP */
		return(RP);

	case ';':  /* SM */
		return(SM);

	case '-':  /* -> */
		if ((c = getc(fin)) == '>')
			return(ARROW);
		ungetc(c, fin);
		c = '-';
		break;

	case '"':  /* STRING */
		cp1 = yytext;
		cp2 = &yytext[INMAX - 1];
		for (;;) {
			if (cp1 >= cp2) {
				yyerror("command string too long\n");
				break;
			}
			c = getc(fin);
			if (c == EOF || c == '"')
				break;
			if (c == '\\') {
				if ((c = getc(fin)) == EOF) {
					*cp1++ = '\\';
					break;
				}
			}
			if (c == '\n') {
				current_line++;
				c = ' '; /* can't send '\n' */
			}
			*cp1++ = c;
		}
		if (c != '"')
			yyerror("missing closing '\"'\n");
		*cp1 = '\0';
		yylval.string = xstrdup(yytext);
		return(STRING);

	case ':':  /* : or :: */
		if ((c = getc(fin)) == ':')
			return(DCOLON);
		ungetc(c, fin);
		return(COLON);
	}
	cp1 = yytext;
	cp2 = &yytext[INMAX - 1];
	for (;;) {
		if (cp1 >= cp2) {
			yyerror("input line too long\n");
			break;
		}
		*cp1++ = c;
		c = getc(fin);
		if (c == EOF || any(c, " \"'\t()=;:\n")) {
			ungetc(c, fin);
			break;
		}
	}
	*cp1 = '\0';
	if (yytext[0] == '-' && yytext[1] == 'o') {
		char *unknown_args;
		if (optParseOptions(&yytext[2],
				    &yylval.mask.set_flag,
				    &yylval.mask.clear_flag,
				    &unknown_args) == -1) {
			yyerror("unknown options ignored\n");
		}
		return(OPTION);
	}
	if (yytext[0] == '-' && yytext[2] == '\0') {
		char *unknown_args;
		if (optParseOptions(yytext,
				    &yylval.mask.set_flag,
				    &yylval.mask.clear_flag,
				    &unknown_args) == -1) {
			yyerror("unknown option ignored\n");
		}
		return(OPTION);
	}
	if (!strcmp(yytext, "install")) {
		yylval.subcmd = cfAllocSubCmdEnt(SC_TYPE_INSTALL);
		return(INSTALL);
	}
	else if (!strcmp(yytext, "except")) {
		yylval.subcmd = cfAllocSubCmdEnt(SC_TYPE_EXCEPT);
		return(EXCEPT);
	}
	else {
		yylval.string = xstrdup(yytext);
		return(NAME);
	}
}


/* Error printing routine in parser.  */
int yyerror(char *s)
{
    warning(s);
    return 0;
}


/* cfParse - the config file parser main function. Opens the specified
   file, calls yyparse and closes the file.  Returns -1 if the file
   could not be opened, otherwise the return value of `yyparse' which
   is 0 on success and 1 on parse failure.  */
int cfParse(char *filename)
{
    int result;

    current_file_name = filename;
    fin = fopen(current_file_name, "r");
    if (fin == NULL) {
	error("failed to open %s: %s\n", current_file_name, xstrerror(errno));
	current_file_name = NULL;
	return -1;
    }

    current_line = 1;
    result = yyparse();

    fclose(fin);
    current_file_name = NULL;
    current_line = -1;

    return result;
}

