/*
 * Module/dll handling code written by Colten Edwards.
 * Copyright 1997
 */
 
#ifndef _MODULE_H
#define _MODULE_H


#ifdef WANT_DLL
#include "struct.h"

#define COMMAND_PROC	0x0001		/* New /command proc return void */
#define ALIAS_PROC	0x0002		/* new $alias proc return new_malloc'd string */
#define CTCP_PROC	0x0004		/* new ctcp proc return new_malloc'd string*/
#define VAR_PROC	0x0008		/* new variable no return */
#define HOOK_PROC	0x0010		/* new numeric proc 
					 * return int 1 if we don't want client
					 * to also handle this.
					 * or 0  if we want client to handle
					 */
#define RAW_PROC	0x0020		/* new raw irc proc */

#define INVALID_MODVERSION -1


typedef int (Irc_PackageInitProc)  (IrcCommandDll **interp);
typedef char *(Irc_PackageVersionProc)  (IrcCommandDll **interp);

typedef struct _package_installed {
	struct _package_installed *next;
	char    *name;
	char    *version;

	int	major;
	int	minor;

#if defined(HPUX)
	shl_t handle;
#else
	void	*handle;
#endif
	Irc_PackageInitProc *cleanup;
} Packages;
                                
Packages *find_module (char *);
int add_module_proc (int, char *, char *, char *, int, int, void *, void *);
int remove_package (char *);
int remove_module_procs (int, char *, char *, char *);

extern IrcVariableDll *dll_variable;
extern BuiltInDllFunctions *dll_functions;
extern NumericFunction *numeric_dll;
extern IrcCommandDll *dll_commands;
extern CtcpEntryDll *dll_ctcp;

char *get_dllstring_var(char *);
int get_dllint_var(char *);
void set_dllstring_var(char *, char *);
void set_dllint_var(char *, unsigned int);
RawDll *find_raw_proc(char *, char **);

int check_version(unsigned long);

#endif

#endif
