#!/usr/local/bin/perl
# importcat.pl - program to convert quicken category
#                files to a cbb format category file.
#                Uses categories.pl.
#
# Usage: importcat.pl <file> [category file]
#
#        where "file" is a Quicken exported .qif file of categories
#        and "category file" is an optional name of the CBB format
#        category file, which defaults to "categories" if omitted.
#
# Written by Brian D. Wright
# Based on:
#     import.pl - functions to implement importing from other formats
#     Written by Curtis Olson.  Started August 25, 1994.
#     Copyright (C) 1994, 1995, 1996  Curtis L. Olson  - curt@sledge.mn.org
#
# v.0.1 9/22/96


# specify the installed location of the necessary pieces.
$cbb_incl_dir = "..";
unshift(@INC, $cbb_incl_dir);

require "common.pl";
require "categories.pl";

$infile = $ARGV[0];
$outfile = $ARGV[1];
if ($outfile eq "") {
    $outfile = "categories";
}
&init_cats;
&import_cat($infile);
&save_cats($outfile);

# import a quicken category export file (.qif)
sub import_cat {
    # in: file
    # out: result

    local($file) = @_;

    open(QIF, "<$file");

    ($key, $desc, $tax) = ("", "", "");

    while ( <QIF> ) {
	chop;			# get rid of that pesky newline.
	s/\r//g;		# strip the dos ^M if needed
	if ( m/^\!/ ) {
	    # Type
	    # print "$_\n";
	} elsif ( m/^N/ ) {
	    # Name
	    $key = substr($_,1);
	    # print "$key\n";
	} elsif ( m/^D/ ) {
	    # Description
	    $desc = substr($_,1);
	    # print "$desc\n";
	} elsif ( m/^T/ ) {
	    # Tax-related
	    $tax = "x";
	    # print "$tax\n";
	} elsif ( m/^R/ ) {
	    # Junk??
	} elsif ( m/^I/ ) {
	    # Income
	} elsif ( m/^E/ ) {
	    # Expense
	} elsif ( m/^\^/ ) {
	    #print "End of record\n";
	    $CATS{$key} = "$desc\t$tax";
	    ($key, $desc, $tax) = ("", "", "");
	} elsif ( $_ eq "" ) {
	    # toss empty lines ...
	} else {
	    print "unknown data: $_\n";
	}
    }

    close(QIF);

    return "ok";
}


1;				# need to return a true value

# End importcat.pl

