/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1998 */
/* See the file NOTICE for conditions of use and distribution. */


/* Source files for exim all #include this header, which drags in everything
that is needed. They don't all need everything, of course, but it's far too
messy to have each one importing its own list, and anyway, most of them need
most of these includes. */

/* Assume most systems have statfs() unless os.h undefines this macro */

#define HAVE_STATFS

/* First of all include the os-specific header, which might set things that
are needed by any of the other headers, including system headers. */

#include "os.h"


/* ANSI C standard includes */

#include <ctype.h>
#include <signal.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/* Unix includes */

#include <errno.h>
#if	defined(__svr4__) && defined(__sparc) && ! defined(__EXTENSIONS__)
#define __EXTENSIONS__  /* so that SunOS 5 gets NGROUPS_MAX */
#include <limits.h>
#undef  __EXTENSIONS__
#else
#include <limits.h>
#endif

#include <sys/types.h>
#include <dirent.h>
#include <netdb.h>
#include <pwd.h>
#include <grp.h>
#include <syslog.h>

#ifndef NO_SYSEXITS      /* some OS don't have this */
#include <sysexits.h>
#endif

#include <sys/time.h>
#include <sys/param.h>
#include <sys/resource.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

/* The new standard is statvfs; some OS have statfs. For statvfs the block
counts must be multiplied by the "fragment size" f_frsize to get the actual
size. In other cases the value seems to be f_bsize (which is sometimes the only
block size), so we use a macro to get that instead.

Also arrange to be able to cut it out altogether for way-out OS that don't have
anything. I've indented a bit here to try to make the mess a bit more
intelligible. */

#ifdef HAVE_STATFS
  #ifdef HAVE_SYS_STATVFS_H
    #include <sys/statvfs.h>
  #else
    #define statvfs statfs
    #define f_frsize f_bsize
    #ifdef HAVE_SYS_VFS_H
      #include <sys/vfs.h>
      #ifdef HAVE_SYS_STATFS_H
      #include <sys/statfs.h>
      #endif
    #endif
    #ifdef HAVE_SYS_MOUNT_H
    #include <sys/mount.h>
    #endif
  #endif
#endif


#ifndef  SIOCGIFCONF	 /* HACK for SunOS 5 */
#include <sys/sockio.h>
#endif

#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <fcntl.h>

/* There's a shambles in IRIX6 - it defines EX_OK in unistd.h which conflicts
with the definition in sysexits.h. Arrange to preserve it, even though at
present Exim doesn't actually use it. */

#ifdef EX_OK
#define SAVE_EX_OK EX_OK
#undef EX_OK
#endif

#include <unistd.h>

#ifdef SAVE_EX_OK
#ifdef EX_OK
#undef EX_OK
#endif
#define EX_OK SAVE_EX_OK
#endif

#include <utime.h>
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <arpa/nameser.h>

/* The resolv.h header defines __P(x) on some Solaris 2.5.1 systems (without
checking that it is already defined, in fact). This conflicts with other
headers that behave likewise (see below), leading to compiler warnings. Arrange
to undefine it if resolv.h defines it. */

#if defined(__P)
#define __P_WAS_DEFINED_BEFORE_RESOLV
#endif

#include <resolv.h>

#if defined(__P) && ! defined (__P_WAS_DEFINED_BEFORE_RESOLV)
#undef __P
#endif

/* These three are to support the IP option logging code. Linux is
different to everyone else and there are also other systems which don't
have netinet/ip_var.h, so there's a general macro to control its inclusion. */

#include <netinet/in_systm.h>
#include <netinet/ip.h>

#ifndef NO_IP_VAR_H
#include <netinet/ip_var.h>
#endif


/* The ident.h header defines __P(x) if it is not already defined (for handling
prototypes). Unfortunately, on some systems, db.h (which is included from
Exim's dbfn.h for native Berkeley DB 1.85 use) also defines it, without
checking for a previous definition. This leads to a warning message. However,
on other systems, db.h doesn't define it, expecting it to be done by other
headers. To avoid warnings and nevertheless keep things working in all cases,
we arrange to undefine __P if and only if ident.h defines it. */

#if defined(__P)
#define __P_WAS_DEFINED_BEFORE_IDENT
#endif

#include "libident/ident.h"

#if defined(__P) && ! defined (__P_WAS_DEFINED_BEFORE_IDENT)
#undef __P
#endif

/* If we are on an IPv6 system, the macro AF_INET6 will have been defined in
the sys/socket.h header. It is helpful to have this defined on an IPv4 system
so that it can appear in the code, even if it is never actually used when
the code is run. It saves some #ifdef occurrences. */

#ifndef AF_INET6
#define AF_INET6 24
#endif

/* One operating system uses a different type for the 2nd argument of select().
Its os.h file defines SELECT_ARG2_TYPE. For the rest, define a default here. */

#ifndef SELECT_ARG2_TYPE
#define SELECT_ARG2_TYPE fd_set
#endif

/* One operating system uses a different type for the 4th argument of
dn_expand(). It's os.h file defines DN_EXPAND_ARG4_TYPE. For the rest, define a
default here. */

#ifndef DN_EXPAND_ARG4_TYPE
#define DN_EXPAND_ARG4_TYPE char *
#endif

/* One operating system defines a different type for the yield of inet_addr().
In Exim code, its value is always assigned to the s_addr members of address
structures. Casting the yield to the type of s_addr should fix the problem,
since the size of the data is correct. Just in case this ever has to be
changed, use a macro for the type, and define it here so that it is possible to
use different values for specific OS if ever necessary. */

#ifndef S_ADDR_TYPE
#define S_ADDR_TYPE u_long
#endif

/* The header from the PCRE regex package */

#include "pcre/pcre.h"

/* Exim includes are in several files */

#include "macros.h"
#include "config.h"

#include "dbfn.h"
#include "structs.h"
#include "globals.h"
#include "functions.h"

/* If SPOOL_DIRECTORY, STDERR_FILE, LOG_FILE_PATH or PID_FILE_PATH have not
been defined, set them to the null string. */

#ifndef SPOOL_DIRECTORY
  #define SPOOL_DIRECTORY ""
#endif
#ifndef STDERR_FILE
  #define STDERR_FILE ""
#endif
#ifndef LOG_FILE_PATH
  #define LOG_FILE_PATH ""
#endif
#ifndef PID_FILE_PATH
  #define PID_FILE_PATH ""
#endif

/* End of exim.h */
