/*								-*- C++ -*-
 * $Id: WIN_listbox.h,v 1.2 1997-01-15 14:58:00+01 mho Exp $
 *
 * Purpose: list box panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef ListBox_h
#define ListBox_h

#ifdef __GNUG__
#pragma interface
#endif

class wxPanel;
class wxStringList;

class wxListBox : public wxItem {
DECLARE_DYNAMIC_CLASS(wxListBox)
public:
    wxListBox(void);
    wxListBox(wxPanel *panel, wxFunction func, Const char *title,
	      Bool Multiple = FALSE,
	      int x = -1, int y = -1, int width = -1, int height = -1,
	      int n = 0, char **Choices = NULL,
	      long style = 0, Constdata char *name = wxListBoxNameStr);
    ~wxListBox(void);

    // override parent methods
    virtual void SetSize(int width, int height) { SetSize(-1, -1, width, height); }
    virtual void SetSize(int x, int y, int width, int height, int flags=wxSIZE_AUTO);
    virtual void Scroll(int x_pos, int y_pos);
    // handle the contents of the list
    void  Append(char *item);
    void  Append(char *item, char *client_data);
    void  Clear(void);
    void  Fit(void);
    Bool  Create(wxPanel *panel, wxFunction func, Const char *title,
		 Bool multiple = FALSE,
		 int x = -1, int y = -1, int width = -1, int height = -1,
		 int n = 0, char **choices = NULL,
		 long style = 0, Constdata char *name = wxListBoxNameStr);
    void  Delete(int n);
    void  Deselect(int n);
    int   FindString(char *s);
    char  *GetClientData(int n);
    int   GetSelection(void);
    int   GetSelections(int **list_selections);
    char  *GetString(int n);
    char  *GetStringSelection(void);
    void  InsertItems(int n_items, char **items, int pos);
    int   Number(void);
    Bool  Selected(int n);
    void  Set(int n, char *choices[]);
    void  Set(wxStringList *slist);
    void  SetClientData(int n, char *client_data);
    void  SetClientData(char *data) { wxItem::SetClientData(data); }
    void  SetFirstItem(int n);
    void  SetFirstItem(char *s);
    void  SetSelection(int c, Bool select = TRUE);
    void  SetString(int n, char *s);
    Bool  SetStringSelection(char *s);
    // single or mulitple selection?
    virtual int GetSelectionMode(void)     { return multiple; }
    virtual void SetSelectionMode(int sel) { multiple = sel; }
    // OnChar handles cursor keys
    void OnChar(wxKeyEvent& event);
private:
    #ifdef Have_Xt_Types
    static void EventCallback(Widget w, XtPointer, XtPointer);
    #endif
    void  SetInternalData(void);

    char    **choices;
    char    **client_data;
    int     num_choices, num_free;
    Bool    quoted;
    int     multiple;
};

#endif // ListBox_h
