// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  DArray.h

  Stephane Rehel
  November 11 1996

  We do not use template since gcc 2.7.2 _doesn't_ expand
  template inlines!!! (crazy)
*/


#ifndef ELEMENT
#error Please define ELEMENT
#endif

#ifndef NAME
#error Please define NAME
#endif

#include <assert.h>

#ifndef __IBOOL_H
#include <tools/IBOOL.h>
#endif

/////////////////////////////////////////////////////////////////////////////

class NAME
{
private:
  int blockSizeExp; // n
  int blockSize;    // 2**n
  int blockSizeAnd; // 2**n - 1

  ELEMENT** blocks;
  int nBlocks;

  int maxElements;
  int nElements;

public:
  NAME( int _blockSize = 8 );
  ~NAME();

         void           clear      ();
  inline ELEMENT&       operator[] ( register int i );
  inline const ELEMENT& get        ( register int i ) const;
  inline int            getSize    () const;

         ELEMENT&       append     ();
         void           remove     ( int i );

         void           alloc      ( int size );

         int            getSizeOf  () const;

private:
         void           expand     ();
};

/////////////////////////////////////////////////////////////////////////////

inline int NAME::getSize() const
{
  return nElements;
}

/////////////////////////////////////////////////////////////////////////////

inline ELEMENT& NAME::operator [] ( register int i )
{
  assert( i >= 1 );
  assert( i <= nElements );
  --i;
  return blocks[ i >> blockSizeExp ][ i & blockSizeAnd ];
}

/////////////////////////////////////////////////////////////////////////////

inline const ELEMENT& NAME::get ( register int i ) const
{
  assert( i >= 1 );
  assert( i <= nElements );
  --i;
  return blocks[ i >> blockSizeExp ][ i & blockSizeAnd ];
}

/////////////////////////////////////////////////////////////////////////////

