/*
 * Program XBLAST V2.5.5 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * April 1st, 1997
 * started August 1993
 *
 * File: demo.c 
 * demo recording and playback
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _DEMO_H
#define _DEMO_H

#include "include.h"
#include "mytypes.h"

/*
 * prototypes
 */
#ifdef _DEMO_C
#define _EXTERN
#else
#define _EXTERN extern
#endif

#ifdef __STDC__
_EXTERN int open_demo (XBConfig *config, XBSettings *setup, int level);
_EXTERN void record_void (PlayerAction *pa);
_EXTERN void record_keys (PlayerAction *pa);
_EXTERN int close_demo (void);
_EXTERN int load_demo (char *name);
_EXTERN void config_from_demo (XBConfig *config);
_EXTERN void setup_from_demo (XBSettings *setup);
_EXTERN void player_strings_from_demo (PlayerStrings *st, XBConfig *config);
_EXTERN void reset_demo (void);
_EXTERN void playback_keys (PlayerAction *pa);
#else
_EXTERN int open_demo ();
_EXTERN void record_keys ();
_EXTERN void record_void ();
_EXTERN int close_demo ();
_EXTERN int load_demo ();
_EXTERN void config_from_demo ();
_EXTERN void setup_from_demo ();
_EXTERN void player_strings_from_demo ();
_EXTERN void reset_demo ();
_EXTERN void playback_keys ();
#endif
#undef _EXTERN 

#endif
/*
 * end of file demo.h
 */
