#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/start/start.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.9
 | File mod date:    1997.11.29 23:10:38
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  start
 |
 | Purpose:          Provide the entry point procedure
 `------------------------------------------------------------------------|#

(define *script* #f)

;;

;; the args passed here are the ones with low-level flags
;; like -image, -q, -script
;; already parsed out (so we don't have to)
;;
;; the "raw" args are available in boot_args rscheme_global[1]

(define-syntax (get-boot-args)
  (rscheme-global-ref 1))

(define-syntax (get-boot-image)
  (rscheme-global-ref 0))

(define (die)
  (fwrite/str (stderr) "** Interrupted\n")
  (process-exit 1))

;;;
;;;  note that before we run the initialization thunks, any
;;;  top-level defines with non-constant right-hand-sides
;;;  are not initialized, like $standard-output-port, for example
;;;

(define (start args verbose-flag script-flag)
  ;;
  (register-interrupt-handler! 'control-c die)
  ;; now that we have a ^C handler, we can enable interrupts
  (os-set-sigenable #t)
  ;;
  (set-verbose! verbose-flag)
  (set! *script* script-flag)
  ;;
  (let ((info (get-boot-image)))
    ;;
    ;; greet the user if not running silently
    ;;
    (if verbose-flag
	(greeting))
    ;;
    ;; run the initialization thunks
    ;;
    (call-thunks (gvec-ref info 3))
    ;;
    ;; call the "main" program
    ;;
    ((gvec-ref info 4) args)))

(define (call-thunks (lst <pair>))
  (let loop (((inits <pair>) lst))
    ((car inits))
    (if (pair? (cdr inits))
	(loop (cdr inits)))))
