#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/mathlib/numthy.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.6
 | File mod date:    1997.11.29 23:10:36
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  mathlib
 |
 | Purpose:          number theory functions (lcm, gcd, ...)
 `------------------------------------------------------------------------|#

(define-syntax (remainder* chop a b)
  (- a (* b (chop (/ a b)))))


(define (remainder (a <number>) (b <number>))
  (if (fixnum? a)
      (if (fixnum? b)
	  (int-remainder a b)
	  (if (long-int? b)
	      (raw-int-64->integer (raw-int-64-remainder a b))
	      (remainder* truncate a b)))
      (if (long-int? a)
	  (if (fixnum? b)
	      (raw-int-64->integer (raw-int-64-remainder a b))
	      (remainder* truncate a b))
	  (remainder* truncate a b))))

(define (modulo (a <number>) (b <number>))
  (if (fixnum? a)
      (if (fixnum? b)
	  (int-modulo a b)
	  (if (long-int? b)
	      (raw-int-64->integer (raw-int-64-modulo a b))
	      (remainder* floor a b)))
      (if (long-int? a)
	  (if (fixnum? b)
	      (raw-int-64->integer (raw-int-64-modulo a b))
	      (remainder* floor a b))
	  (remainder* floor a b))))
  
(define (quotient (a <number>) (b <number>))
  (if (and (fixnum? a)
	   (fixnum? b))
      (fixnum-quotient a b)
      (error "(quotient ~s ~s) not supported" a b)))

;;  The old gcd and lcm algorithms
;;  which work only for non-negative fixnums

; from Algorithms, 2nd. Ed.
;      Sedgewick
;      p. 8

(define (raw-gcd u v)
  (if (< v u)
      (raw-gcd v u)
      (let loop ((u u) (v v))
	(if (eq? u 0)
	    v
	    (loop (remainder v u) u)))))

(define (raw-lcm x y)
  (let ((gcd (raw-gcd x y)))
    (if (eq? gcd 0)
	0
	(quotient (* x y) gcd))))

;; The generalized gcd and lcm algorithms
;; Date: Sat, 04 Jun 1994 21:13:15 -0500
;; From: Jun Sawada <sawada@cs.utexas.edu>

(define (gcd . args) 
  (cond ((not (pair? args)) 0)
	((not (pair? (cdr args)))
	 (if (number? (car args))
	     (abs (car args))
	     (error "gcd: num ~a is not a number." (car args))))
	(else
	 (let* ((return-inexact? #f)
		(normals
		 (map (lambda (x)
			(if (number? x)
			    (if (exact? x)
				(abs x)
				(let ((y (inexact->exact x)))
				  (set! return-inexact? #t)
				  (if (= (- y x) 0)
				      (abs y)
				      (error "gcd: num ~a is not an integer." 
					     x))))
			    (error "gcd: num ~a is not a number." x)))
		      args)))
	   (let loop ((first (car normals))
		      (rest (cdr normals)))
	     (if (pair? rest)
		 (loop (raw-gcd first (car rest)) (cdr rest))
		 (if return-inexact?
		     (exact->inexact first)
		     first)))))))

(define (lcm . args) 
  (cond ((not (pair? args)) 1)
	((not (pair? (cdr args)))
	 (if (number? (car args))
	     (abs (car args))
	     (error "lcm: num ~a is not a number." (car args))))
	(else
	 (let* ((return-inexact? #f)
		(normals
		 (map (lambda (x)
			(if (number? x)
			    (if (exact? x)
				(abs x)
				(let ((y (inexact->exact x)))
				  (set! return-inexact? #t)
				  (if (= (- y x) 0)
				      (abs y)
				      (error "lcm: num ~a is not an integer." x))))
				
			    (error "lcm: num ~a is not a number." x)))
		      args)))
	   (let loop ((first (car normals))
		      (rest (cdr normals)))
	     (if (pair? rest)
		 (loop (raw-lcm first (car rest)) (cdr rest))
		 (if return-inexact?
		     (exact->inexact first)
		     first)))))))

