#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/corelib/apply.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.6
 | File mod date:    1997.11.29 23:10:39
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  corelib
 |
 | Purpose:          apply and friends
 `------------------------------------------------------------------------|#

;; 
;;
;;  apply and similar functionality
;;

;; %%Documentation: apply
;; %%Usage: (apply func (optional: (sequence: arg)) arg-list)
;; 
;; %%Description
;; apply applies a function (procedure) to some arguments.
;; The arguments passed to the function are the optional
;; args followed by the contents of arg-list.

(define-glue (apply)
{
unsigned i, n;
obj proc;

    COUNT_ARGS_AT_LEAST(2);
    proc = REG0;
    
    n = expand_last() - 1;
    
    /* shift the registers, because we are removing the
       'proc' arg from REG0
       (might want to optimize this for smaller n's...) */
    
    for (i=0; i<n; i++)
	reg_set( i, reg_ref(i+1) );

    APPLY( n, proc );
})

(define-glue (apply-template)
{
unsigned i, n;
obj proc, tmpl;

    COUNT_ARGS_AT_LEAST(3);
    tmpl = REG0;
    proc = REG1;
    
    n = expand_last() - 2;
    
    /* shift the registers, because we are removing the
       'proc' arg from REG0
       (might want to optimize this for smaller n's...) */
    
    for (i=0; i<n; i++)
	reg_set( i, reg_ref(i+2) );

    APPLY_TMPL( n, proc, tmpl );
})

;; `standalone-template' is expecting to get clone'd and to have
;; it's first literal clobbered with a procedure, which this template
;; will call with two arguments: first, the function it was invoked
;; on behalf of, and second, a list of the arguments passed to it

(define-glue (standalone-template) :template
  literals: (#f)
{
obj caller = envt_reg;

   COLLECT0();
   REG1 = REG0;
   REG0 = caller;
   APPLY( 2, LITERAL(0) );
})

; APPLY* is analagous to apply, but is
; more efficient because the arguments don't have to be shifted
; (it takes the procedure argument as it's last argument,
;  rather than it's first)

(define-glue (apply*)
{
unsigned n;
obj proc;

    COUNT_ARGS_AT_LEAST(2);

    proc = reg_ref( --arg_count_reg );
    n = expand_last();
    
    APPLY( n, proc );
})

;; take a list and return the elements as multiple values

(define-glue (list->values)
{
unsigned n;

    n = expand_last();
    if (n == 0)
      RETURN0();
    else
      RETURN(n);
})

(define-syntax (values->list expr)
  (bind ((#rest rest expr)) rest))

;;

#| Documentation: (function identity)
 | Short: return it's only argument
 | Long: <<-+---
The identity function returns it's argument.
-+---
 |
 |#

(define (identity x)
  x)
