#OBJS = solaris.o
#LIBS = -lthread
#DIR_CPPFLAGS = $(OMNITHREAD_CPPFLAGS) -Kpic

OBJS = posix.o
LIBS = -lpthread -lposix4
DIR_CPPFLAGS = $(OMNITHREAD_CPPFLAGS) $(OMNITHREAD_POSIX_CPPFLAGS) -Kpic

all:: libomnithread.so.1.0

libomnithread.so.1.0: $(OBJS)
	(set -x; \
        $(RM) $@; \
        CC -G -o $@ -h libomnithread.so.1  $(OBJS) $(LIBS); \
       )

clean::
	$(RM) *.o core
	$(RM) libomnithread.so.1.0

install:: libomnithread.so.1.0
	@(set -x; \
          $(MKDIRHIER) $(LIBDIR); \
          $(CP) libomnithread.so.1.0 $(LIBDIR); \
          cd $(LIBDIR); \
          $(RM) libomnithread.so; \
          ln -s libomnithread.so.1 libomnithread.so; \
          $(RM) libomnithread.so.1; \
          ln -s libomnithread.so.1.0 libomnithread.so.1; \
         )


posix.o: ../posix.cc
	$(CXX) -c $< $(CXXFLAGS) -o $@ ../posix.cc

solaris.o: ../solaris.cc
	$(CXX) -c $(CXXFLAGS) -o $@ $< ../solaris.cc

