#include <time.h>
#include <stdlib.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <stdio.h>
#include "getline.h"

match(char *pattern, char *s) {
  return !strncmp(pattern, s, strlen(pattern));
}
matches_date(char *s) {
  return match("@text \\date{", s) && s[strlen(s)-2] == '}';
}
char *get_file_name(char *s) {
  char *p = (char *)malloc(strlen(s));  /* wastes some characters */
  assert(p);
  strcpy(p, s + strlen("@file "));
  p[strlen(p)-1] = 0;  /* trim newline */
  return p;
}
void print_modification_time(char *file) {
  struct stat buf;
  int n = stat(file, &buf);
  char *time;
  if (n) {fprintf(stderr, "could not stat %s\n", file); exit(1); }
  time = asctime(localtime(&buf.st_mtime));
  if (time[strlen(time)-1] == '\n') 
    time[strlen(time)-1] = 0;
  printf("@text \\date{%s}\\def\\today{%s}\n", time, time);
}
main() {
  char *s;
  char *file = NULL;
  while (s = getline(stdin)) 
    if (match("@file ", s)) {
      printf("%s", s);
      file = get_file_name(s);
    } else if (matches_date(s) && file != NULL) 
      print_modification_time(file);
    else
      printf("%s", s);
}
