/*
Copyright (c) 1996-1997 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: iluptypecpp.hpp,v 1.9 1997/09/16 00:18:16 janssen Exp $
*/

/* Encapsulates the C header iluptype.h in a C++ namespace. */

#ifndef __iluptypecpp_hpp_
#define __iluptypecpp_hpp_ 1

#include "cppportability.hpp"

extern "C" {
#include <stdio.h>    // For FILE (needed by iluptype.h)
}

/*
    The iluptype namespace defines wrapper functions to call functions declared in iluptype.h; the names are identical to those of the original functions, but with a preceeding underscore. Typedef names are identical to those of the original typedefs.
*/

#define __iluptypecpp_hpp_DEFINE_PROCS(INLINE)                                \
                                                                              \
  INLINE list _ParseFile (roString filename) {                                \
    return ParseFile(CONST_CAST(string, filename));                           \
  }                                                                           \
                                                                              \
  INLINE void _iluparser_ClearMarks () {                                      \
    iluparser_ClearMarks();                                                   \
  }                                                                           \
                                                                              \
  INLINE list _iluparser_new_list(void) {                                     \
    return iluparser_new_list();                                              \
  }                                                                           \
                                                                              \
  INLINE void _list_insert (list l, refany new_element) {                     \
    list_insert(l, new_element);                                              \
  }                                                                           \
                                                                              \
  INLINE boolean _list_remove (list l, refany element) {                      \
    return list_remove(l, element);                                           \
  }                                                                           \
                                                                              \
  INLINE void _list_clear (list l, boolean freeElements) {                    \
    list_clear(l, freeElements);                                              \
  }                                                                           \
                                                                              \
  INLINE void _list_enumerate (list l, iluparser_EnumProc proc, refany rock) {\
    list_enumerate(l, proc, rock);                                            \
  }                                                                           \
                                                                              \
  INLINE refany _list_find (list l, iluparser_FindProc proc, refany rock) {   \
    return list_find(l, proc, rock);                                          \
  }                                                                           \
                                                                              \
  INLINE void _list_push (list l, refany new_element) {                       \
    list_push(l, new_element);                                                \
  }                                                                           \
                                                                              \
  INLINE cardinal _list_size(list l) {                                        \
    return list_size(l);                                                      \
  }                                                                           \
                                                                              \
  INLINE refany _list_ref (list l, cardinal index) {                          \
    return list_ref(l, index);                                                \
  }                                                                           \
                                                                              \
  INLINE void _list_sort(list l, iluparser_CompareProc comp) {                \
    list_sort(l, comp);                                                       \
  }                                                                           \
                                                                              \
  INLINE TypeDescription _type_description (Type t) {                         \
    return type_description(t);                                               \
  }                                                                           \
                                                                              \
  INLINE TypeKind _type_kind (Type t) {                                       \
    return type_kind(t);                                                      \
  }                                                                           \
                                                                              \
  INLINE TypeKind _type_ur_kind(Type t) {                                     \
    return type_ur_kind(t);                                                   \
  }                                                                           \
                                                                              \
  INLINE void _name_set_base_name(Name n, roString name) {                    \
    name_set_base_name(n, CONST_CAST(string, name));                          \
  }                                                                           \
                                                                              \
  INLINE void _name_set_lang_name(Name n, roString lang, roString name) {     \
    name_set_lang_name(n, CONST_CAST(string, lang), CONST_CAST(string, name));\
  }                                                                           \
                                                                              \
  INLINE string _name_base_name(Name n) {                                     \
    return name_base_name(n);                                                 \
  }                                                                           \
                                                                              \
  INLINE string _name_lang_name(Name n, roString lang) {                      \
    return name_lang_name(n, CONST_CAST(string, lang));                       \
  }                                                                           \
                                                                              \
  INLINE Class _class_object(Type t) {                                        \
    return class_object(t);                                                   \
  }                                                                           \
                                                                              \
  INLINE TypeKind _type_basic_type(Type t) {                                  \
    return type_basic_type(t);                                                \
  }                                                                           \
                                                                              \
  INLINE Type _ur_type(Type t) {                                              \
    return ur_type(t);                                                        \
  }                                                                           \
                                                                              \
  INLINE string _type_uid(Type t) {                                           \
    return type_uid(t);                                                       \
  }                                                                           \
                                                                              \
  INLINE string _type_name(Type t) {                                          \
    return type_name(t);                                                      \
  }                                                                           \
                                                                              \
  INLINE Interface _type_interface(Type t) {                                  \
    return type_interface(t);                                                 \
  }                                                                           \
                                                                              \
  INLINE string _interface_name(Interface i) {                                \
    return interface_name(i);                                                 \
  }                                                                           \
                                                                              \
  INLINE string _argument_name(Argument a) {                                  \
    return argument_name(a);                                                  \
  }                                                                           \


#ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1, SunPro4.1 Compiler Note #2.

  extern "C" {
    #include <iluptype.h>
  }

  class iluptype { public:

    typedef ::boolean boolean;
    typedef ::cardinal cardinal;
    typedef ::refany refany;
    typedef ::listElement listElement;
    typedef ::list_s list_s;
    typedef ::list list;
    typedef ::name_s name_s;
    typedef ::Name Name;

    enum ArgDirection {
      In = ::In,
      Out = ::Out,
      InOut = ::InOut
    };

    typedef ::ilu_interface_s ilu_interface_s;
    typedef ::ilu_constantvalue_s ilu_constantvalue_s;

    typedef const char * roString;

    enum TypeKind {
      invalid_Type = ::invalid_Type,
      void_Type = ::void_Type,
      byte_Type = ::byte_Type,
      boolean_Type = ::boolean_Type,
      character_Type = ::character_Type,
      shortcharacter_Type = ::shortcharacter_Type,
      shortinteger_Type = ::shortinteger_Type,
      integer_Type = ::integer_Type,
      longinteger_Type = ::longinteger_Type,
      shortcardinal_Type = ::shortcardinal_Type,
      cardinal_Type = ::cardinal_Type,
      longcardinal_Type = ::longcardinal_Type,
      real_Type = ::real_Type,
      shortreal_Type = ::shortreal_Type,
      longreal_Type = ::longreal_Type,
      object_Type = ::object_Type,
      pipe_Type = ::pipe_Type,
      optional_Type = ::optional_Type,
      alias_Type = ::alias_Type,
      union_Type = ::union_Type,
      sequence_Type = ::sequence_Type,
      record_Type = ::record_Type,
      array_Type = ::array_Type,
      enumeration_Type = ::enumeration_Type
    };

    typedef ::LineNumber LineNumber;
    typedef ::Interface Interface;
    typedef ::Type Type;
    typedef ::Procedure Procedure;
    typedef ::Argument Argument;
    typedef ::TypeDescription TypeDescription;
    typedef ::Exception Exception;
    typedef ::Imported Imported;
    typedef ::ConstantValue ConstantValue;
    typedef ::EnumField EnumField;
	typedef ::Class Class;

    typedef ::iluparser_EnumProc iluparser_EnumProc;
    typedef ::iluparser_FindProc iluparser_FindProc;
    typedef ::iluparser_CompareProc iluparser_CompareProc;

    __iluptypecpp_hpp_DEFINE_PROCS(static);

  };  // class iluptype

#else

  namespace iluptype {

    extern "C" {
      #include <iluptype.h>
    }

	typedef const char * roString;

    __iluptypecpp_hpp_DEFINE_PROCS(inline);

  };  // namespace iluptype

#endif  // __SUNPRO_CC



#endif  // __iluptypecpp_hpp_



/*
    SunPro4.1 Compiler Note #1 - The SunPro compiler does not support namespaces, so instead we use a class to simulate a namespace. Members of the class can be accessed as if it were a namespace using explicit qualification (ie, prefixed by "<class_name>::"). Of course, one cannot apply "using" directives to classes, so all accesses must use "fully qualified" names.

    SunPro4.1 Compiler Note #2 - We cannot #include iluptype.h within a class declaration (external function definitions are not allowed inside a class); instead, we must #include it "globally". This has the unfortunate effect of leaking names outside of the "namespace"; however, SunPro clients of this header file can still acheive portability to other compilers by accessing all iluptype names through the iluptype "namespace" (ie, the iluptype class).
*/
