/*
Copyright (c) 1996-1997 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: cppgen.hpp,v 1.20 1997/09/10 17:41:04 srjohnso Exp $
*/

#ifndef _cppgen_hpp_
#define _cppgen_hpp_ 1


// G++2.7.1 Compiler Note #1

#ifdef __GNUC__  // G++2.7.1 Compiler Note #2
#pragma interface "cppgen.hpp"
#endif  // __GNUC__

#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
#pragma warning(disable: 4250)
#endif  // _MSC_VER

#include "cppparse.hpp"
#include "cppparsestream.hpp"
#include "cppparsename.hpp"
#include "cppportability.hpp"


template <class T, class FROM, class PARSET>
class CppGen_FactoryT: public CppParse_FactoryT<PARSET, FROM> {
  public:
    static CppGen_FactoryT<T, FROM, PARSET> * current () {
      return _current;}
    static void set (CppGen_FactoryT<T, FROM, PARSET> * f) {
      _current = (f == NULL) ? &_default : f;}
    static void post () {
      CppParse_FactoryT<PARSET, FROM>::set(current());
      }
  private:
    virtual PARSET * _create (FROM) const;
    virtual void _destroy (PARSET *) const;
  private:
    static CppGen_FactoryT<T, FROM, PARSET> * _current;
    static CppGen_FactoryT<T, FROM, PARSET> _default;
};


#define CppGen_(name) NAME_INSIDE_SCOPE(CppGen, name)
#define CppGen(name) NAME_OUTSIDE_SCOPE(CppGen, name)

BEGIN_NAMESPACE(CppGen)


    NS_EXTERN CppParseStream(DynOutProc) *
    CppGen_(herald) (const char * executable, const char * isl);

    
    enum CppGen_(InterfaceScopingMode) {
        CppGen_(interfacePortable),
        CppGen_(namespaces),
        CppGen_(classes),
        CppGen_(underscores)
    };
    
    enum CppGen_(TemplateStaticMode) {
        CppGen_(templateStaticPortable),
        CppGen_(staticStorage),
        CppGen_(empty)
    };
    
    enum CppGen_(BoolMode) {
        CppGen_(boolPortable),
        CppGen_(boolType),
        CppGen_(integers)
    };
    
    enum CppGen_(CastMode) {
        CppGen_(castPortable),
        CppGen_(cppCast),
        CppGen_(cCast)
    };
    
    
    class CppGen_(Namespace) {

    public:

        static
        CppParseStream(DynOutProc) *
        open (const char * nsName);

        static
        CppParseStream(DynOutProc) *
        close (const char * nsName);

        static
        CppParseStream(DynOutProc) *
        declareExtern ();

        static
        CppGen(InterfaceScopingMode) mode;

    private:

        static
        CppParseStream(ofstream)&
        doOpen (CppParseStream(ofstream)& ofs);
        
        static
        CppParseStream(ofstream)&
        doClose (CppParseStream(ofstream)& ofs);
        
        static
        CppParseStream(ofstream)&
        doDeclareExtern (CppParseStream(ofstream)& ofs);

        static
        const char * name;
    };
    
    class CppGen_(TemplateStatic) {
    public:

        static
        CppParseStream(DynOutProc) *
        declareStatic ();

        static
        CppGen_(TemplateStaticMode) mode;

    private:

        static
        CppParseStream(ofstream)&
        doDeclareStatic (CppParseStream(ofstream)& ofs);

    };
    
    class CppGen_(Bool): private CppParse(Bool) {

    public:
        static
        CppParseStream(DynOutProc) *
        value (ILUCPP_BOOL);
        
        static
        CppParseStream(DynOutProc) *
        type ();

        static
        CppGen_(BoolMode)
        mode;

        static
        void
        post ();

    private:

        static CppParseStream(ofstream)&
        doValue (CppParseStream(ofstream)& ofs);
        
        static CppParseStream(ofstream)&
        doType (CppParseStream(ofstream)& ofs);

    private:  // Overrided functions for CppParse::Bool

        const char *
        _trueValue ();

        const char *
        _falseValue ();
        
    private:
        static
        ILUCPP_BOOL val;
    };


    class CppGen_(Cast): public CppParseStream(DynOutObj) {
        
    public:

        static
        CppParseStream(DynOutProc) *
        staticCast (const char * type, const char * expression = NULL);

        static
        CppParseStream(DynOutProc) *
        reinterpretCast (const char * type, const char * expression = NULL);

        static
        CppParseStream(DynOutProc) *
        constCast (const char * type, const char * expression = NULL);

        static CppGen_(CastMode)
        mode;

    private:
        static
        CppParseStream(ofstream)&
        doStaticCast (CppParseStream(ofstream)& ofs);
        
        static
        CppParseStream(ofstream)&
        doReinterpretCast (CppParseStream(ofstream)& ofs);
        
        static
        CppParseStream(ofstream)&
        doConstCast (CppParseStream(ofstream)& ofs);
        
        static const char * type;
        static const char * expression;
    };
    
    
    NS_EXTERN const CppParseName(Key) CppGen_(true_key);
    NS_EXTERN const CppParseName(Key) CppGen_(surrogate_key);
    NS_EXTERN const CppParseName(Key) CppGen_(underscore_key);
    NS_EXTERN const CppParseName(Key) CppGen_(period_key);
    NS_EXTERN const CppParseName(Key) CppGen_(parm_out_key);
    NS_EXTERN const CppParseName(Key) CppGen_(wrapper_key);
    NS_EXTERN const CppParseName(Key) CppGen_(parm_length_key);
    NS_EXTERN const CppParseName(Key) CppGen_(parm_ptr_key);
    NS_EXTERN const CppParseName(Key) CppGen_(parm_var_key);
    NS_EXTERN const CppParseName(Key) CppGen_(parm_slice_key);
    NS_EXTERN const CppParseName(Key) CppGen_(instance_key);
        // Record, Union, Array, or Sequence instance name
    NS_EXTERN const CppParseName(Key) CppGen_(member_key);
        // Record or Union data member instance name
        // Within scope of record/union => <member name>
        // Outside scope of record/union => <record/union name>.<member name>
    NS_EXTERN const CppParseName(Key) CppGen_(accessor_key);
        // Union function member corresponding to ISL member
        // Within scope of union => <accessor name>
        // Outside scope of union => <union name>.<accessor name>
    NS_EXTERN const CppParseName(Key) CppGen_(element_key);
        // Array or Sequence element instance name
    NS_EXTERN const CppParseName(Key) CppGen_(val_key);
        // Value pointed to by an Optional


    #define _cppgen_hpp_DYNOUT_METHOD(OBJECT, METHOD)   \
      private:                                          \
        CppParseStream(ofstream) &                      \
          _ ## METHOD (CppParseStream(ofstream) & ofs); \
      public:                                           \
        virtual CppParseStream(DynOutSrc)               \
          METHOD () const {                             \
            CppParseStream(DynOutSrc) rtn = {           \
	      this,                                         \
	      STATIC_CAST(                                  \
                CppParseStream(DynOutMethod),           \
                &CppGen_(OBJECT)::_ ## METHOD)          \
	    };                                              \
	    return rtn;                                     \
	  }


    class CppGen_(NamedValue);
    class CppGen_(Parameter);
    class CppGen_(Argument);
    class CppGen_(ReturnVal);
    class CppGen_(Array);
    class CppGen_(Record);
    class CppGen_(Union);
    class CppGen_(UnionArm);
    class CppGen_(Optional);
    class CppGen_(Alias);
    class CppGen_(Sequence);  // TMP 9/9: NEW
    class CppGen_(Interface);
    
    class CppGen_(Type): public virtual CppParse(Type), public CppParseStream(DynOutObj) {

        friend CppGen_FactoryT<CppGen_(Type), ::iluptype::Type, CppParse(Type)>;
        friend CppGen_(NamedValue);
        friend CppGen_(Parameter);
        friend CppGen_(Array);
        friend CppGen_(Sequence);  // TMP 9/9: NEW
        friend CppGen_(Record);
        friend CppGen_(Union);
        friend CppGen_(UnionArm);
        friend CppGen_(Optional);
        friend CppGen_(Alias);
        friend CppGen_(Interface);
        CppParseNarrow_FUNCS1(CppGen_(Type), CppParse(Type));

    public:
        virtual ILUCPP_BOOL needsSurrogateSideCleanup () const;
            // true => this type is an object, or one of its members/elements contains an object
            // CppGen::Type returns false

        virtual ILUCPP_BOOL needsPostTrueMethodRevise (CppParseName(TypeUsage)) const;
            // true => Parameters of this type and usage require processing
            // after completion of method on true object.
            // CppGen::Type returns false.
            // (Currently used only for optional wrappers, but could be more generally
            // usefull if other wrappers/_var's were changed.

    public:  /////////////// common header file
        _cppgen_hpp_DYNOUT_METHOD(Type, commonDefForward);
        // forward declarations and related typedefs for this Type, if any
        _cppgen_hpp_DYNOUT_METHOD(Type, commonDef);
        // declaration(s)/definition(s) related to this Type.
        _cppgen_hpp_DYNOUT_METHOD(Type, commonDefIOOperators);
        // input/output operators for this type

    public:  /////////////// common cpp file
        _cppgen_hpp_DYNOUT_METHOD(Type, commonImpl);
        // methods and/or other defintions for this Type

    protected:  /////////////// support for Parameter stream output methods
        // TEMP: These methods are in lieu of deriving Parameter from Type;
        // see comments on similarly-named NamedValue methods
        virtual void sizing (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void send (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void receive (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void surrogateCleanup (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void surrogatePreProcessing (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
        virtual void initialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
        virtual void optionalInitialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 6/28: NEW
        virtual void surrogateReceive (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
            // calls receive
        virtual void initialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
        virtual void optionalInitialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 6/28: NEW
        virtual void trueReceive (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
            // calls surrogateReceive
        virtual void truePassToTrueMethod (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
        virtual void truePostTrueMethodProcessing (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;

	// type registration
	virtual void registerType (CppParseStream(ofstream) &) const;

    public:  /////////////// support for Parameter stream output methods  // TMP 5/23: NEW
        // TEMP: These methods are meant to be analogous to those above, with
        // similarly-named NamedValue methods; however, for the time being, we
        // just call these directly (thus, they are public).

        virtual void assignValue (const char * to, const char * from, CppParseStream(ofstream) &) const;
            // Deep copy the value of the second argument to the first argument,
            // assuming "to" is of the C++ RECORD member mapping for this Type
		    // (or will automatically convert to it), and "from" is of the C++ "IN" mapping
		    // for this Type (or will automatically convert to it).
            // Usually just "arg1 = arg2", but may be more elaborate for pointer types.

        virtual void optionalAssignValue (const char * to, const char * from, CppParseStream(ofstream) &) const;
            // Deep copy the value of the second argument to the first argument,
            // assuming "to" is of the C++ RECORD member mapping for an Optional of this Type
		    // (or will automatically convert to it), and "from" is of the C++ "IN" mapping
		    // for an Optional of this Type (or will automatically convert to it).

    protected:  /////////////// support for Union stream output methods

        virtual void unionArmSetDefs (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;
            // Declaration of accessor function(s) for setting union member of this Type.

        virtual void unionArmGetDefs (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;
            // Declaration of accessor function(s) for getting union member of this Type.

        virtual void unionArmSetImpls (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;
            // Implementation of accessor function(s) for setting union member of this Type.

        virtual void unionArmGetImpls (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;
            // Implementation of accessor function(s) for getting union member of this Type.

        virtual ILUCPP_BOOL unionDataMemberIsVar () const;
            // True => Union data members for this type are stored as pointer to _var.
		    // Used when: 1) generating C++ union member; 2) generating default set/get functions

    protected:  /////////////// support for Alias stream output methods

        virtual void aliasCommonDefForward (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Typedef(s) for an Alias for this Type.

        virtual void aliasCommonDef (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Function definitions (if any) for an Alias for this Type.

    protected:  /////////////// support for Optional stream output methods

        virtual void optionalCommonDefForward (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Typedef(s) for an Optional for this Type.

    protected:
        CppGen_(Type) (::iluptype::Type from);
    };



    #define _cppgen_hpp_DEF_SCALAR_TYPE(T, FROM, UNUSED1, UNUSED2, UNUSED3) \
        class CppGen_(T): public CppGen_(Type), public CppParse(T) {        \
            friend CppGen_FactoryT<CppGen_(T), FROM, CppParse(T)>;          \
            CppParseNarrow_FUNCS2(CppGen_(T), CppGen_(Type), CppParse(T));  \
            protected:                                                      \
                CppGen_(T) (FROM from)                                      \
                  : CppParse(Type)(from),                                   \
                    CppGen_(Type)(from),                                    \
                    CppParse(T)(from),                                      \
                    CppParseName(TypeName)(from),                           \
                    CppParseName(Name)(from) {                              \
                    };                                                      \
        };

/* TMP 7/20
    #define _cppgen_hpp_DEF_CORBA_SCALAR_TYPE(T, FROM, UNUSED1, UNUSED2, UNUSED3)                         \
        class CppGen_(T): public CppGen_(Type), public CppParse(T) {                                      \
            friend CppGen_FactoryT<CppGen_(T), FROM, CppParse(T)>;                                        \
            CppParseNarrow_FUNCS2(CppGen_(T), CppGen_(Type), CppParse(T));                                \
        public:   Override CppParseName::TypeName method                                              
            virtual const char * simpleName (CppParseName(TypeUsage)) const;                             
        public:   Reintroduce CppParseName::TypeName::simpleName (otherwise, above version hides it)  

            virtual const char * simpleName (CppParseName_(Key) key = NULL) const {                       \
                return CppParseName(TypeName)::simpleName(key);                                           \
            };                                                                                            \
        protected:                                                                                        \
            CppGen_(T) (FROM from)                                                                        \
              : CppParse(Type)(from),                                                                     \
                CppGen_(Type)(from),                                                                      \
                CppParse(T)(from),                                                                        \
                CppParseName(TypeName)(from),                                                             \
                CppParseName(Name)(from) {                                                                \
                };                                                                                        \
        };

    #define _cppgen_hpp_DEF_NON_CORBA_SCALAR_TYPE(T, FROM, UNUSED1, UNUSED2, UNUSED3) \
        class CppGen_(T): public CppGen_(Type), public CppParse(T) {                  \
            friend CppGen_FactoryT<CppGen_(T), FROM, CppParse(T)>;                    \
            CppParseNarrow_FUNCS2(CppGen_(T), CppGen_(Type), CppParse(T));            \
        protected:                                                                    \
            CppGen_(T) (FROM from)                                                    \
              : CppParse(Type)(from),                                                 \
                CppGen_(Type)(from),                                                  \
                CppParse(T)(from),                                                    \
                CppParseName(TypeName)(from),                                         \
                CppParseName(Name)(from) {                                            \
                };                                                                    \
        };
*/


    CppParse_ENUMERATE_SCALAR_TYPES(_cppgen_hpp_DEF_SCALAR_TYPE)
/* TMP 7/20
    CppParse_ENUMERATE_CORBA_SCALAR_TYPES(_cppgen_hpp_DEF_CORBA_SCALAR_TYPE)
    CppParse_ENUMERATE_NON_CORBA_SCALAR_TYPES(_cppgen_hpp_DEF_NON_CORBA_SCALAR_TYPE)
*/

    class CppGen_(Exception);
            
    class CppGen_(NamedValue): public virtual CppParse(NamedValue), public CppParseStream(DynOutObj) {
        friend CppGen_(Exception);

    public:
        _cppgen_hpp_DYNOUT_METHOD(NamedValue, initialDeclsInput);
            // Declarations related to this value when used for input (from wire)
        _cppgen_hpp_DYNOUT_METHOD(NamedValue, initialDeclsOutput);
            // Declarations related to this value when used for output (to wire)
        _cppgen_hpp_DYNOUT_METHOD(NamedValue, sizing);
            // increment "size" of call by size of this value
        _cppgen_hpp_DYNOUT_METHOD(NamedValue, send);
            // send this value
        _cppgen_hpp_DYNOUT_METHOD(NamedValue, receive);
            // receive this value

    public:  // override CppParseName::Name methods
        virtual const char * simpleName (CppParseName(Key) = NULL) const;

    protected:  // Constructors
        CppGen_(NamedValue) (::iluptype::Procedure);
            // Procedure return value
        CppGen_(NamedValue) (::iluptype::Argument);
            // Procedure argument
        CppGen_(NamedValue) (::iluptype::Argument, CppParseName(TypeUsage));
            // Record & union members
        CppGen_(NamedValue) (const CppGen_(Array) *);
            // Array elements
        CppGen_(NamedValue) (const CppGen_(Sequence) *);  // TMP 9/9: NEW
            // Sequence elements
        CppGen_(NamedValue) (const ::iluptype::Exception);
            // Exceptions
        CppGen_(NamedValue) (const CppParseName(Name)&, CppParseName(TypeUsage), const CppGen_(Type) *);
            // Generic.
    };

    
    class CppGen_(Member): public CppGen_(NamedValue), public CppParse(Member) {
      friend class CppGen_FactoryT<CppGen_(Member), ::iluptype::Argument, CppParse(Member)>;
      CppParseNarrow_FUNCS1(CppGen_(Member), CppParse(Member));
      protected:
        CppGen_(Member) (::iluptype::Argument from);
    };


    class CppGen_(Enumerator): public CppParse(Enumerator) {
      friend class CppGen_FactoryT<CppGen_(Enumerator), ::iluptype::EnumField, CppParse(Enumerator)>;
      CppParseNarrow_FUNCS1(CppGen_(Enumerator), CppParse(Enumerator));
      protected:
        CppGen_(Enumerator) (::iluptype::EnumField from);
    };


    class CppGen_(Enumeration): public CppGen_(Type), public CppParse(Enumeration) {
      friend class CppGen_FactoryT<CppGen_(Enumeration), ::iluptype::Type, CppParse(Enumeration)>;
      CppParseNarrow_FUNCS2(CppGen_(Enumeration), CppGen_(Type), CppParse(Enumeration));
      public:  /////////////// common header file
        _cppgen_hpp_DYNOUT_METHOD(Enumeration, commonDefForward);
            // forward declaration
        _cppgen_hpp_DYNOUT_METHOD(Enumeration, commonDef);
          // enumeration definition
      public:  // Override CppGen::Type methods
          virtual void sizing (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
          virtual void send (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
          virtual void receive (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
          virtual void initialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
          virtual void optionalInitialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 8/9: NEW
          virtual void initialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
          virtual void optionalInitialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 8/9: NEW
          virtual void truePassToTrueMethod (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
	// type registration
	virtual void registerType (CppParseStream(ofstream) &) const;

    protected:  /////////////// support for Optional stream output methods

        virtual void optionalCommonDefForward (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Typedef(s) for an Optional for this Enumeration type.

      protected:
          CppGen_(Enumeration) (::iluptype::Type from);
    };


    class CppGen_(SequenceElement): public CppGen_(NamedValue) {  // TMP 9/9: NEW
        friend CppGen_(Sequence);
    public:  // override CppParseName::Name methods
        virtual const char * simpleName (CppParseName(Key) = NULL) const;
    protected:
        CppGen_(SequenceElement) (const CppGen_(Sequence) *);
    private:
        const CppGen_(Sequence) * _sequence;
    };

    enum CppGen_(IOOp) {
        CppGen_(size),
        CppGen_(input),
        CppGen_(output)
    };

    class CppGen_(Sequence): public CppGen_(Type), public virtual CppParse(Sequence) {
        friend class CppGen_FactoryT<CppGen_(Sequence), ::iluptype::Type, CppParse(Sequence)>;
        CppParseNarrow_FUNCS2(CppGen_(Sequence), CppGen_(Type), CppParse(Sequence));

    public:  // TMP 9/9: NEW
        #ifdef _MSC_VER  // MSVC4.1 Compiler Note #2
            CppGen_(SequenceElement) element;
        #else
            const CppGen_(SequenceElement) element;
        #endif  // _MSC_VER

    private:  
        virtual ILUCPP_BOOL needVarBuffer () const;
        _cppgen_hpp_DYNOUT_METHOD(Sequence, dataElementType);
        void outputIOOpImpl (CppGen_(IOOp), CppParseStream(ofstream)&) const;

    public:  // Override CppGen::Type method
        virtual ILUCPP_BOOL needsSurrogateSideCleanup () const;

    public:  // Override CppGen::Type methods
        virtual void sizing (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void send (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void receive (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void surrogateCleanup (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void initialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
        virtual void optionalInitialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 8/9: NEW
        virtual void initialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
        virtual void optionalInitialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 8/9: NEW
	// type registration
	virtual void registerType (CppParseStream(ofstream) &) const;

    public:  /////////////// common header file
        _cppgen_hpp_DYNOUT_METHOD(Sequence, commonDefForward);
            // forward declarations and related typedefs
        _cppgen_hpp_DYNOUT_METHOD(Sequence, commonDef);
            // struct definition
        _cppgen_hpp_DYNOUT_METHOD(Sequence, commonDefIOOperators);
            // input/output operations on this record

    public:  /////////////// common cpp file
        _cppgen_hpp_DYNOUT_METHOD(Sequence, commonImpl);
            // constructors, destructors, input/output operators

    protected:  /////////////// support for Union members of typekind Sequence  // TMP 9/1: NEW

        virtual ILUCPP_BOOL unionDataMemberIsVar () const;  // TMP 9/1: NEW

    protected:  /////////////// support for Alias stream output methods

        virtual void aliasCommonDefForward (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Typedef(s) for an Alias for this Sequence.


    protected:  /////////////// support for Optional stream output methods

        virtual void optionalCommonDefForward (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Typedef(s) for an Optional for this Sequence type.

    protected:
        CppGen_(Sequence) (::iluptype::Type from);
/* TMP 7/4
    private:
        const ILUCPP_BOOL _containsObjects;
*/
    };


    class CppGen_(ObjectSequence): public CppGen_(Sequence), public CppParse(ObjectSequence) {
        friend class CppGen_FactoryT<CppGen_(ObjectSequence), ::iluptype::Type, CppParse(ObjectSequence)>;
        CppParseNarrow_FUNCS2(CppGen_(ObjectSequence), CppGen_(Sequence), CppParse(ObjectSequence));

    private:  // Override CppGen::Sequence methods
        virtual ILUCPP_BOOL needVarBuffer () const;
        _cppgen_hpp_DYNOUT_METHOD(ObjectSequence, dataElementType);

    protected:
        CppGen_(ObjectSequence) (::iluptype::Type from);
    };


    class CppGen_(StringSequence): public CppGen_(Sequence), public CppParse(StringSequence) {
        friend class CppGen_FactoryT<CppGen_(StringSequence), ::iluptype::Type, CppParse(StringSequence)>;
        CppParseNarrow_FUNCS2(CppGen_(StringSequence), CppGen_(Sequence), CppParse(StringSequence));

    private:  // Override CppGen::Sequence methods
        virtual ILUCPP_BOOL needVarBuffer () const;
// TMP 9/9        _cppgen_hpp_DYNOUT_METHOD(StringSequence, dataElementType);

    protected:
        CppGen_(StringSequence) (::iluptype::Type from);
    };


    class CppGen_(WideStringSequence): public CppGen_(Sequence), public CppParse(WideStringSequence) {
        friend class CppGen_FactoryT<CppGen_(WideStringSequence), ::iluptype::Type, CppParse(WideStringSequence)>;
        CppParseNarrow_FUNCS2(CppGen_(WideStringSequence), CppGen_(Sequence), CppParse(WideStringSequence));

    private:  // Override CppGen::Sequence methods
        virtual ILUCPP_BOOL needVarBuffer () const;
// TMP 9/9        _cppgen_hpp_DYNOUT_METHOD(WideStringSequence, dataElementType);

    protected:
        CppGen_(WideStringSequence) (::iluptype::Type from);
    };


    class CppGen_(String): public CppGen_(Type), public CppParse(String) {
        friend class CppGen_FactoryT<CppGen_(String), ::iluptype::Type, CppParse(String)>;
        CppParseNarrow_FUNCS2(CppGen_(String), CppGen_(Type), CppParse(String));

    public:  // Override method from CppParse::String
        virtual const char * simpleName (CppParseName(TypeUsage)) const;

    public:  // Override CppGen::Type methods
        virtual ILUCPP_BOOL needsPostTrueMethodRevise (CppParseName(TypeUsage)) const;
        virtual void sizing (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void send (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void receive (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void initialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
        virtual void optionalInitialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 6/28: NEW
        virtual void initialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
        virtual void optionalInitialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 6/28: NEW
        virtual void truePassToTrueMethod (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
        virtual void truePostTrueMethodProcessing (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
        virtual void optionalAssignValue (const char *, const char *, CppParseStream(ofstream) &) const;  // TMP 9/9: NEW

    public:  /* Override method from CppParseName::TypeName */
        const char * usageName (CppParseName(TypeUsage), const CppParseName(Scope) * context = NULL) const;

	protected:  /////////////// support for Union arms of typekind String

        virtual void unionArmSetDefs (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;  // TMP 9/4: NEW
        virtual void unionArmGetDefs (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;  // TMP 9/4: NEW
        virtual void unionArmSetImpls (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;  // TMP 9/4: NEW
        virtual void unionArmGetImpls (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;  // TMP 9/4: NEW
        virtual ILUCPP_BOOL unionDataMemberIsVar () const;  // TMP 9/1: NEW

    protected:  /////////////// support for Optional stream output methods

        virtual void optionalCommonDefForward (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Typedef(s) for an Optional for this string type.

    protected:
        CppGen_(String) (::iluptype::Type from);
    };


    class CppGen_(WideString): public CppGen_(Type), public CppParse(WideString) {
        friend class CppGen_FactoryT<CppGen_(WideString), ::iluptype::Type, CppParse(WideString)>;
        CppParseNarrow_FUNCS2(CppGen_(WideString), CppGen_(Type), CppParse(WideString));

    public:  // Override method from CppParse::String
        virtual const char * simpleName (CppParseName(TypeUsage)) const;

    public:  // Override CppGen::Type methods
        virtual ILUCPP_BOOL needsPostTrueMethodRevise (CppParseName(TypeUsage)) const;
        virtual void sizing (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void send (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void receive (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void initialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
        virtual void optionalInitialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 6/28: NEW
        virtual void initialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
        virtual void optionalInitialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 6/28: NEW
        virtual void truePassToTrueMethod (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
        virtual void truePostTrueMethodProcessing (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
        virtual void optionalAssignValue (const char *, const char *, CppParseStream(ofstream) &) const;  // TMP 9/9: NEW

    protected:  /////////////// support for Union arms of typekind WideString

        virtual void unionArmSetDefs (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;  // TMP 9/4: NEW
        virtual void unionArmGetDefs (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;  // TMP 9/4: NEW
        virtual void unionArmSetImpls (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;  // TMP 9/4: NEW
        virtual void unionArmGetImpls (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;  // TMP 9/4: NEW
        virtual ILUCPP_BOOL unionDataMemberIsVar () const;  // TMP 9/1: NEW

    protected:  /////////////// support for Optional stream output methods

        virtual void optionalCommonDefForward (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Typedef(s) for an Optional for this string type.

    protected:
        CppGen_(WideString) (::iluptype::Type from);
    };


    class CppGen_(Record): public CppGen_(Type), public virtual CppParse(Record) {
        friend class CppGen_FactoryT<CppGen_(Record), ::iluptype::Type, CppParse(Record)>;
        CppParseNarrow_FUNCS2(CppGen_(Record), CppGen_(Type), CppParse(Record));
        
    public:  // Override CppGen::Type method
        virtual ILUCPP_BOOL needsSurrogateSideCleanup () const;

    public:  /////////////// common header file
        _cppgen_hpp_DYNOUT_METHOD(Record, commonDefForward);
        // forward declarations and related typedefs
        _cppgen_hpp_DYNOUT_METHOD(Record, commonDef);
        // struct definition
        _cppgen_hpp_DYNOUT_METHOD(Record, commonDefIOOperators);
        // input/output operations on this record

    public:  /////////////// common cpp file
        _cppgen_hpp_DYNOUT_METHOD(Record, commonImpl);
        // constructors, destructors, input/output operators

    public:  // Override CppGen::Type methods
        virtual void sizing (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void send (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void surrogateCleanup (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void initialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
        virtual void optionalInitialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 8/9: NEW
        virtual void surrogateReceive (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
        virtual void initialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
        virtual void optionalInitialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 8/9: NEW
        virtual void trueReceive (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;

    protected:  /////////////// support for Union members of typekind Record  // TMP 9/1: NEW

        virtual ILUCPP_BOOL unionDataMemberIsVar () const;  // TMP 9/1: NEW

    protected:  /////////////// support for Optional stream output methods

        virtual void optionalCommonDefForward (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Typedef(s) for an Optional for this Record type.

	// type registration
	virtual void registerType (CppParseStream(ofstream) &) const;

    public:  // Disambiguate functions inherited from Type::Name and Record::Name
        const char *
            name (const CppParseName(Scope) * context = NULL) const {
            return CppGen_(Type)::name(context);
        };
        const char *
            name (CppParseName(Key) key, const CppParseName(Scope) * context = NULL) const {
            return CppGen_(Type)::name(key, context);
        };
        const char *
            localName (CppParseName(Key) key = NULL) const {
            return CppGen_(Type)::localName(key);
        };
        const CppParseName(Scope) *
            scope() const {
            return CppGen_(Type)::scope();
        };
	private:  // override CppParseName::Scope methods
        virtual CppParseName(ContinuationFlag)
			qualify (const char * n, const char ** qn, CppParseName(Key) key, const CppParseName(Scope) * context) const;
        virtual CppParseName(ContinuationFlag)
			qualifyLocal (const char * n, const char ** qn, CppParseName(Key) key) const;
/* TMP 7/4
    private:
        const ILUCPP_BOOL _containsObjects;
*/
    public:  // override CppParseName::Name methods
		const char * simpleName (CppParseName(Key) = NULL) const;
    protected:
        CppGen_(Record) (::iluptype::Type from);
/* TMP 7/21: we don't really need these !
    public:  // TMP 7/20
        static CppParse(Record) * make (::iluptype::Type from) {return new(from) CppGen_(Record)(from);};  // TMP 7/20: NEW
        static CppParse(Record) * convert (void * buf) {return STATIC_CAST(CppGen_(Record)*, buf);};  // TMP 7/20: NEW
*/
    };


  class CppGen_(ConstantValue): public CppParse(ConstantValue) {
      CppParseNarrow_FUNCS1(CppGen_(ConstantValue), CppParse(ConstantValue));	  
      friend class CppGen_FactoryT<CppGen_(ConstantValue), ::iluptype::ConstantValue, CppParse(ConstantValue)>;
  protected:
      CppGen_(ConstantValue) (::iluptype::ConstantValue);
  };


  class CppGen_(UnionArm): public CppGen_(NamedValue), public CppParse(UnionArm) {
      CppParseNarrow_FUNCS1(CppGen_(UnionArm), CppParse(UnionArm));
      friend class CppGen_FactoryT<CppGen_(UnionArm), ::iluptype::Argument, CppParse(UnionArm)>;

    public:
        _cppgen_hpp_DYNOUT_METHOD(UnionArm, setDefs);
            // Declaration of accessor function(s) for setting value of this arm.
        _cppgen_hpp_DYNOUT_METHOD(UnionArm, getDefs);
            // Declaration of accessor function(s) for getting value of this arm.
        _cppgen_hpp_DYNOUT_METHOD(UnionArm, setImpls);
            // Implementation of accessor function(s) for setting value of this arm.
        _cppgen_hpp_DYNOUT_METHOD(UnionArm, getImpls);
            // Implementation of accessor function(s) for getting value of this arm.

/* TMP 8/28
    public:  // Disambiguate methods inherited from CppGen::NamedValue and CppParse::UnionArm
        virtual const char * simpleName (CppParseName(Key) key = NULL) const {
			return CppParse(UnionArm)::simpleName(key);
		};
TMP 8/28 */

  protected:
      CppGen_(UnionArm) (::iluptype::Argument);
  };


  class CppGen_(Union);

  typedef void (CppGen_(Union)::*CppGen_(UnionDiscriminatorSwitchAction))
      (const CppGen_(UnionArm)*, CppParseStream(ofstream)&) const;
      // CppGen::UnionDiscriminatorSwitchAction is a typedef for a
      // pointer-to-Union-member-function (ie, a pointer referring to
      // a member function in the CppGen::Union class, which has the
      // signature indicated). Used to pass a call-back method when
      // generating C++ switch-statements.


  class CppGen_(Union): public CppGen_(Record), public CppParse(Union) {
      CppParseNarrow_FUNCS2(CppGen_(Union), CppGen_(Record), CppParse(Union));
      friend class CppGen_FactoryT<CppGen_(Union), ::iluptype::Type, CppParse(Union)>;

  public:  /////////////// common header file
      _cppgen_hpp_DYNOUT_METHOD(Union, commonDefForward);
      // forward declarations and related typedefs
      _cppgen_hpp_DYNOUT_METHOD(Union, commonDef);
      // class definition
      
  public:  /////////////// common cpp file
      _cppgen_hpp_DYNOUT_METHOD(Union, commonImpl);
      // constructors, destructors, accessors, input/output operators

  public:  // override CppParseName::Name method
      const char * simpleName (CppParseName(Key) = NULL) const;
      
	// type registration
	virtual void registerType (CppParseStream(ofstream) &) const;

  protected:
      CppGen_(Union) (::iluptype::Type from);

  private:  // Selecting on discriminant

      void discriminatorSwitch (
          CppGen_(UnionDiscriminatorSwitchAction) genCase,
          const char * discriminatorName,
          CppParseStream(ofstream)&) const;
      // Generates a C++ switch on descriminatorName, with cases
      // corrsponding to the UnionArm values. genCase is a call-back
      // method that will generate the body of each case. The call-backs
      // are defined below.

      void assignmentCase (const CppGen_(UnionArm)*, CppParseStream(ofstream)&) const;
      void discriminatorSetAccessorCase (const CppGen_(UnionArm)*, CppParseStream(ofstream)&) const;
      void surrogateSideCleanupCase (const CppGen_(UnionArm)*, CppParseStream(ofstream)&) const;
      void unsetCase (const CppGen_(UnionArm)*, CppParseStream(ofstream)&) const;
      void sizingCase (const CppGen_(UnionArm)*, CppParseStream(ofstream)&) const;
      void sendCase (const CppGen_(UnionArm)*, CppParseStream(ofstream)&) const;
      void receiveCase (const CppGen_(UnionArm)*, CppParseStream(ofstream)&) const;

      void outputIOOpImpl (CppGen_(IOOp), CppParseStream(ofstream)&) const;


    public:  // TMP 7/20
        static CppParse(Union) * make (::iluptype::Type from) {return new(from) CppGen_(Union)(from);};  // TMP 7/20: NEW
        static CppParse(Union) * convert (void * buf) {return STATIC_CAST(CppGen_(Union)*, buf);};  // TMP 7/20: NEW
    };


  class CppGen_(Alias): public CppGen_(Type), public CppParse(Alias) {
      friend CppGen_FactoryT<CppGen_(Alias), ::iluptype::Type, CppParse(Alias)>;
      CppParseNarrow_FUNCS2(CppGen_(Alias), CppGen_(Type), CppParse(Alias));

      public:  // Override CppGen::Type methods
          virtual ILUCPP_BOOL needsSurrogateSideCleanup () const {
              return CppGen_(Type)::narrow(urType())->needsSurrogateSideCleanup();
          };

      public:  /////////////// common header file
        _cppgen_hpp_DYNOUT_METHOD(Alias, commonDefForward);
          // forward declarations and related typedefs
        _cppgen_hpp_DYNOUT_METHOD(Alias, commonDef);
          // class definition

      public:  // Override CppGen::Type methods
          
          virtual
          void
          sizing (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->sizing(nv, ofs);
          };
          virtual
          void
          send (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->send(nv, ofs);
          };
          virtual
          void
          receive (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->receive(nv, ofs);
          };
          virtual
          void
          surrogateCleanup (const CppGen_(NamedValue) * nv, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->surrogateCleanup(nv, ofs);
          };
          virtual
          void
          surrogatePreProcessing (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->surrogatePreProcessing(parm, ofs);
          };
          virtual
          void
          initialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->initialDeclsInput(nv, sibling, ofs);
          };
          virtual  // TMP 7/15: NEW
          void
          optionalInitialDeclsInput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->optionalInitialDeclsInput(nv, sibling, ofs);
          };
          virtual
          void
          surrogateReceive (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->surrogateReceive(parm, ofs);
          };
          virtual
          void
          initialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->initialDeclsOutput(nv, sibling, ofs);
          };
          virtual  // TMP 7/15: NEW
          void
          optionalInitialDeclsOutput (const CppGen_(NamedValue) * nv, ILUCPP_BOOL sibling, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->optionalInitialDeclsOutput(nv, sibling, ofs);
          };
          virtual
          void
          trueReceive (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->trueReceive(parm, ofs);
          };
          virtual
          void
          truePassToTrueMethod (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->truePassToTrueMethod(parm, ofs);
          };
          virtual
          void
          truePostTrueMethodProcessing (const CppGen_(Parameter) * parm, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->truePostTrueMethodProcessing(parm, ofs);
          };
          virtual  // TMP 8/3: NEW
          void
          optionalCommonDefForward (const CppParseName(TypeName) * optional, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->optionalCommonDefForward(optional, ofs);
          };

    // type registration
	virtual void registerType (CppParseStream(ofstream) &) const;
    
          virtual
          void
          assignValue (const char * to, const char * from, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->assignValue(to, from, ofs);
          };

          virtual  // TMP 9/9: NEW
          void
          optionalAssignValue (const char * to, const char * from, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->optionalAssignValue(to, from, ofs);
          };

          virtual
          void
          unionArmSetDefs (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->unionArmSetDefs(arm, ofs);
          };
          virtual
          void
          unionArmGetDefs (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->unionArmGetDefs(arm, ofs);
          };
          virtual
          void
          unionArmSetImpls (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->unionArmSetImpls(arm, ofs);
          };
          virtual
          void
          unionArmGetImpls (const CppGen_(UnionArm) * arm, CppParseStream(ofstream) & ofs) const {
              CppGen_(Type)::narrow(urType())->unionArmGetImpls(arm, ofs);
          };
          virtual
          ILUCPP_BOOL
          unionDataMemberIsVar () const {
              return CppGen_(Type)::narrow(urType())->unionDataMemberIsVar();
          };

        protected:
	    CppGen_(Alias) (::iluptype::Type from);
  };


  class CppGen_(Object);
    class CppGen_(Array);

    class CppGen_(ArrayDimension): public CppParse(ArrayDimension) {
      friend class CppGen_FactoryT<CppGen_(ArrayDimension), long unsigned, CppParse(ArrayDimension)>;
      CppParseNarrow_FUNCS1(CppGen_(ArrayDimension), CppParse(ArrayDimension));
      protected:
        CppGen_(ArrayDimension) (long unsigned from);
    };

    class CppGen_(ArrayElement): public CppGen_(NamedValue) {
        friend CppGen_(Array);
    public:  // override CppParseName::Name methods
        virtual const char * simpleName (CppParseName(Key) = NULL) const;
    protected:
        CppGen_(ArrayElement) (const CppGen_(Array) *);
    private:
        const CppGen_(Array) * _array;
    };

    class CppGen_(Array): public CppGen_(Type), public CppParse(Array) {
        friend class CppGen_FactoryT<CppGen_(Array), ::iluptype::Type, CppParse(Array)>;
        CppParseNarrow_FUNCS2(CppGen_(Array), CppGen_(Type), CppParse(Array));

    public:
        #ifdef _MSC_VER  // MSVC4.1 Compiler Note #2
            CppGen_(ArrayElement) element;
        #else
            const CppGen_(ArrayElement) element;
        #endif  // _MSC_VER

    public:  // Override CppGen::Type methods
        virtual ILUCPP_BOOL needsSurrogateSideCleanup () const;
        virtual ILUCPP_BOOL needsPostTrueMethodRevise (CppParseName(TypeUsage)) const;

    public:  /////////////// Override CppGen::Type methods for common header file generation
        _cppgen_hpp_DYNOUT_METHOD(Array, commonDefForward);
        // forward declarations and related typedefs for this array
        _cppgen_hpp_DYNOUT_METHOD(Array, commonDef);
        // class declarations related to this array.

    public:  /////////////// Override CppGen::Type methods for common implementation file generation
        _cppgen_hpp_DYNOUT_METHOD(Array, commonImpl);

    public:  // Override CppGen::Type methods
        virtual void sizing (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void send (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void receive (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void surrogateCleanup (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void initialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
        virtual void optionalInitialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 7/15: NEW
        virtual void initialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
        virtual void optionalInitialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 7/15: NEW
        virtual void truePostTrueMethodProcessing (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
        virtual void assignValue (const char *, const char *, CppParseStream(ofstream) &) const;
        virtual void optionalAssignValue (const char *, const char *, CppParseStream(ofstream) &) const;  // TMP 9/9: NEW

	// type registration
	virtual void registerType (CppParseStream(ofstream) &) const;

    public:  // override CppParseName::Name methods
        virtual const char * simpleName (CppParseName(Key) = NULL) const;

    private:
        virtual void outputIOOpImpl (CppGen_(IOOp), CppParseStream(ofstream)&, ILUCPP_BOOL constArray = FALSE) const;
        virtual void outputSurrogateSideCleanupImpl (CppParseStream(ofstream)&, ILUCPP_BOOL constArray = FALSE) const;
/* TMP 7/4
    private:
        const ILUCPP_BOOL _containsObjects;
*/

    protected:  /////////////// support for Union members of typekind Array  // TMP 9/1: NEW

		virtual void unionArmSetDefs (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;
		virtual void unionArmGetDefs (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;
		virtual void unionArmSetImpls (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;
		virtual void unionArmGetImpls (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;
        virtual ILUCPP_BOOL unionDataMemberIsVar () const;  // TMP 9/1: NEW

    protected:  /////////////// support for Alias stream output methods

        virtual void aliasCommonDefForward (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Typedef(s) for an Alias for this Array type.

        virtual void aliasCommonDef (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Function definitions for an Alias for this Array type.

    protected:  /////////////// support for Optional stream output methods

        virtual void optionalCommonDefForward (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Typedef(s) for an Optional for this Array type.

    protected:
        CppGen_(Array) (::iluptype::Type from);

    };


    class CppGen_(Optional): public CppGen_(Type), public CppParse(Optional) {
        friend class CppGen_FactoryT<CppGen_(Optional), ::iluptype::Type, CppParse(Optional)>;
        CppParseNarrow_FUNCS2(CppGen_(Optional), CppGen_(Type), CppParse(Optional));

    public:  // Override CppGen::Type methods
        virtual ILUCPP_BOOL needsSurrogateSideCleanup () const;
        virtual ILUCPP_BOOL needsPostTrueMethodRevise (CppParseName(TypeUsage)) const;

    public:  // Override CppParseName::TypeName method
        virtual const char * simpleName (CppParseName(TypeUsage)) const;

    public:  // Reintroduce CppParseName::TypeName::simpleName (otherwise, above version hides it)
        virtual const char * simpleName (CppParseName(Key) key = NULL) const {
            return CppParseName(TypeName)::simpleName(key);
        };

    public:  // Override CppGen::Type methods
        virtual void sizing (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void send (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void receive (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void surrogateCleanup (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
        virtual void initialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
        virtual void optionalInitialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 6/28: NEW
// TMP 6/28        virtual void surrogateReceive (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
        virtual void initialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
        virtual void optionalInitialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 6/28: NEW
// TMP 6/28        virtual void trueReceive (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
        virtual void truePassToTrueMethod (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;  // TMP 6/29: NEW
        virtual void truePostTrueMethodProcessing (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
        virtual void assignValue (const char *, const char *, CppParseStream(ofstream) &) const;  // TMP 9/9: NEW

    // type registration
	virtual void registerType (CppParseStream(ofstream) &) const;

    public:  /////////////// Override CppGen::Type methods for common header file generation
        _cppgen_hpp_DYNOUT_METHOD(Optional, commonDefForward);
        // forward declarations and related typedefs for this array

    protected:  /////////////// support for Union members of typekind Optional  // TMP 9/4: NEW

		virtual void unionArmSetDefs (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;  // TMP 9/4: NEW
		virtual void unionArmGetDefs (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;  // TMP 9/4: NEW
		virtual void unionArmSetImpls (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;  // TMP 9/4: NEW
		virtual void unionArmGetImpls (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;  // TMP 9/4: NEW
        virtual ILUCPP_BOOL unionDataMemberIsVar () const;  // TMP 9/4: NEW

    protected:  /////////////// support for Alias stream output methods

        virtual void aliasCommonDefForward (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Typedef(s) for an Alias for this Optional type.

    protected:
        CppGen_(Optional) (::iluptype::Type from);

    };


    class CppGen_(Interface);

    
    class CppGen_(ExceptionValue): public CppGen_(NamedValue), public CppParse(ExceptionValue) {
        friend CppGen_FactoryT<CppGen_(ExceptionValue), ::iluptype::Exception, CppParse(ExceptionValue)>;
        CppParseNarrow_FUNCS1(CppGen_(ExceptionValue), CppParse(ExceptionValue));
    protected:
        CppGen_(ExceptionValue) (::iluptype::Exception from);
    };

    class CppGen_(Exception): public virtual CppParse(Exception), public CppParseStream(DynOutObj) {
        friend CppGen_FactoryT<CppGen_(Exception), ::iluptype::Exception, CppParse(Exception)>;
        friend class CppGen_(Interface);
        CppParseNarrow_FUNCS1(CppGen_(Exception), CppParse(Exception));

    public:  /////////////// common header file
        _cppgen_hpp_DYNOUT_METHOD(Exception, commonDefForward);
// TMP 6/14        // forward declarations and related constants
            // forward declarations
        _cppgen_hpp_DYNOUT_METHOD(Exception, commonDef);
        // exception class definition
        _cppgen_hpp_DYNOUT_METHOD(Exception, commonDefIOOperators);
          // input/output operations on this exception

    public:  /////////////// common cpp file
        _cppgen_hpp_DYNOUT_METHOD(Exception, commonImpl);
        _cppgen_hpp_DYNOUT_METHOD(Exception, commonImplIOOperators);
          // input/output operations on this exception

    public:  /////////////// surrogate-side cpp file
// TMP 6/14        _cppgen_hpp_DYNOUT_METHOD(Exception, trueImplSend);
// TMP 6/14          // send this exception
        void trueImplSend (const CppParseName(Scope) *, CppParseStream(ofstream)&) const;  // TMP 6/14: NEW
          // send this exception from within specified Scope  // TMP 6/14: NEW

    public:
// TMP 6/14        int exceptionNum ();
        void indexName (const CppParseName(Scope) *, CppParseStream(ofstream) &) const;
            // Determine name of constant to use to index into exceptions
            // array, and output it on the ofstream. (Constant name is
            // dependent on relationship of this exception to Scope).

	protected:  // override CppParseName::Scope methods
        virtual CppParseName(ContinuationFlag)
			qualify (const char * n, const char ** qn, CppParseName(Key) key, const CppParseName(Scope) * context) const;
        virtual CppParseName(ContinuationFlag)
			qualifyLocal (const char * n, const char ** qn, CppParseName(Key) key) const;

    public:  // override CppParseName::Name methods
		const char * simpleName (CppParseName(Key) = NULL) const;
    
    protected:
        CppGen_(Exception) (::iluptype::Exception from);

// TMP 6/14    private:
// TMP 6/14        int _exceptionNum;

    };

    class CppGen_(IDLException): public CppGen_(Exception), public CppParse(IDLException) {
        // TMP 5/27: perhaps we can remove the "virtual" above, and qualify, qualifylocal and simplename below ?
        friend CppGen_FactoryT<CppGen_(IDLException), ::iluptype::Exception, CppParse(IDLException)>;
        CppParseNarrow_FUNCS2(CppGen_(IDLException), CppGen_(Exception), CppParse(IDLException));

    public:  /////////////// common header file
        _cppgen_hpp_DYNOUT_METHOD(IDLException, commonDef);
        // exception class definition

    public:  /////////////// common cpp file
        _cppgen_hpp_DYNOUT_METHOD(IDLException, commonImpl);
        _cppgen_hpp_DYNOUT_METHOD(IDLException, commonImplIOOperators);
          // input/output operations on this exception

    private:  // override CppParseName::Scope methods
        virtual CppParseName(ContinuationFlag)
	    qualify (const char * n, const char ** qn, CppParseName(Key) key, const CppParseName(Scope) * context) const {
            return CppGen_(Exception)::qualify(n, qn, key, context);
        };
        virtual CppParseName(ContinuationFlag)
	    qualifyLocal (const char * n, const char ** qn, CppParseName(Key) key) const {
            return CppGen_(Exception)::qualifyLocal(n, qn, key);
        };

    public:  // override CppParseName::Name methods
		const char * simpleName (CppParseName(Key) key = NULL) const {
            return CppGen_(Exception)::simpleName(key);
        };
    
    protected:
        CppGen_(IDLException) (::iluptype::Exception from);
    public:  // TMP 5/31
        static CppParse(IDLException) * make (::iluptype::Exception from) {return new(from) CppGen_(IDLException)(from);};  // TMP NEW 6/1
        static CppParse(IDLException) * convert (void * buf) {return STATIC_CAST(CppGen_(IDLException)*, buf);};  // TMP 6/2
    };




    
    class CppGen_(Parameter): public CppGen_(NamedValue), public virtual CppParseNarrow_Root {
      CppParseNarrow_FUNCS0(CppGen_(Parameter));
      friend CppGen_FactoryT<CppGen_(Argument), ::iluptype::Argument, CppParse(Argument)>;
      friend CppGen_FactoryT<CppGen_(ReturnVal), ::iluptype::Procedure, CppParse(ReturnVal)>;

      public:
        virtual ILUCPP_BOOL sibling () const;
        // false if this parameter is not a CppGen::Argument
        
      public:  /////////////// surrogate-side cpp file
        _cppgen_hpp_DYNOUT_METHOD(Parameter, surrogateReceive);
          // read value into this (out, inout) Parameter
        _cppgen_hpp_DYNOUT_METHOD(Parameter, surrogatePreProcessing);
          // any processing relative to this Parameter before construction of call struct
        _cppgen_hpp_DYNOUT_METHOD(Parameter, surrogateCleanup);
          // any cleanup relative to this Parameter before returning

      public:  /////////////// true-side cpp file
        _cppgen_hpp_DYNOUT_METHOD(Parameter, trueReceive);
          // read value into this (out, inout) Parameter
        _cppgen_hpp_DYNOUT_METHOD(Parameter, truePassToTrueMethod);
          // render as formal Parameter to the true object's method
        _cppgen_hpp_DYNOUT_METHOD(Parameter, truePostTrueMethodProcessing);
          // any processing relative to this Parameter after call of true method

      public:  /////////////// override methods inherited from CppGen::NamedValue
        _cppgen_hpp_DYNOUT_METHOD(Parameter, initialDeclsInput);
            // Declarations related to this parameter when used for input (from wire)
            // (On surrogate side, use for out args & return values)
            // (On true side, use for in & inOut args)
        _cppgen_hpp_DYNOUT_METHOD(Parameter, initialDeclsOutput);
            // Declarations related to this parameter when used for output (to wire)
            // (On surrogate side, use for in & inOut args)
            // (On true side, use for out args & return values)

      protected:
          CppGen_(Parameter) (::iluptype::Argument from);
              // for Argument
          CppGen_(Parameter) (::iluptype::Procedure from);
              // for ReturnVal
          CppGen_(Parameter) (const CppParseName(Name)&, CppParseName(TypeUsage), const CppGen_(Type) *);
            // Generic.
    };


    class CppGen_(Argument): public virtual CppParse(Argument), public CppGen_(Parameter) {
      friend CppGen_FactoryT<CppGen_(Argument), ::iluptype::Argument, CppParse(Argument)>;
      CppParseNarrow_FUNCS2(CppGen_(Argument), CppParse(Argument), CppGen_(Parameter));

    public:
        ILUCPP_BOOL sibling () const {
            // Resolve ambiguity between CppParse::Argument::sibling and CppGen::Parameter::sibling
            return CppParse(Argument)::sibling();
        };
        
      protected:
          CppGen_(Argument) (::iluptype::Argument from);
    };


    class CppGen_(ReturnVal): public virtual CppParse(ReturnVal), public CppGen_(Parameter) {
        friend CppGen_FactoryT<CppGen_(ReturnVal), ::iluptype::Procedure, CppParse(ReturnVal)>;
        CppParseNarrow_FUNCS1(CppGen_(ReturnVal), CppParse(ReturnVal));

      public:  // override CppParseName::Name methods
          virtual const char * simpleName (CppParseName(Key) = NULL) const;

      protected:
        CppGen_(ReturnVal) (::iluptype::Procedure);
    };


    class CppGen_(Procedure): public CppParse(Procedure), public CppParseStream(DynOutObj) {
      friend class CppGen_FactoryT<CppGen_(Procedure), ::iluptype::Procedure, CppParse(Procedure)>;
	  friend class CppGen_(Interface);
      CppParseNarrow_FUNCS1(CppGen_(Procedure), CppParse(Procedure));
      public: // stream output
        _cppgen_hpp_DYNOUT_METHOD(Procedure, commonDef);
        _cppgen_hpp_DYNOUT_METHOD(Procedure, commonImplDefineMethod);
          // define method to ILU
        _cppgen_hpp_DYNOUT_METHOD(Procedure, surrogateDef);
          // method prototype
        _cppgen_hpp_DYNOUT_METHOD(Procedure, surrogateDefThrow);
          // method to throw exceptions	from this procedure
        _cppgen_hpp_DYNOUT_METHOD(Procedure, surrogateImpl);
          // surrogate-side "stub"
        _cppgen_hpp_DYNOUT_METHOD(Procedure, surrogateImplThrow);
          // method to throw exceptions
        _cppgen_hpp_DYNOUT_METHOD(Procedure, trueImpl);
          // true-side "stub"
	  public:
		int methodNum ();
      protected:
        CppGen_(Procedure) (::iluptype::Procedure from);
	  private:
		int _methodNum;
    };



    class CppGen_(Object): public CppGen_(Type), public CppParse(Object) {
	friend CppGen_FactoryT<CppGen_(Object), ::iluptype::Type, CppParse(Object)>;
	CppParseNarrow_FUNCS2(CppGen_(Object), CppGen_(Type), CppParse(Object));

      public:  // Override CppGen::Type methods
        virtual ILUCPP_BOOL needsSurrogateSideCleanup () const;
        virtual ILUCPP_BOOL needsPostTrueMethodRevise (CppParseName(TypeUsage)) const;

      public:  /////////////// common header file
        _cppgen_hpp_DYNOUT_METHOD(Object, commonDefForward);
          // forward declarations and related typedefs
        _cppgen_hpp_DYNOUT_METHOD(Object, commonDef);
          // class definition
        _cppgen_hpp_DYNOUT_METHOD(Object, commonDefIOOperators);
          // input/output operations on object

	  public:  /////////////// common cpp file
        _cppgen_hpp_DYNOUT_METHOD(Object, commonImpl);
          // drives the following "commonImpl" methods
        _cppgen_hpp_DYNOUT_METHOD(Object, commonImplDuplicate);
          // duplicate method implementation
        _cppgen_hpp_DYNOUT_METHOD(Object, commonImplNil);
          // _nil method implementation
        _cppgen_hpp_DYNOUT_METHOD(Object, commonImplIluInitialize);
          // iluInitialize method implementation
        _cppgen_hpp_DYNOUT_METHOD(Object, commonImplIluLookup);
          // iluLookup method implementation
        _cppgen_hpp_DYNOUT_METHOD(Object, commonImplIluDowncast);
          // iluDowncast method implementation
        _cppgen_hpp_DYNOUT_METHOD(Object, commonImplTors);
          // constructors/destructor
        _cppgen_hpp_DYNOUT_METHOD(Object, commonImplAssignmentOperator);
          // assignement operator implementation
        _cppgen_hpp_DYNOUT_METHOD(Object, commonImplIOOperators);
          // input/output operations on object
	  
	  public:  /////////////// surrogate-side header file
		_cppgen_hpp_DYNOUT_METHOD(Object, surrogateDef);
          // class definition
        _cppgen_hpp_DYNOUT_METHOD(Object, surrogateDefInitializer);
          // initilializer class definition
	  
	  public:  /////////////// surrogate-side cpp file
        _cppgen_hpp_DYNOUT_METHOD(Object, surrogateImplIluInitialize);
          // iluInitialize method
        _cppgen_hpp_DYNOUT_METHOD(Object, surrogateImplCreate);
          // surrogate creation method
        _cppgen_hpp_DYNOUT_METHOD(Object, surrogateImplInitializer);
          // initializer class methods
        _cppgen_hpp_DYNOUT_METHOD(Object, surrogateImplInitializerInstantiation);
          // instantiation of static initializer
	  
	  public:  /////////////// true-side header file
        _cppgen_hpp_DYNOUT_METHOD(Object, trueDefInitializer);
          // initializer class methods
	  
	  public:  /////////////// true-side cpp file
        _cppgen_hpp_DYNOUT_METHOD(Object, trueImplInitializer);
          // initializer class methods
        _cppgen_hpp_DYNOUT_METHOD(Object, trueImplInitializerInstantiation);
          // class definition
      
      public:  // Override CppGen::Type methods
          virtual void sizing (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
          virtual void send (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
          virtual void surrogateCleanup (const CppGen_(NamedValue) *, CppParseStream(ofstream) &) const;
          virtual void surrogatePreProcessing (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
          virtual void initialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
          virtual void optionalInitialDeclsInput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 6/28: NEW
          virtual void surrogateReceive (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
          virtual void initialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;
          virtual void optionalInitialDeclsOutput (const CppGen_(NamedValue) *, ILUCPP_BOOL sibling, CppParseStream(ofstream) &) const;  // TMP 6/28: NEW
          virtual void trueReceive (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
          virtual void truePostTrueMethodProcessing (const CppGen_(Parameter) *, CppParseStream(ofstream) &) const;
          virtual void assignValue (const char *, const char *, CppParseStream(ofstream) &) const;  // TMP 9/9: NEW
          virtual void optionalAssignValue (const char *, const char *, CppParseStream(ofstream) &) const;  // TMP 9/9: NEW

	// type registration
	virtual void registerType (CppParseStream(ofstream) &) const;

          virtual void unionArmSetDefs (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;
          virtual void unionArmGetDefs (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;
          virtual void unionArmSetImpls (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;
          virtual void unionArmGetImpls (const CppGen_(UnionArm) *, CppParseStream(ofstream) &) const;
          virtual ILUCPP_BOOL unionDataMemberIsVar () const;

      public:  // Override CppParseName::TypeName method
          virtual const char * simpleName (CppParseName(TypeUsage) usage) const;

    protected:  /////////////// support for Alias stream output methods

        virtual void aliasCommonDefForward (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Typedef(s) for an Alias for this Object type.

    protected:  /////////////// support for Optional stream output methods

        virtual void optionalCommonDefForward (const CppParseName(TypeName) *, CppParseStream(ofstream) &) const;
            // Typedef(s) for an Optional for this Object type.

      public:  // Disambiguate functions inherited from Type::Name and Object::Name
          const char *
	  name (const CppParseName(Scope) * context = NULL) const {
	    return CppGen_(Type)::name(context);
	  };
        const char *
	  name (CppParseName(Key) key, const CppParseName(Scope) * context = NULL) const {
	    return CppGen_(Type)::name(key, context);
	  };
        const char *
	  localName (CppParseName(Key) key = NULL) const {
	    return CppGen_(Type)::localName(key);
	  };
        const char *
	  simpleName (CppParseName(Key) key = NULL) const {
	    return CppGen_(Type)::simpleName(key);
	  };
        const CppParseName(Scope) *
	  scope() const {
	    return CppGen_(Type)::scope();
	  };
      protected:
	    CppGen_(Object) (::iluptype::Type from);
      private:  // override CppParseName::Scope methods
        virtual CppParseName(ContinuationFlag)
	    qualify (const char * n, const char ** qn, CppParseName(Key) key, const CppParseName(Scope) * context) const;
        virtual CppParseName(ContinuationFlag)
	    qualifyLocal (const char * n, const char ** qn, CppParseName(Key) key) const;
    public:  // TMP 7/3
        static CppParse(Object) * make (::iluptype::Type from) {return new(from) CppGen_(Object)(from);};  // TMP NEW 7/3
        static CppParse(Object) * convert (void * buf) {return STATIC_CAST(CppGen_(Object)*, buf);};  // TMP 7/3
    };


      class CppGen_(Import): public CppParse(Import) {  // TMP 6/12: NEW
          friend CppGen_FactoryT<CppGen_(Import), ::iluptype::Imported, CppParse(Import)>;  // TMP 6/12: NEW
          CppParseNarrow_FUNCS1(CppGen_(Import), CppParse(Import));  // TMP 6/13: NEW
      protected:  // TMP 6/12: NEW
          CppGen_(Import) (::iluptype::Imported);  // TMP 6/12: NEW
      };  // TMP 6/12: NEW



    class CppGen_(Interface): public CppParse(Interface), public CppParseStream(DynOutObj) {
		friend CppGen_FactoryT<CppGen_(Interface), ::iluptype::Interface, CppParse(Interface)>;
		CppParseNarrow_FUNCS1(CppGen_(Interface), CppParse(Interface));
	public:
        _cppgen_hpp_DYNOUT_METHOD(Interface, commonImplIluInitialize);
          // iluInitialize method implementation
        _cppgen_hpp_DYNOUT_METHOD(Interface, commonImplInitializer);
          // _initializer class
        _cppgen_hpp_DYNOUT_METHOD(Interface, commonDef);
        _cppgen_hpp_DYNOUT_METHOD(Interface, commonDefInitMacros);
          // macros to initilialize interface
        _cppgen_hpp_DYNOUT_METHOD(Interface, commonImpl);
        _cppgen_hpp_DYNOUT_METHOD(Interface, surrogateDef);
        _cppgen_hpp_DYNOUT_METHOD(Interface, surrogateImpl);
        _cppgen_hpp_DYNOUT_METHOD(Interface, trueDef);
        _cppgen_hpp_DYNOUT_METHOD(Interface, trueImpl);
	protected:
        CppGen_(Interface) (::iluptype::Interface from);
	private:  // override CppParseName::Scope methods
        virtual CppParseName(ContinuationFlag)
			qualify (const char * n, const char ** qn, CppParseName(Key) key, const CppParseName(Scope) * context) const;
        virtual CppParseName(ContinuationFlag)
			qualifyLocal (const char * n, const char ** qn, CppParseName(Key) key) const;
	public:  // override CppParseName::Name methods
		const char *
			simpleName (CppParseName(Key) = NULL) const;
	private:
        CppParseName(Key) nameKey;
    };


    #define _cppgen_hpp_DEF_FACTORY(T, FROM, UNUSED1, UNUSED2, UNUSED3)               \
        typedef CppGen_FactoryT<CppGen_(T), FROM, CppParse(T)> CppGen_(T ## Factory);


    CppParse_ENUMERATE_CREATABLES(_cppgen_hpp_DEF_FACTORY)


    NS_EXTERN void CppGen_(post) ();
        // Calls post() for CppGen Bool, and for all CppGen Factory classes


END_NAMESPACE;


#ifdef _MSC_VER  // MSVC4.1 Compiler Note #1
#pragma warning(default: 4250)
#endif  // _MSC_VER



#endif  // _cppgen_hpp_


/*
    G++2.7.1 Compiler Note #1 - The compiler sometimes requires a leading "::" for names from namespace "iluptype" in order to recognize equivalent types. At other times, it prefers *not* to see a leading "::"

    G++2.7.1 Compiler Note #2 - "pragma interface" is part of the G++ mechanism for declaring that a template specialization is "external"; ie, it will be instantiated in another compilation unit which the current unit will link to.

    MSVC4.1 Compiler Note #1 - The compiler will generate Warning C4250 as an informational message ("'XXX' : inherits 'CppGen_Type::name' via dominance"). Inheritance via dominance is a documented behavior of C++.

    MSVC4.1 Compiler Note #2 - In class ArrayElement: if element is const, the compiler will generate an error C2662 in cppgen.cpp ("'__vbaseDtor' : cannot convert 'this' pointer from 'const class CppGen_ArrayElement *' to 'class CppGen_ArrayElement *const '"). In class Exception: similar situation with member _value.

*/
