proc select-size {size} {
  global SIZE ;# the variable SIZE contains the current size of for scale
  set SIZE $size
  
  toplevel .size
  pushGrab local .size
  # the label, which show this size
  label .size.size -text "Size: $size" \
      -font -adobe-*-*-*-*-*-$size-*-*-*-*-*-*-*

  # the scale, which moves from 1 to 100
  scale .size.scale -showvalue yes -from 0 -to 100 -orient horizontal \
      -length 10c -showvalue yes -command setSize
  .size.scale set $size
  button .size.ok -text OK -command {destroy .size}
  pack .size.size .size.scale .size.ok

  # wait until the OK button has been pressed
  tkwait window .size
  popGrab
  return $SIZE
}

# This procedure set the size of the font each time the scale is moved.
proc setSize {size} {
  global SIZE
  set SIZE $size

  .size.size configure -text "Size: $size" \
      -font -adobe-*-*-*-*-*-$size-*-*-*-*-*-*-*
}


