// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qlistbox.h>
#include "Canvas.h"
#include "ListBoxRenderer.h"

ListBoxRenderer::ListBoxRenderer( int         size,
                                  Canvas*     canvas,
                                  int         clipWidth,
                                  QObject*    parent,
                                  const char* name )
        : FormObjectRenderer( canvas, clipWidth, parent, name ),
          _selected( 0 )
{
    _listBox = new QListBox( canvas->clip() );
    canvas->registerWidget( this, _listBox );
    
    int w = 100;
    int h = size * _listBox->itemHeight() + 4;

    _listBox->setGeometry( 4, 4, w, h );

    _minimumWidth = w + 8;
    _maximumWidth = w + 8;
    resize( w + 8, h + 8 );
}

QString ListBoxRenderer::value()
{
    QString nm  = name();
    QString val = _values.at( _listBox->currentItem() );

    if ( ( nm.length() == 0 ) || ( val.length() == 0 ) ) {
        return "";
    }

    Url::encode( nm );
    Url::encode( val );

    QString tmp;
    tmp.sprintf( "%s=%s", nm.data(), val.data() );
    return tmp;
}

void ListBoxRenderer::reset()
{
    _listBox->setCurrentItem( _selected );
}

bool ListBoxRenderer::redraw()
{
    int w = 0;
    uint i;
    for ( i = 0; i < _listBox->count(); i++ ) {
        if ( _listBox->fontMetrics().width( _listBox->text( i ) ) > w ) {
            w = _listBox->fontMetrics().width( _listBox->text( i ) );
        }
    }
    w += 28;
    int h = _listBox->height();

    if ( w != _listBox->width() ) {
        _listBox->resize( w, h );

        _minimumWidth = w + 8;
        _maximumWidth = w + 8;
        resize( w + 8, h + 8 );

        return TRUE;
    }

    return FALSE;
}

void ListBoxRenderer::endOfData()
{
}

void ListBoxRenderer::addItem( const char* text,
                               bool        selected,
                               const char* value )
{
    _listBox->insertItem( text );
    if ( selected ) {
        _listBox->setCurrentItem( _listBox->count() - 1 );
        _selected = _listBox->count() - 1;
    }
    if ( value ) {
        _values.append( value );
    } else {
        _values.append( text );
    }
}
