#include <stdio.h>
#include <errno.h>	
#include "config.h"

/* get news data from stdin and post it to the local server */

void main(int argc,char *argv[]) {
	FILE *pfp=NULL;
	char line[1024];
	int len,count=0,verbose=0, retval=0;

	if (argc>1)  {
		verbose=1;
	}

	while(gets(line) != NULL && retval == 0) {
  		len=strlen(line);
		if (pfp == NULL) {
			if (verbose) {
				printf("posting article %d\n", ++count);
			}
			pfp = popen(RNEWS, "w");
		}
		if(pfp == NULL) {
			perror("Error: cannot open rnews: ");
			retval = -1;
		}
		else if (line[0] == '.' && len == 1) {
			/* end of article */
			if (verbose) {
				printf("end of article %d\n",count);
			}
			if(pfp != NULL) {
				pclose(pfp);
				pfp = NULL;
			}
		}
		else {
			fputs(line, pfp);
			putc('\n', pfp);
		}
	} /* end while */
	exit(retval);
}
