/* This software is Copyright 1995 by Karl-Johan Johnsson
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
 * SOFTWARE IS AT THE USER'S OWN RISK.
 */
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#define KNEWS_VERSION		"0.9.6"

#include "../configure.h"

#ifndef BIN_SH
#  define BIN_SH "/bin/sh"
#endif

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <time.h>
#include <sys/types.h>
#include <regex.h>
#include "../Widgets/ArtTreeNode.h"

extern XtAppContext	app_cont;
extern int		disp_conn_num;

typedef enum {
    NewsModeDisconnected,
    NewsModeConnected,
    NewsModeGroup,
    NewsModeThread,
    NewsModeAllgroups,
    NewsModeNewgroups
} NewsMode;

typedef struct subj_node {
    struct subj_node	*hash_next;
    struct subj_node	*next;
    struct subj_node	*prev;
    struct art_node	*thread;
    char		*subject;
    long		hash_len;
    long		disp;
    long		no_unread;
    short		hot;
    char		has_tagged;
} SUBJECT;

typedef struct art_node {
    ART_TREE_NODE	tree_data;
    struct art_node     *hash_next;
    struct art_node     *next;
    char                *msgid;
    long                hash_len;
    SUBJECT             *subject;
    char                *from;
    char                *xref;
    time_t		date;
    long                no;
    long		lines;
#if 0
    long		bytes;
#endif
    short               hot;
    char		read;
    char		killed;
} ARTICLE;

#define PARENT(art)	((art)->tree_data.parent)
#define CHILD1(art)	((art)->tree_data.child1)
#define SIBLING(art)	((art)->tree_data.sibling)

#define A_PARENT(art)	((ARTICLE *)PARENT(art))
#define A_CHILD1(art)	((ARTICLE *)CHILD1(art))
#define A_SIBLING(art)	((ARTICLE *)SIBLING(art))

typedef enum {
    KillFieldMsgid   = 0,
    KillFieldSubject = 1,
    KillFieldFrom    = 2,
    KillFieldXref    = 3
} KillField;

typedef enum {
    KillScopeArticle   = 0,
    KillScopeSubject   = 1,
    KillScopeThread    = 2,
    KillScopeSubthread = 3
} KillScope;

typedef enum {
    KillActionKill     = 0,
    KillActionHot      = 1,
    KillActionHotish   = 2
} KillAction;

typedef struct {
    char		*expr_str;
    regex_t		*expr_re;
    char		*group_str;
    regex_t		*group_re;
    char		*color;
    Pixel		pixel;
    short		hot;
    unsigned char	field;
    unsigned char	scope;
    unsigned char	action;
    unsigned int	valid : 1,
			applicable : 1,
			unused : 1,
			alloced_pixel : 1,
			msgid_valid : 1;
} KILL_NODE;

#define REGEXP_COMPILE_FLAGS \
((global.icase_regexps ? REG_ICASE : 0) | REG_NOSUB | REG_EXTENDED)

typedef struct art_list_node {
    long                  first;
    long                  last;
    struct art_list_node  *next;
} ART_LIST_NODE;

typedef struct group {
    char		*name;
    char		*description;
    long		no_unread;
    long		first_art;
    long		last_art;
    ART_LIST_NODE	*read_arts;
    long		disp;
    char		subscribed;
    char		moderated;
    char		found_in_newsrc;
    char		ahead_flag;
} GROUP;

extern struct Global {
    String		nntp_server;
    String		config_nntp_server;
    String		config_posting_agent;
    String		edit_command;
    Cursor		cursor;
    Cursor		busy_cursor;
    String		version;
    String		mail_name;
    String		url_command;
    String		config_file;
    String		newsrc_templ;
    String		old_newsrc_templ;
    String		kill_file_templ;
    String		retrieve_descr;
    String		read_active_file;
    String		fill_newsrc_file;
    String		show_number_lines;
    String		keep_thread_info;
    String		check_for_new_groups;
    Pixel		default_hot_pixel;
    Pixel		pixel;
    Pixel		quote_pixel;
    Pixel		header_pixel;
    Pixel		alert_pixel;
    Pixel		clickable_pixel;
    long		stderr_timeout;
    int			chunk_size;
    Boolean		separate_windows;
    Boolean		bell;
    Boolean		head_debug;
    Boolean		use_icon;
    Boolean		confirm_quit;
    Boolean		icase_regexps;
    Boolean		show_cache;
    /* private */
    char		*user_id;
    char		*domain_name;
    char		*home;
    GROUP		**groups;
    long		no_groups;
    long		max_groups;
    GROUP		**new_groups;
    long		no_new_groups;
    SUBJECT		*curr_subj;
    ARTICLE		*curr_art;
    GROUP		*curr_group;
    long		n_hot;
    KILL_NODE		**kill_list;
    int			no_alloc_kill_list;
    Pixmap		*hot_pixmaps;
    int			n_pixmaps;
    time_t		last_time;
    Visual		*visual;
    Colormap		cmap;
    Cardinal		depth;
    NewsMode		mode;
    unsigned int	busy;
    Boolean		aborted;
    Boolean		quit_nicely;
    Boolean		posting_allowed;
    Boolean		xover_supported;
    Boolean             list_active_supported;
} global;

extern struct SERVER		*main_server;
extern struct THREAD_CONTEXT	*main_thr;

#define IS_SPACE(c) \
	((c) == ' ' || (c) == '\t')
#define IS_DOT(buffer) \
	((buffer)[0] == '.' && (buffer)[1] == '\0')
