/* This software is Copyright 1995 by Karl-Johan Johnsson
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
 * SOFTWARE IS AT THE USER'S OWN RISK.
 */
#ifndef PopdownShP_h
#define PopdownShP_h

#include "PopdownSh.h"
#include <X11/ShellP.h>

typedef struct {
    XtPointer	extension;
} PopdownShellClassPart;

typedef struct PopdownShellClassRec {
    CoreClassPart		core_class;
    CompositeClassPart		composite_class;
    ShellClassPart		shell_class;
    OverrideShellClassPart	override_shell_class;
    PopdownShellClassPart	popdown_shell_class;
} PopdownShellClassRec;

extern PopdownShellClassRec	popdownShellClassRec;

typedef struct {
    XtCallbackList	pre_popdown_callback;
    XtCallbackList	callback;
} PopdownShellPart;

typedef struct PopdownShellRec {
    CorePart		core;
    CompositePart	composite;
    ShellPart		shell;
    OverrideShellPart	override;
    PopdownShellPart	popdown;
} PopdownShellRec;

#endif /* PopdownShP_h */
