/* This software is Copyright 1995 by Karl-Johan Johnsson
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
 * SOFTWARE IS AT THE USER'S OWN RISK.
 */
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "Compat.h"
#include "MenuGP.h"

static XtResource resources[] = {
#define offset(field) XtOffsetOf(MenuGadgetRec, menu_g.field)
    {XtNcallback, XtCCallback, XtRCallback, sizeof(XtCallbackList),
     offset(callback), XtRImmediate, (XtPointer)NULL},
#undef offset
};

static void Initialize(Widget, Widget, ArgList, Cardinal*);
static void ClassPartInitialize(WidgetClass);

MenuGadgetClassRec menuGadgetClassRec = {
    { /* rectObj fields */
        (WidgetClass) &rectObjClassRec, /* superclass                   */
        "MenuGadget",                   /* class_name                   */
        sizeof(MenuGadgetRec),	        /* widget_size                  */
        NULL,                           /* class_initialize             */
        ClassPartInitialize,            /* class_part_initialize        */
        FALSE,                          /* class_inited                 */
        Initialize,                     /* initialize                   */
        NULL,                           /* initialize_hook              */
        NULL,                           /* rect1                        */
        NULL,                           /* rect2                        */
        0,                              /* rect3                        */
        resources,                      /* resources                    */
        XtNumber(resources),            /* num_resources                */
        NULLQUARK,                      /* xrm_class                    */
        FALSE,                          /* rect4                        */
        FALSE,                          /* rect5                        */
        FALSE,                          /* rect6                        */
        FALSE,                          /* rect7                        */
        NULL,    			/* destroy                      */
        NULL,                           /* resize                       */
        NULL,                           /* expose                       */
        NULL,                           /* set_values                   */
        NULL,                           /* set_values_hook              */
        XtInheritSetValuesAlmost,       /* set_values_almost            */
        NULL,                           /* get_values_hook              */
        NULL,                           /* rect9                        */
        XtVersion,                      /* version                      */
        NULL,                           /* callback_private             */
        NULL,                           /* rect10                       */
        NULL,                           /* query_geometry               */
        NULL,                           /* rect11                       */
        NULL,                           /* extension                    */
    },
    { /* menu_g fields */
        NULL,				/* change_highlighted		*/
	NULL,				/* call_callbacks		*/
	True,				/* unhighlight_on_leave		*/
	NULL,				/* extension			*/
    }
};

WidgetClass menuGadgetClass = (WidgetClass)&menuGadgetClassRec;

/*********************************************************************************/

static void Initialize(Widget grequest, Widget gnew, ArgList args, Cardinal *no_args)
{
    MenuGadget	new = (MenuGadget)gnew;

    new->menu_g.highlighted = False;
}

static void ClassPartInitialize(WidgetClass gclass)
{
    MenuGadgetClass	class = (MenuGadgetClass)gclass;
    MenuGadgetClass	super_class = (MenuGadgetClass)class->rect_class.superclass;

    if (class->menu_g_class.change_highlighted == XtInheritChangeHighlighted) {
	class->menu_g_class.change_highlighted = super_class->menu_g_class.change_highlighted;
    }
    if (class->menu_g_class.call_callbacks == XtInheritChangeHighlighted) {
	class->menu_g_class.call_callbacks = super_class->menu_g_class.call_callbacks;
    }
}
